/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNameSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(@NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @NotNull Set<String> _result) {
        String oldName;
        if (element == null) {
            PhpNameSuggestionProvider.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            PhpNameSuggestionProvider.$$$reportNull$$$0(1);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Project project = element.getProject();
        if (element instanceof Variable || element instanceof PhpDocVariable) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null) {
                Collection references = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)containingFile)).findAll();
                for (PsiReference reference : references) {
                    if (!(reference instanceof PsiElement)) continue;
                    result.addAll(PhpNameSuggestionUtil.variableNameByPlace((PsiElement)reference));
                }
            }
            result.addAll(PhpNameSuggestionUtil.variableNameByType((PhpTypedElement)element, project, true));
        } else if (element instanceof Constant) {
            value = ((Constant)element).getValue();
            if (value instanceof StringLiteralExpression) {
                result.addAll(PhpNameSuggestionUtil.constantNameByString((StringLiteralExpression)value));
            }
        } else if (element instanceof Field) {
            if (((Field)element).isConstant()) {
                value = ((Field)element).getDefaultValue();
                if (value instanceof StringLiteralExpression) {
                    result.addAll(PhpNameSuggestionUtil.constantNameByString((StringLiteralExpression)value));
                }
            } else {
                PsiFile containingFile;
                PsiElement defaultValue = ((Field)element).getDefaultValue();
                if (defaultValue != null) {
                    result.addAll(PhpNameSuggestionUtil.variableNameByValue(defaultValue));
                }
                if ((containingFile = element.getContainingFile()) != null) {
                    Collection references = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)containingFile)).findAll();
                    for (PsiReference reference : references) {
                        if (!(reference instanceof FieldReference)) continue;
                        result.addAll(PhpNameSuggestionUtil.variableNameByPlace((PsiElement)((FieldReference)reference)));
                    }
                }
                result.addAll(PhpNameSuggestionUtil.variableNameByType((Field)element, project, false));
            }
        } else if (element instanceof Parameter) {
            Function containingFunction = PhpPsiUtil.getParentOfClass(element, true, Function.class);
            if (containingFunction != null) {
                Collection references = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)containingFunction)).findAll();
                for (PsiReference reference : references) {
                    if (!(reference instanceof Variable)) continue;
                    result.addAll(PhpNameSuggestionUtil.variableNameByPlace((PsiElement)((Variable)reference)));
                }
            }
            result.addAll(PhpNameSuggestionUtil.variableNameByType((Parameter)element, project, false));
        } else if (element instanceof PhpFile) {
            result.addAll(PhpNameSuggestionUtil.fileNameByContent((PhpFile)element));
        }
        if (element instanceof PhpNamedElement && StringUtil.isNotEmpty((String)(oldName = ((PhpNamedElement)element).getName()))) {
            result.add(oldName);
        }
        _result.addAll(result);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "_result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/refactoring/rename/PhpNameSuggestionProvider";
        objectArray[2] = "getSuggestedNames";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

