/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.rename.PhpRenamePsiElementProcessor;
import com.jetbrains.php.roots.PhpNamespaceByPsrProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNamespaceRenameProcessor
extends PhpRenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PhpNamespace;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(3);
        }
        Collection<PhpNamespace> namespaces = PhpIndex.getInstance(element.getProject()).getNamespacesByName(((PhpNamespace)element).getFQN());
        for (PhpNamespace namespace : namespaces) {
            allRenames.put((PsiElement)namespace, newName);
            PsiDirectory directory = namespace.getContainingFile().getContainingDirectory();
            List<String> suggestNamespaces = PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(directory);
            String fqn = namespace.getFQN();
            if (!fqn.startsWith("\\") || !suggestNamespaces.contains(fqn.substring(1))) continue;
            allRenames.put((PsiElement)directory, newName);
        }
        super.prepareRenaming(element, newName, allRenames);
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        if (element == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(5);
        }
        if (allRenames == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(7);
        }
        ArrayList<1> collisions = new ArrayList<1>();
        for (UsageInfo info : result) {
            if (!(info instanceof MoveRenameUsageInfo)) continue;
            PsiElement usageElement = info.getElement();
            assert (usageElement != null);
            PsiElement namespaceKeyword = PhpPsiUtil.findPrevSiblingOfAnyType(usageElement, PhpTokenTypes.kwNAMESPACE);
            if (namespaceKeyword == null) continue;
            String newNamespaceName = PhpNamespaceRenameProcessor.getNewNamespaceName(newName, info, usageElement);
            final String conflictDescription = PhpNamespaceRenameProcessor.findExistingNamespaces(element.getProject(), newNamespaceName);
            if (conflictDescription == null) continue;
            PsiElement referencedElement = ((MoveRenameUsageInfo)info).getReferencedElement();
            collisions.add(new UnresolvableCollisionUsageInfo(usageElement, referencedElement){

                public String getDescription() {
                    return conflictDescription;
                }
            });
        }
        result.addAll(collisions);
        super.findCollisions(element, newName, allRenames, result);
    }

    private static String getNewNamespaceName(String newName, UsageInfo info, PsiElement usageElement) {
        ProperTextRange textRange = info.getRangeInElement();
        assert (textRange != null);
        String newParentNamespaceName = StringUtil.replaceSubstring((String)usageElement.getText(), (TextRange)textRange, (String)newName);
        PsiElement identifier = usageElement.getNextSibling();
        return newParentNamespaceName + (PhpPsiUtil.isOfType(identifier, PhpTokenTypes.IDENTIFIER) ? identifier.getText() : "");
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(9);
        }
        if (conflicts == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(10);
        }
        assert (element instanceof PhpNamespace);
        String newFullName = PhpLangUtil.toPresentableFQN(((PhpNamespace)element).getParentNamespaceName() + newName);
        String conflictDescription = PhpNamespaceRenameProcessor.findExistingNamespaces(element.getProject(), newFullName);
        if (conflictDescription != null) {
            conflicts.putValue((Object)element, (Object)conflictDescription);
        }
    }

    @Nullable
    @NlsContexts.DialogMessage
    private static String findExistingNamespaces(@NotNull Project project, @NotNull String newName) {
        if (project == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(11);
        }
        if (newName == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(12);
        }
        String fqn = PhpLangUtil.toFQN(newName);
        Collection<PhpNamespace> conflictNamespaces = PhpIndex.getInstance(project).getNamespacesByName(fqn);
        if (!conflictNamespaces.isEmpty()) {
            StringBuilder builder2 = new StringBuilder(conflictNamespaces.size() > 1 ? "files: " : "file: ");
            Iterator<PhpNamespace> iterator = conflictNamespaces.iterator();
            while (iterator.hasNext()) {
                builder2.append(iterator.next().getContainingFile().getName());
                if (!iterator.hasNext()) continue;
                builder2.append(", ");
            }
            return PhpBundle.message("validation.namespace.already.exists", newName, builder2.toString());
        }
        return null;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(13);
        }
        if (newName == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(14);
        }
        if (usages == null) {
            PhpNamespaceRenameProcessor.$$$reportNull$$$0(15);
        }
        HashSet infos = ContainerUtil.newHashSet((Object[])usages);
        RenameUtil.removeConflictUsages((Set)infos);
        super.renameElement(element, newName, infos.toArray(new UsageInfo[infos.size()]), listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpNamespaceRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findCollisions";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNamespaces";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

