/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.automaticRenamers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.automaticRenamers.ClassInheritorsRenamerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileContainingClassRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        PhpFile containingFile;
        if (element == null) {
            FileContainingClassRenamerFactory.$$$reportNull$$$0(0);
        }
        return element instanceof PhpFile && FileContainingClassRenamerFactory.isFilePSR(containingFile = (PhpFile)element);
    }

    public static boolean isFilePSR(PhpFile containingFile) {
        List<? extends PhpNamedElement> classes = FileContainingClassRenamerFactory.getClasses(containingFile);
        if (classes.size() == 1) {
            PhpClass clazz = (PhpClass)classes.get(0);
            String className = clazz.getName();
            return className.equalsIgnoreCase(PhpNameUtil.getNameWithoutExtension(containingFile.getName()));
        }
        return false;
    }

    public static List<? extends PhpNamedElement> getClasses(PhpFile containingFile) {
        return ContainerUtil.filter((Collection)containingFile.getTopLevelDefs().values(), e -> e instanceof PhpClass);
    }

    @Nls
    @Nullable
    public String getOptionName() {
        return PhpBundle.message("refactoring.rename.automatic.renamer.class.name", new Object[0]);
    }

    public boolean isEnabled() {
        return PhpRefactoringSettings.getInstance().RENAME_CLASS_IN_FILE;
    }

    public void setEnabled(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_CLASS_IN_FILE = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new ClassContainingRenamer((PhpFile)element, newName);
    }

    @NotNull
    public static String nameToCanonicalName(@NonNls String name) {
        String string = PhpNameUtil.getNameWithoutExtension(name);
        if (string == null) {
            FileContainingClassRenamerFactory.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
        String oldName = element.getName();
        assert (oldName != null);
        String extension = PhpNameUtil.getExtension(oldName);
        if (extension.length() > 0) {
            return PhpNameUtil.getFullFileName(canonicalName, extension);
        }
        return canonicalName;
    }

    private static boolean shouldAutoRenameClasses(PhpFile containingFile, String newName, String className) {
        return className.equals(PhpNameUtil.getNameWithoutExtension(containingFile.getName())) && PhpNameUtil.isValidClassName(PhpNameUtil.getNameWithoutExtension(newName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/automaticRenamers/FileContainingClassRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/FileContainingClassRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToCanonicalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ClassContainingRenamer
    extends AutomaticRenamer {
        List<String> myFileNames = new ArrayList<String>();

        ClassContainingRenamer(PhpFile containingFile, String newName) {
            PhpClass clazz;
            String className;
            this.myFileNames.add(containingFile.getName());
            List<? extends PhpNamedElement> classes = FileContainingClassRenamerFactory.getClasses(containingFile);
            if (classes.size() == 1 && FileContainingClassRenamerFactory.shouldAutoRenameClasses(containingFile, newName, className = (clazz = (PhpClass)classes.get(0)).getName())) {
                this.myElements.add(clazz);
                Collection<PhpClass> subclasses = PhpIndex.getInstance(containingFile.getProject()).getDirectSubclasses(clazz.getFQN());
                for (PhpClass subClass : subclasses) {
                    PsiFile containingFileIt = subClass.getContainingFile();
                    if (containingFileIt instanceof PhpFile && FileContainingClassRenamerFactory.isFilePSR((PhpFile)containingFileIt)) {
                        this.myElements.add(containingFileIt);
                        this.myFileNames.add(containingFileIt.getName());
                    }
                    if (subClass.isAnonymous()) continue;
                    this.myElements.add(subClass);
                }
                this.suggestAllNames(containingFile.getName(), newName);
            }
        }

        @Nls
        public String getDialogTitle() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.class.dialog.title", new Object[0]);
        }

        @Nls
        public String getDialogDescription() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.class.dialog.description", new Object[0]);
        }

        public String entityName() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.class.entity.name", new Object[0]);
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<? super UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
            super.findUsages(result, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, allRenames);
            result.removeIf(i -> {
                PsiElement element = i.getElement();
                return element != null && ClassInheritorsRenamerFactory.containsFileNames(this.myFileNames, element.getText()) && i instanceof NonCodeUsageInfo && ((NonCodeUsageInfo)i).getReferencedElement() instanceof PhpFile;
            });
        }

        protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element) {
            return FileContainingClassRenamerFactory.nameToCanonicalName(name);
        }

        protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
            return FileContainingClassRenamerFactory.canonicalNameToName(canonicalName, element);
        }
    }
}

