/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.validation;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFunctionDeclarationInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.refactoring.validation.PhpFunctionConflictDetectorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFunctionConflictDetector
extends PhpFunctionConflictDetectorBase {
    private final Function myFunction;

    public PhpFunctionConflictDetector(Function function) {
        this.myFunction = function;
    }

    @Override
    @Nullable
    @NlsContexts.DialogMessage
    public String findConflicts(final @NotNull String newName) {
        PhpScopeHolder scopeHolder;
        if (newName == null) {
            PhpFunctionConflictDetector.$$$reportNull$$$0(0);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder(this.myFunction)) == null) {
            return null;
        }
        Condition functionExistCondition = instruction -> {
            Function declaration = instruction.getFunctionDeclaration();
            if (PhpLangUtil.equalsFunctionNames(declaration.getName(), newName) || declaration == this.myFunction) {
                final Ref functionNameExists = new Ref((Object)false);
                PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

                    @Override
                    public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
                        Function functionDeclaration = instruction.getFunctionDeclaration();
                        if (PhpLangUtil.equalsFunctionNames(functionDeclaration.getName(), newName) || functionDeclaration == PhpFunctionConflictDetector.this.myFunction) {
                            functionNameExists.set((Object)true);
                            return false;
                        }
                        return true;
                    }
                });
                return (Boolean)functionNameExists.get();
            }
            return false;
        };
        return PhpFunctionConflictDetector.validate(scopeHolder, newName, (Condition<? super PhpFunctionDeclarationInstruction>)functionExistCondition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/jetbrains/php/refactoring/validation/PhpFunctionConflictDetector", "findConflicts"));
    }
}

