/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.validation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class PhpParameterValidator {
    public static ValidationInfo validate(@NotNull Project project, @NotNull List<? extends PhpParameterTemplate> templates) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(0);
        }
        if (templates == null) {
            PhpParameterValidator.$$$reportNull$$$0(1);
        }
        return PhpParameterValidator.validate(project, templates, null);
    }

    @Nullable
    public static ValidationInfo validate(@NotNull Project project, @NotNull List<? extends PhpParameterTemplate> templates, Function context) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(2);
        }
        if (templates == null) {
            PhpParameterValidator.$$$reportNull$$$0(3);
        }
        Set<String> useListNames = PhpParameterValidator.getUseListNames(context);
        HashSet<String> parameterNames = new HashSet<String>();
        boolean initializedParameters = false;
        boolean variadicParameters = false;
        String namespace = context == null ? "\\" : context.getNamespaceName();
        for (PhpParameterTemplate phpParameterTemplate : templates) {
            String initializer;
            String parameterText = phpParameterTemplate.getParameterPreviewText();
            Parameter parameter = PhpParameterValidator.constructParameter(project, parameterText, namespace);
            if (parameter == null) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation", parameterText);
            }
            String name = parameter.getName();
            if (PhpLangUtil.isSuperGlobal(name) || PhpLangUtil.isThisReference(name)) {
                return PhpParameterValidator.newValidation("refactoring.parameter.reserved.name", name);
            }
            String typeDeclarationString = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
            ValidationInfo simpleValidation = PhpParameterValidator.simpleValidation(project, parameter, parameterText, typeDeclarationString, initializer = PhpFunctionCodeGenerator.getInitializer(parameter), phpParameterTemplate.getDefaultValue());
            if (simpleValidation != null) {
                return simpleValidation;
            }
            if (!parameterNames.add(name)) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.duplicate.parameter", name);
            }
            if (useListNames.contains(name)) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.name.collision.with.use.list", parameterText);
            }
            String defaultValue = StringUtil.notNullize((String)phpParameterTemplate.getDefaultValue());
            if (StringUtil.isNotEmpty((String)initializer)) {
                initializedParameters = true;
                if (StringUtil.isNotEmpty((String)typeDeclarationString) && !PhpParameterValidator.isArray(parameter.getDeclaredType()) && !"null".equalsIgnoreCase(initializer) && !PhpType.intersects(parameter.getDeclaredType(), PhpType.SCALAR)) {
                    return PhpParameterValidator.newValidation("refactoring.parameter.validation.initializer.type", new Object[0]);
                }
                if (phpParameterTemplate.isVariadic()) {
                    return PhpParameterValidator.newValidation("refactoring.parameter.validation.variadic.can.have.default.value", new Object[0]);
                }
            } else if (initializedParameters && !phpParameterTemplate.isVariadic()) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.initializer.last", new Object[0]);
            }
            if (variadicParameters) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.variadic.last", new Object[0]);
            }
            if (phpParameterTemplate.isVariadic()) {
                variadicParameters = true;
            }
            if (phpParameterTemplate.shouldBeInitialized() && StringUtil.isEmpty((String)defaultValue) && StringUtil.isEmpty((String)initializer)) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.no.default.value", parameterText);
            }
            if (!parameter.isPassByRef() || PhpParameterValidator.canBePassByRef(project, defaultValue)) continue;
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.pass.by.reference", new Object[0]);
        }
        return null;
    }

    private static boolean isArray(PhpType type) {
        int size = type.getTypes().size();
        return PhpType.intersects(type, PhpType.ARRAY) && (size == 1 || size == 2 && PhpType.intersects(PhpType.NULL, type));
    }

    private static boolean canBePassByRef(@NotNull Project project, @Nullable String expression) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)expression)) {
            assert (expression != null);
            Variable variable = PhpPsiElementFactory.createFirstFromText(project, Variable.class, expression);
            return variable != null && expression.trim().equals(variable.getText().trim());
        }
        return true;
    }

    @Nullable
    public static ValidationInfo validateAndCommit(@NotNull Project project, @NotNull List<? extends PhpParameterTemplate> templates, @NotNull String namespace) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(5);
        }
        if (templates == null) {
            PhpParameterValidator.$$$reportNull$$$0(6);
        }
        if (namespace == null) {
            PhpParameterValidator.$$$reportNull$$$0(7);
        }
        for (PhpParameterTemplate phpParameterTemplate : templates) {
            Parameter parameter = PhpParameterValidator.constructParameter(project, phpParameterTemplate.getParameterPreviewText(), namespace);
            ValidationInfo simpleValidation = PhpParameterValidator.validateParameter(project, parameter, phpParameterTemplate.getParameterPreviewText(), phpParameterTemplate.getDefaultValue());
            if (simpleValidation != null) {
                return simpleValidation;
            }
            phpParameterTemplate.updateParameter(parameter);
        }
        return null;
    }

    @Nullable
    public static ValidationInfo validateParameter(@NotNull Project project, @Nullable Parameter parameter, String previewText, String defaultValue) {
        String initializer;
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(8);
        }
        if (parameter == null) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation", previewText);
        }
        String type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
        ValidationInfo simpleValidation = PhpParameterValidator.simpleValidation(project, parameter, previewText, type, initializer = PhpFunctionCodeGenerator.getInitializer(parameter), defaultValue);
        if (simpleValidation != null) {
            return simpleValidation;
        }
        return null;
    }

    @Nullable
    private static ValidationInfo simpleValidation(@NotNull Project project, @NotNull Parameter newParameter, @NotNull String parameterText, @NotNull String type, @NotNull String initializer, @Nullable String defaultValue) {
        Method method;
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(9);
        }
        if (newParameter == null) {
            PhpParameterValidator.$$$reportNull$$$0(10);
        }
        if (parameterText == null) {
            PhpParameterValidator.$$$reportNull$$$0(11);
        }
        if (type == null) {
            PhpParameterValidator.$$$reportNull$$$0(12);
        }
        if (initializer == null) {
            PhpParameterValidator.$$$reportNull$$$0(13);
        }
        if (!newParameter.getText().equals(parameterText)) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation", parameterText);
        }
        String name = newParameter.getName();
        if (!PhpNameUtil.isValidParameterName(name)) {
            return PhpParameterValidator.newValidation("validation.invalid.identifier", name);
        }
        if (StringUtil.isNotEmpty((String)type) && !PhpParameterValidator.isPrimitiveParameterType(type) && (method = PhpPsiElementFactory.createPhpPsiFromText(project, Method.class, "class A {function f(): " + type + " {}}")).getTypeDeclaration() == null) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.type", type);
        }
        if (!PhpParameterValidator.validateExpression(project, initializer, false)) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.initializer", initializer);
        }
        if (!PhpParameterValidator.validateExpression(project, defaultValue, newParameter.isVariadic())) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.default.value", defaultValue);
        }
        return null;
    }

    private static boolean isPrimitiveParameterType(@NotNull String type) {
        String fqn;
        if (type == null) {
            PhpParameterValidator.$$$reportNull$$$0(14);
        }
        return PhpType.isArray(fqn = PhpLangUtil.toFQN(type)) || "\\callable".equals(fqn);
    }

    private static boolean validateExpression(@NotNull Project project, @Nullable String expression, boolean canBeExpressionList) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(15);
        }
        if (StringUtil.isNotEmpty((String)expression)) {
            if (canBeExpressionList) {
                List expressionElements = StringUtil.split((String)expression, (String)",");
                for (String expressionElement : expressionElements) {
                    boolean isValid = PhpParameterValidator.validateExpressionElement(project, expressionElement);
                    if (isValid) continue;
                    return false;
                }
            } else {
                return PhpParameterValidator.validateExpressionElement(project, expression);
            }
        }
        return true;
    }

    private static boolean validateExpressionElement(@NotNull Project project, @NotNull String expression) {
        PhpExpression element;
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(16);
        }
        if (expression == null) {
            PhpParameterValidator.$$$reportNull$$$0(17);
        }
        return (element = PhpPsiElementFactory.createFirstFromText(project, PhpExpression.class, expression)) != null && expression.trim().equals(element.getText().trim());
    }

    private static ValidationInfo newValidation(@PropertyKey(resourceBundle="messages.PhpBundle") @NotNull @PropertyKey(resourceBundle="messages.PhpBundle") @NotNull String messagePath, Object ... parameters) {
        if (messagePath == null) {
            PhpParameterValidator.$$$reportNull$$$0(18);
        }
        return new ValidationInfo(PhpBundle.message(messagePath, parameters));
    }

    @Nullable
    public static Parameter constructParameter(@NotNull Project project, @NotNull String parameter, @NotNull String namespace) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(19);
        }
        if (parameter == null) {
            PhpParameterValidator.$$$reportNull$$$0(20);
        }
        if (namespace == null) {
            PhpParameterValidator.$$$reportNull$$$0(21);
        }
        if (StringUtil.isEmpty((String)parameter)) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        if (!namespace.isEmpty() && !namespace.equals("\\")) {
            builder2.append("namespace ");
            builder2.append(namespace.startsWith("\\") ? namespace.substring(1) : namespace);
            builder2.append(";");
        }
        builder2.append("function foo(");
        builder2.append(parameter);
        builder2.append("){}");
        return PhpPsiElementFactory.createFromText(project, Parameter.class, builder2.toString());
    }

    @NotNull
    public static Set<String> getUseListNames(Function method) {
        PhpUseList useList = (PhpUseList)PsiTreeUtil.findChildOfType((PsiElement)method, PhpUseList.class);
        Set<String> set = useList != null ? Arrays.stream(useList.getChildren()).filter(e -> e instanceof Variable).map(e -> ((Variable)e).getName()).collect(Collectors.toSet()) : Collections.emptySet();
        if (set == null) {
            PhpParameterValidator.$$$reportNull$$$0(22);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterText";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/validation/PhpParameterValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/validation/PhpParameterValidator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseListNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canBePassByRef";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateAndCommit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateParameter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "simpleValidation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveParameterType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateExpressionElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newValidation";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "constructParameter";
                break;
            }
            case 22: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22 -> new IllegalStateException(string);
        };
    }
}

