/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.robo.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.robo.run.RoboRunConfiguration;
import com.jetbrains.php.robo.run.RoboRunConfigurationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RoboRunConfigurationProducer
extends LazyRunConfigurationProducer<RoboRunConfiguration> {
    public static final String ROBO_EXE = "robo";
    public static final String ROBO_TASKS = "\\Robo\\Tasks";

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RoboRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            RoboRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull RoboRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Method method;
        if (configuration == null) {
            RoboRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RoboRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            RoboRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (RoboRunConfigurationProducer.isRoboTaskMethod(method = PhpPsiUtil.getParentOfClass(context.getPsiLocation(), Method.class))) {
            RoboRunConfigurationProducer.setUpConfiguration(configuration, RoboRunConfigurationProducer.getTaskName(method), method.getContainingFile());
            return true;
        }
        return false;
    }

    public static void setUpConfiguration(@NotNull RoboRunConfiguration configuration, String taskName, PsiFile file) {
        if (configuration == null) {
            RoboRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        String roboPath = file.getVirtualFile().getPath();
        configuration.setRoboExeAndTaskName(roboPath, taskName);
        String roboExePath = ComposerConfigUtils.findVendorExecutablePath(file.getProject(), roboPath, ROBO_EXE);
        configuration.setRoboExePath(roboExePath);
    }

    public static boolean isRoboTaskMethod(@Nullable Method method) {
        if (method == null || !method.getAccess().isPublic()) {
            return false;
        }
        if (StringUtil.startsWithIgnoreCase((String)method.getName(), (String)"set") || StringUtil.startsWithIgnoreCase((String)method.getName(), (String)"get")) {
            return RoboRunConfigurationProducer.getTaskNameFromComment(method) != null;
        }
        return RoboRunConfigurationProducer.isRoboTaskClass(method.getContainingClass());
    }

    public static boolean isRoboTaskClass(PhpClass phpClass) {
        return phpClass != null && PhpLangUtil.equalsClassNames(phpClass.getSuperFQN(), ROBO_TASKS);
    }

    @NlsSafe
    public static String getTaskName(Method method) {
        String taskName = RoboRunConfigurationProducer.getTaskNameFromComment(method);
        if (taskName != null) {
            return taskName;
        }
        return RoboRunConfigurationProducer.convertCamelCaseToTaskName(method.getName());
    }

    @Nullable
    private static String getTaskNameFromComment(Method method) {
        PhpDocTag[] tags;
        PhpDocComment comment = method.getDocComment();
        PhpDocTag[] phpDocTagArray = tags = comment != null ? method.getDocComment().getTagElementsByName("@command") : PhpDocTag.EMPTY_ARRAY;
        if (tags.length > 0) {
            return tags[0].getTagValue();
        }
        return null;
    }

    @NlsSafe
    private static String convertCamelCaseToTaskName(String methodName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < methodName.length(); ++i) {
            char ch = methodName.charAt(i);
            if (i > 0 && Character.isLowerCase(methodName.charAt(i - 1)) && Character.isUpperCase(ch)) {
                sb.append("-");
            }
            sb.append(ch);
        }
        return StringUtil.toLowerCase((String)sb.toString().replaceFirst("-", ":"));
    }

    public boolean isConfigurationFromContext(@NotNull RoboRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Method method;
        if (configuration == null) {
            RoboRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            RoboRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (RoboRunConfigurationProducer.isRoboTaskMethod(method = PhpPsiUtil.getParentOfClass(context.getPsiLocation(), Method.class))) {
            String roboPath = method.getContainingFile().getVirtualFile().getPath();
            String roboExePath = ComposerConfigUtils.findVendorExecutablePath(method.getProject(), roboPath, ROBO_EXE);
            return RoboRunConfigurationProducer.getTaskName(method).equals(configuration.getTaskName()) && roboExePath.equals(configuration.getRoboExePath()) && roboPath.equals(configuration.getRoboFilePath());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/robo/run/RoboRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/robo/run/RoboRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUpConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

