/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.robo.run;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.CachedValue;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class RoboTasksToolWindowUpdateService
implements Disposable {
    @NotNull
    private static final Key<CachedValue<Collection<PhpClass>>> ROBO_TASKS = Key.create((String)"php.robo.tasks");
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private final Project myProject;
    private final MyPsiTreeChangeListener myListener = new MyPsiTreeChangeListener();

    public RoboTasksToolWindowUpdateService(Project project) {
        this.myProject = project;
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this.myListener, (Disposable)this);
    }

    private void queueReloadRoboTaskToolWindow() {
        if (LightEdit.owns((Project)this.myProject)) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (!this.myAlarm.isDisposed()) {
            this.myAlarm.addRequest(this::reloadRoboTaskToolWindow, 10);
        }
    }

    private void reloadRoboTaskToolWindow() {
        ReadAction.nonBlocking(this::isRoboTaskClassExists).finishOnUiThread(ModalityState.nonModal(), isRoboTaskClassExists -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Robo tasks");
            if (toolWindow != null) {
                toolWindow.setAvailable(isRoboTaskClassExists.booleanValue());
            }
        }).inSmartMode(this.myProject).expireWith((Disposable)this).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private boolean isRoboTaskClassExists() {
        PhpIndex index = PhpIndex.getInstance(this.myProject);
        VirtualFile[] roots = null;
        for (PhpClass aClass : index.getLibClassesCached("\\Robo\\Tasks", ROBO_TASKS)) {
            if (roots == null) {
                roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
            }
            if (!RoboTasksToolWindowUpdateService.isSubclassInSourceRootsExists(index, aClass, roots)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubclassInSourceRootsExists(PhpIndex index, PhpClass aClass, VirtualFile[] finalRoots) {
        return index.subclassExists(aClass, c -> RoboTasksToolWindowUpdateService.isFromSourceRoot(finalRoots, c));
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myListener);
    }

    private static boolean isFromSourceRoot(VirtualFile[] roots, PhpClass c) {
        return ContainerUtil.exists((Object[])roots, root -> VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)c.getContainingFile().getVirtualFile(), (boolean)true));
    }

    private class MyPsiTreeChangeListener
    extends PsiTreeAnyChangeAbstractAdapter {
        private MyPsiTreeChangeListener() {
        }

        protected void onChange(@Nullable PsiFile file) {
            RoboTasksToolWindowUpdateService.this.queueReloadRoboTaskToolWindow();
        }
    }

    public static class RoboBulkFileListener
    implements BulkFileListener {
        private final Project myProject;

        public RoboBulkFileListener(@NotNull Project project) {
            if (project == null) {
                RoboBulkFileListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                RoboBulkFileListener.$$$reportNull$$$0(1);
            }
            if (this.myProject.isDisposed() || !this.myProject.isInitialized()) {
                return;
            }
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            boolean belongsToCurrentProject = StreamEx.of(events).map(e -> e.getFile()).nonNull().anyMatch(arg_0 -> ((ProjectFileIndex)projectFileIndex).isInContent(arg_0));
            if (belongsToCurrentProject) {
                ((RoboTasksToolWindowUpdateService)this.myProject.getService(RoboTasksToolWindowUpdateService.class)).queueReloadRoboTaskToolWindow();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/robo/run/RoboTasksToolWindowUpdateService$RoboBulkFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RoboDumbModeListener
    implements DumbService.DumbModeListener {
        private final Project myProject;

        public RoboDumbModeListener(@NotNull Project project) {
            if (project == null) {
                RoboDumbModeListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void exitDumbMode() {
            ((RoboTasksToolWindowUpdateService)this.myProject.getService(RoboTasksToolWindowUpdateService.class)).queueReloadRoboTaskToolWindow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/robo/run/RoboTasksToolWindowUpdateService$RoboDumbModeListener", "<init>"));
        }
    }
}

