/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.robo.run;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.robo.run.RoboTasksToolWindowFactory;
import com.jetbrains.php.robo.run.RoboTasksViewerKt;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\rH\u0002J\f\u0010\u0019\u001a\u00020\u0018*\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/php/robo/run/RoboTasksViewer;", "", "project", "Lcom/intellij/openapi/project/Project;", "roboClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/php/lang/psi/elements/PhpClass;Lcom/intellij/openapi/wm/ToolWindow;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myTree", "Lcom/intellij/ui/treeStructure/Tree;", "getContent", "Ljavax/swing/JComponent;", "createTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "createToolWindowPanel", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "tree", "createTreeRoot", "Ljavax/swing/tree/DefaultMutableTreeNode;", "installDoubleClickListener", "", "installSpeedSearch", "rebuildTasks", "MyEditorListener", "intellij.php.impl"})
public final class RoboTasksViewer {
    @NotNull
    private final Project project;
    @NotNull
    private final Tree myTree;

    public RoboTasksViewer(@NotNull Project project, @NotNull PhpClass roboClass, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)roboClass, (String)"roboClass");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.project = project;
        this.myTree = new Tree((TreeModel)this.createTreeModel(roboClass));
        this.installDoubleClickListener(this.myTree);
        this.installSpeedSearch(this.myTree);
        MessageBus messageBus = roboClass.getProject().getMessageBus();
        Disposable disposable = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection messageBusConnection = messageBus.connect(disposable);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new MyEditorListener(this));
        MessageBus messageBus2 = roboClass.getProject().getMessageBus();
        Disposable disposable2 = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"getDisposable(...)");
        MessageBusConnection messageBusConnection2 = messageBus2.connect(disposable2);
        Topic topic2 = PsiModificationTracker.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, () -> RoboTasksViewer._init_$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JComponent getContent() {
        return (JComponent)this.createToolWindowPanel(this.myTree);
    }

    private final DefaultTreeModel createTreeModel(PhpClass roboClass) {
        return new DefaultTreeModel(this.createTreeRoot(roboClass));
    }

    private final SimpleToolWindowPanel createToolWindowPanel(Tree tree) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)tree), (int)20, (int)30);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane pane = jScrollPane;
        SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(true);
        toolWindowPanel.add((Component)pane);
        return toolWindowPanel;
    }

    private final DefaultMutableTreeNode createTreeRoot(PhpClass roboClass) {
        List<String> tasks = RoboTasksViewerKt.getTaskNames(roboClass);
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("Robo tasks", true);
        for (String task : tasks) {
            treeRoot.add(new DefaultMutableTreeNode(task));
        }
        return treeRoot;
    }

    private final void installDoubleClickListener(Tree $this$installDoubleClickListener) {
        new DoubleClickListener($this$installDoubleClickListener, this){
            final /* synthetic */ Tree $this_installDoubleClickListener;
            final /* synthetic */ RoboTasksViewer this$0;
            {
                this.$this_installDoubleClickListener = $receiver;
                this.this$0 = $receiver2;
            }

            protected boolean onDoubleClick(MouseEvent e) {
                Object path;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TreePath treePath = this.$this_installDoubleClickListener.getClosestPathForLocation(e.getX(), e.getY());
                Object object = path = treePath != null ? treePath.getLastPathComponent() : null;
                if (path instanceof DefaultMutableTreeNode) {
                    Object object2 = ((DefaultMutableTreeNode)path).getUserObject();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                    RoboTasksViewerKt.runTask((String)object2, this.this$0.getProject());
                    return true;
                }
                return false;
            }
        }.installOn((Component)$this$installDoubleClickListener);
    }

    private final void installSpeedSearch(Tree $this$installSpeedSearch) {
        TreeSpeedSearch.installOn((JTree)((JTree)$this$installSpeedSearch), (boolean)true, arg_0 -> RoboTasksViewer.installSpeedSearch$lambda$2(RoboTasksViewer::installSpeedSearch$lambda$1, arg_0));
    }

    private final void rebuildTasks() {
        this.myTree.setModel((TreeModel)this.createTreeModel(RoboTasksToolWindowFactory.findRoboClassFromOpenedFiles(this.project)));
    }

    private static final void _init_$lambda$0(RoboTasksViewer this$0) {
        this$0.rebuildTasks();
    }

    private static final String installSpeedSearch$lambda$1(TreePath it) {
        String string;
        Object component = it.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)component).getUserObject() instanceof String) {
            Object object = ((DefaultMutableTreeNode)component).getUserObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        } else {
            string = "";
        }
        return string;
    }

    private static final String installSpeedSearch$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/php/robo/run/RoboTasksViewer$MyEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "roboTasksViewer", "Lcom/jetbrains/php/robo/run/RoboTasksViewer;", "<init>", "(Lcom/jetbrains/php/robo/run/RoboTasksViewer;)V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.php.impl"})
    private static final class MyEditorListener
    implements FileEditorManagerListener,
    CaretListener {
        @NotNull
        private final RoboTasksViewer roboTasksViewer;

        public MyEditorListener(@NotNull RoboTasksViewer roboTasksViewer) {
            Intrinsics.checkNotNullParameter((Object)roboTasksViewer, (String)"roboTasksViewer");
            this.roboTasksViewer = roboTasksViewer;
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.roboTasksViewer.rebuildTasks();
        }
    }
}

