/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.roots.PhpDirectoryProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;

public class PhpDirectoryByPsrProvider
implements PhpDirectoryProvider {
    private static final PhpDirectoryProvider ourDefaultProvider = new PhpDirectoryByPsrProvider();
    private static final PhpDirectoryProvider ourBySourceRootProvider = new PhpDirectoryBySourceRootProvider();
    private static final List<PhpDirectoryProvider> myProviders = new ArrayList<PhpDirectoryProvider>();

    public static PhpDirectoryProvider getDefaultProvider() {
        return ourDefaultProvider;
    }

    public static PhpDirectoryProvider getSourceRootProvide() {
        return ourBySourceRootProvider;
    }

    @Override
    @NotNull
    public List<String> suggestDirectories(@NotNull Project project, @NotNull String toNamespaceName, @NotNull VirtualFile fromDir, @Nullable String fromNamespace) {
        if (project == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(0);
        }
        if (toNamespaceName == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(1);
        }
        if (fromDir == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(2);
        }
        ArrayList<String> directories = new ArrayList<String>();
        for (PhpDirectoryProvider provider : myProviders) {
            List<String> suggestions = provider.suggestDirectories(project, toNamespaceName, fromDir, fromNamespace);
            for (String suggestion : suggestions) {
                if (directories.contains(suggestion)) continue;
                directories.add(suggestion);
            }
        }
        ArrayList<String> arrayList = directories;
        if (arrayList == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> suggestDirectories(@NotNull Project project, @NotNull VirtualFile contextDir, @NotNull String namespaceName) {
        if (project == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(4);
        }
        if (contextDir == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(5);
        }
        if (namespaceName == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(6);
        }
        ArrayList<String> directories = new ArrayList<String>();
        for (PhpDirectoryProvider provider : myProviders) {
            List<String> suggestions = provider.suggestDirectories(project, contextDir, namespaceName);
            for (String suggestion : suggestions) {
                if (directories.contains(suggestion)) continue;
                directories.add(suggestion);
            }
        }
        ArrayList<String> arrayList = directories;
        if (arrayList == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static String suggestDirectory(@Nullable String prefix, @Nullable VirtualFile root, @NotNull String namespace) {
        if (namespace == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(8);
        }
        if (prefix == null || root == null || !PhpDirectoryByPsrProvider.containsPrefix(prefix, namespace)) {
            return null;
        }
        StringBuilder url = new StringBuilder(root.getUrl());
        String namespaceWithoutPrefix = PhpDirectoryByPsrProvider.cutPrefix(namespace, prefix);
        if (StringUtil.isNotEmpty((String)namespaceWithoutPrefix)) {
            url.append("/");
            url.append(namespaceWithoutPrefix);
        }
        return PathUtil.toPresentableUrl((String)url.toString());
    }

    @NotNull
    public static String cutPrefix(@NotNull String namespace, @NotNull String prefix) {
        int i;
        if (namespace == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(10);
        }
        int n = i = prefix.length() == 0 ? 0 : StringUtil.indexOf((CharSequence)namespace, (char)'\\', (int)(prefix.length() - 1));
        if (i >= 0 && i < namespace.length()) {
            String string = i == 0 ? namespace : namespace.substring(i + 1);
            if (string == null) {
                PhpDirectoryByPsrProvider.$$$reportNull$$$0(11);
            }
            return string;
        }
        return "";
    }

    public static boolean containsPrefix(@NotNull String prefix, @NotNull String namespace) {
        if (prefix == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(12);
        }
        if (namespace == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(13);
        }
        if (!StringUtil.startsWith((CharSequence)namespace, (CharSequence)prefix)) {
            return false;
        }
        if (prefix.isEmpty() || namespace.length() == prefix.length()) {
            return true;
        }
        return prefix.endsWith("\\") || namespace.charAt(prefix.length()) == '\\';
    }

    @NotNull
    public static String getFolderPrefix(@NotNull SourceFolder folder) {
        if (folder == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(14);
        }
        String prefix = StringUtil.replace((String)folder.getPackagePrefix(), (String)"/", (String)"\\");
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)prefix, (String)"\\"), (String)"\\");
        if (string == null) {
            PhpDirectoryByPsrProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    static {
        myProviders.add(new PhpDirectoryByExistingNamespacesProvider());
        myProviders.add(new PhpDirectoryByRelativeNamespacesProvider());
        myProviders.add(new PhpDirectoryByAllSourceRootsProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNamespaceName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestDirectories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cutPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestDirectories";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "suggestDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cutPrefix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFolderPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 11, 15 -> new IllegalStateException(string);
        };
    }

    private static class PhpDirectoryBySourceRootProvider
    implements PhpDirectoryProvider {
        private PhpDirectoryBySourceRootProvider() {
        }

        @Override
        @NotNull
        public List<String> suggestDirectories(@NotNull Project project, @NotNull VirtualFile contextDir, @NotNull String namespaceName) {
            VirtualFile root;
            if (project == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(0);
            }
            if (contextDir == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(2);
            }
            if ((root = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(contextDir)) == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
            List<String> list = PhpDirectoryBySourceRootProvider.findSourceRoots(project, contextDir, root).map(source -> PhpDirectoryByPsrProvider.suggestDirectory(PhpDirectoryByPsrProvider.getFolderPrefix(source), root, namespaceName)).filter(directory -> directory != null).collect(Collectors.toList());
            if (list == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private static Stream<SourceFolder> findSourceRoots(@NotNull Project project, @NotNull VirtualFile context, @NotNull VirtualFile root) {
            if (project == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(5);
            }
            if (context == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(6);
            }
            if (root == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(7);
            }
            Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(context);
            VirtualFile contentRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(context);
            if (module == null || contentRoot == null) {
                Stream<SourceFolder> stream = Stream.empty();
                if (stream == null) {
                    PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(8);
                }
                return stream;
            }
            Stream<SourceFolder> stream = Stream.of(ModuleRootManager.getInstance((Module)module).getContentEntries()).filter(entry -> contentRoot.equals(entry.getFile())).flatMap(entry -> Stream.of(entry.getSourceFolders())).filter(source -> root.equals(source.getFile()));
            if (stream == null) {
                PhpDirectoryBySourceRootProvider.$$$reportNull$$$0(9);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryBySourceRootProvider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryBySourceRootProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestDirectories";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findSourceRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestDirectories";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findSourceRoots";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpDirectoryByExistingNamespacesProvider
    implements PhpDirectoryProvider {
        private PhpDirectoryByExistingNamespacesProvider() {
        }

        @Override
        @NotNull
        public List<String> suggestDirectories(@NotNull Project project, @NotNull VirtualFile contextDir, @NotNull String namespaceName) {
            Collection<PhpNamespace> namespaces;
            if (project == null) {
                PhpDirectoryByExistingNamespacesProvider.$$$reportNull$$$0(0);
            }
            if (contextDir == null) {
                PhpDirectoryByExistingNamespacesProvider.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                PhpDirectoryByExistingNamespacesProvider.$$$reportNull$$$0(2);
            }
            if ((namespaces = PhpIndex.getInstance(project).getNamespacesByName(PhpLangUtil.toFQN(namespaceName))).isEmpty()) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    PhpDirectoryByExistingNamespacesProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
            String contextPath = contextDir.getPath();
            SmartList closeSuggestions = new SmartList();
            SmartList otherSuggestions = new SmartList();
            HashSet<String> processedDirectories = new HashSet<String>();
            for (PhpNamespace namespace : namespaces) {
                String path;
                VirtualFile directoryFile = namespace.getContainingFile().getContainingDirectory().getVirtualFile();
                boolean isInProject = ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(directoryFile);
                if (!isInProject || !processedDirectories.add(path = directoryFile.getPath())) continue;
                if (FileUtil.isAncestor((String)contextPath, (String)path, (boolean)false) || FileUtil.isAncestor((String)path, (String)contextPath, (boolean)false)) {
                    closeSuggestions.add(directoryFile.getPresentableUrl());
                    continue;
                }
                otherSuggestions.add(directoryFile.getPresentableUrl());
            }
            closeSuggestions.addAll(otherSuggestions);
            SmartList smartList = closeSuggestions;
            if (smartList == null) {
                PhpDirectoryByExistingNamespacesProvider.$$$reportNull$$$0(4);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryByExistingNamespacesProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryByExistingNamespacesProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestDirectories";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpDirectoryByRelativeNamespacesProvider
    implements PhpDirectoryProvider {
        private PhpDirectoryByRelativeNamespacesProvider() {
        }

        @Override
        @NotNull
        public List<String> suggestDirectories(@NotNull Project project, @NotNull VirtualFile contextDir, @NotNull String namespaceName) {
            if (project == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(0);
            }
            if (contextDir == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(2);
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> suggestDirectories(@NotNull Project project, @NotNull String toNamespaceName, @NotNull VirtualFile fromDir, @Nullable String fromNamespace) {
            if (project == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(4);
            }
            if (toNamespaceName == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(5);
            }
            if (fromDir == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(6);
            }
            if (fromNamespace == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(7);
                }
                return list;
            }
            String mainDirectory = PhpDirectoryByPsrProvider.suggestDirectory(fromNamespace, fromDir, toNamespaceName);
            Collection<PhpNamespace> namespaces = PhpIndex.getInstance(project).getNamespacesByName(PhpLangUtil.toFQN(PhpLangUtil.toName(fromNamespace)));
            if (namespaces.isEmpty()) {
                return mainDirectory == null ? Collections.emptyList() : new SmartList((Object)mainDirectory);
            }
            SmartList suggestions = new SmartList();
            if (mainDirectory != null) {
                suggestions.add(mainDirectory);
            }
            HashSet<String> processedDirectories = new HashSet<String>();
            processedDirectories.add(fromDir.getPath());
            for (PhpNamespace namespace : namespaces) {
                String directory;
                VirtualFile directoryFile = namespace.getContainingFile().getContainingDirectory().getVirtualFile();
                boolean isInProject = ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(directoryFile);
                if (!isInProject || !processedDirectories.add(directoryFile.getPath()) || (directory = PhpDirectoryByPsrProvider.suggestDirectory(fromNamespace, directoryFile, toNamespaceName)) == null) continue;
                suggestions.add(directory);
            }
            SmartList smartList = suggestions;
            if (smartList == null) {
                PhpDirectoryByRelativeNamespacesProvider.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryByRelativeNamespacesProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toNamespaceName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryByRelativeNamespacesProvider";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestDirectories";
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpDirectoryByAllSourceRootsProvider
    implements PhpDirectoryProvider {
        private PhpDirectoryByAllSourceRootsProvider() {
        }

        @Override
        @NotNull
        public List<String> suggestDirectories(@NotNull Project project, @NotNull VirtualFile contextDir, @NotNull String namespaceName) {
            Module[] modules;
            VirtualFile root;
            if (project == null) {
                PhpDirectoryByAllSourceRootsProvider.$$$reportNull$$$0(0);
            }
            if (contextDir == null) {
                PhpDirectoryByAllSourceRootsProvider.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                PhpDirectoryByAllSourceRootsProvider.$$$reportNull$$$0(2);
            }
            if ((root = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(contextDir)) == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    PhpDirectoryByAllSourceRootsProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
            SmartList currentSourceRoot = new SmartList();
            SmartList otherSourceRoots = new SmartList();
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                    List excludedFolders = entry.getExcludeFolderUrls();
                    for (SourceFolder folder : entry.getSourceFolders()) {
                        String prefix;
                        String directory;
                        if (PhpDirectoryByAllSourceRootsProvider.isInExcluded(excludedFolders, folder) || PhpDirectoryByAllSourceRootsProvider.isGeneratedSources(folder) || (directory = PhpDirectoryByPsrProvider.suggestDirectory(prefix = PhpDirectoryByPsrProvider.getFolderPrefix(folder), folder.getFile(), namespaceName)) == null) continue;
                        if (root.equals(folder.getFile())) {
                            currentSourceRoot.add(directory);
                            continue;
                        }
                        otherSourceRoots.add(directory);
                    }
                }
            }
            currentSourceRoot.addAll(otherSourceRoots);
            SmartList smartList = currentSourceRoot;
            if (smartList == null) {
                PhpDirectoryByAllSourceRootsProvider.$$$reportNull$$$0(4);
            }
            return smartList;
        }

        private static boolean isGeneratedSources(SourceFolder folder) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            return properties != null && properties.isForGeneratedSources();
        }

        private static boolean isInExcluded(@NotNull List<String> excludedFolders, @NotNull SourceFolder folder) {
            if (excludedFolders == null) {
                PhpDirectoryByAllSourceRootsProvider.$$$reportNull$$$0(5);
            }
            if (folder == null) {
                PhpDirectoryByAllSourceRootsProvider.$$$reportNull$$$0(6);
            }
            String url = folder.getUrl();
            for (String excludeFolder : excludedFolders) {
                if (!FileUtil.isAncestor((String)excludeFolder, (String)url, (boolean)false)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryByAllSourceRootsProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "excludedFolders";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/roots/PhpDirectoryByPsrProvider$PhpDirectoryByAllSourceRootsProvider";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestDirectories";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isInExcluded";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

