/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.php.run.filters.PhpFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarDumpFileFilter
extends PhpFilter {
    private static final Logger LOG = Logger.getInstance(VarDumpFileFilter.class);
    private static final String LINE_NUM_PATTERN = "\\d+";
    private static final Pattern PATTERN = Pattern.compile("(" + URLUtil.FILE_URL_PATTERN + ")#L(\\d+)");
    private static final Pattern[] PATTERNS = new Pattern[]{PATTERN};

    public VarDumpFileFilter(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            VarDumpFileFilter.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            VarDumpFileFilter.$$$reportNull$$$0(1);
        }
        super(project, pathMapper);
    }

    @Override
    @Nullable
    public PhpFilter.MyResult applyFilter(@NotNull String line) {
        if (line == null) {
            VarDumpFileFilter.$$$reportNull$$$0(2);
        }
        return VarDumpFileFilter.apply(line);
    }

    @Nullable
    public static PhpFilter.MyResult apply(@NotNull String line) {
        if (line == null) {
            VarDumpFileFilter.$$$reportNull$$$0(3);
        }
        return VarDumpFileFilter.applyPatterns(line, PATTERNS);
    }

    private static PhpFilter.MyResult applyPatterns(@NotNull String line, Pattern ... patterns) {
        if (line == null) {
            VarDumpFileFilter.$$$reportNull$$$0(4);
        }
        for (Pattern pattern : patterns) {
            try {
                Matcher matcher = pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L));
                if (!matcher.find()) continue;
                String fileName = StringUtil.substringAfter((String)matcher.group(1), (String)"file://");
                String lineNumberString = matcher.group(3);
                if (fileName == null || lineNumberString == null) {
                    return null;
                }
                try {
                    int lineNumber = Integer.parseInt(lineNumberString);
                    return new PhpFilter.MyResult(fileName, lineNumber, matcher.start(1), matcher.end(3));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            catch (ProcessCanceledException e) {
                LOG.warn("Matching took too long for line: " + line);
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/run/filters/VarDumpFileFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPatterns";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

