/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.debug.PhpDebugErrorDetector;
import com.jetbrains.php.phpunit.coverage.PhpCoverageResultManager;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRemoteInterpreterManager {
    private static final ExtensionPointName<PhpRemoteInterpreterManager> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.php.remote.remoteInterpreterManager");
    private static final Logger LOG = Logger.getInstance(PhpRemoteInterpreterManager.class);

    @Nullable
    public static PhpRemoteInterpreterManager getInstance() {
        List extensions = EP_NAME.getExtensionList();
        if (extensions.isEmpty()) {
            return null;
        }
        if (extensions.size() > 1) {
            LOG.warn("Too many php remote interpreter managers registered (" + List.of(extensions) + ")");
        }
        return (PhpRemoteInterpreterManager)extensions.get(0);
    }

    public abstract boolean producesSshSdkCredentials(@NotNull PhpSdkAdditionalData var1);

    @NotNull
    public abstract PhpSdkAdditionalData loadRemote(@Nullable Project var1, @Nullable Element var2, @NotNull Sdk var3);

    @Nullable
    public abstract PhpInterpreter addRemoteSdk(@NotNull Project var1, @NotNull Supplier<? extends PhpInterpreter> var2);

    public abstract PhpInterpreterComponent createRemoteInterpreterEditor(@NotNull Project var1, @NotNull String var2, @NotNull PhpSdkAdditionalData var3);

    @NotNull
    public abstract PhpCommandLinePathProcessor createPathMapper(@NotNull Project var1, @NotNull PhpSdkAdditionalData var2) throws ExecutionException;

    @NotNull
    public abstract PhpCommandSettings createPhpCommand(@NotNull Project var1, @NotNull PhpSdkAdditionalData var2) throws ExecutionException;

    @NotNull
    public abstract PathMappingSettings createPathMappings(@Nullable Project var1, @NotNull PhpSdkAdditionalData var2);

    @NotNull
    public abstract String getPathMappingsSource(@NotNull PhpSdkAdditionalData var1);

    @NotNull
    public abstract ProcessHandler getRemoteProcessHandler(@NotNull Project var1, @NotNull PhpSdkAdditionalData var2, @NotNull GeneralCommandLine var3, boolean var4, PathMappingSettings.PathMapping ... var5) throws ExecutionException, InterruptedException;

    @NotNull
    public abstract ProcessHandler getRemoteToolProcessHandler(@NotNull Project var1, @NotNull QualityToolMessageProcessor var2, @NotNull PhpSdkAdditionalData var3, @NotNull GeneralCommandLine var4, PathMappingSettings.PathMapping ... var5) throws ExecutionException;

    @NotNull
    public abstract ProcessOutput getProcessOutput(@NotNull Project var1, @NotNull PhpSdkAdditionalData var2, @NotNull GeneralCommandLine var3, @NotNull String var4, @Nullable JComponent var5) throws ExecutionException, InterruptedException;

    @NotNull
    public abstract ActionListener createRemoteBrowserAction(@Nullable Project var1, @NotNull PhpSdkAdditionalData var2, @NotNull String var3, @NotNull JTextField var4, boolean var5) throws PhpInvalidSdkTypeException;

    @Nullable
    public abstract String getRemoteHost(@NotNull Project var1, @NotNull String var2, @NotNull PhpSdkAdditionalData var3);

    @Nullable
    public abstract PhpSdkHelpersManager getHelpersManager(@NotNull PhpSdkAdditionalData var1) throws ExecutionException;

    @Nullable
    public abstract PhpCoverageResultManager getCoverageResultManager(@NotNull PhpSdkAdditionalData var1);

    @Nullable
    public abstract PhpSdkFileTransfer getSdkFileTransfer(@NotNull PhpSdkAdditionalData var1);

    public abstract void replaceWithPhpDbg(@NotNull PhpSdkAdditionalData var1);

    public abstract String escape(@NotNull PhpSdkAdditionalData var1, @NotNull String var2);

    @Nullable
    public abstract PhpDebugErrorDetector newErrorDetector(@NotNull Project var1, @NotNull PhpSdkAdditionalData var2);

    public abstract void subscribeOnSshConfigsChanged(@Nullable Project var1);

    @Nls
    public static String getRemoteInterpreterPluginIsDisabledErrorMessage() {
        return PhpBundle.message("remote.interpreter.can.t.be.executed.please.enable.the.php.remote.interpreter.plugin", new Object[0]);
    }
}

