/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpIncludePathUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("php.include.path.custom", 3);
    private static final VarargEventId NON_COMPOSER = GROUP.registerVarargEvent("non.composer", new EventField[]{EventFields.Count});
    private static final VarargEventId ABSOLUTE = GROUP.registerVarargEvent("absolute", new EventField[]{EventFields.Count});
    private static final VarargEventId RELATIVE = GROUP.registerVarargEvent("relative", new EventField[]{EventFields.Count});
    private static final VarargEventId ALL = GROUP.registerVarargEvent("all", new EventField[]{EventFields.Count});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        PhpIncludePathManager includePathManager;
        if (project == null) {
            PhpIncludePathUsagesCollector.$$$reportNull$$$0(0);
        }
        if (!project.isDefault() && (includePathManager = PhpIncludePathManager.getInstance(project)) != null) {
            List<String> includePath = includePathManager.getIncludePath();
            int allPaths = 0;
            int allAbsolutePaths = 0;
            int nonComposerPaths = 0;
            if (!includePath.isEmpty()) {
                VirtualFile vendorDir = ComposerLibraryService.getInstance(project).refreshVendorDir(false, null);
                String vendor = vendorDir == null ? null : vendorDir.getPath();
                for (String path : includePath) {
                    ++allPaths;
                    if (FileUtil.isAbsolute((String)path)) {
                        ++allAbsolutePaths;
                        if (vendor != null && FileUtil.isAncestor((String)vendor, (String)path, (boolean)true)) continue;
                        ++nonComposerPaths;
                        continue;
                    }
                    ++nonComposerPaths;
                }
            }
            HashSet<MetricEvent> result = new HashSet<MetricEvent>();
            MetricEventUtilKt.addCounterIfNotZero(result, (VarargEventId)NON_COMPOSER, (int)nonComposerPaths);
            MetricEventUtilKt.addCounterIfNotZero(result, (VarargEventId)ABSOLUTE, (int)allAbsolutePaths);
            MetricEventUtilKt.addCounterIfNotZero(result, (VarargEventId)RELATIVE, (int)(allPaths - allAbsolutePaths));
            MetricEventUtilKt.addCounterIfNotZero(result, (VarargEventId)ALL, (int)allPaths);
            HashSet<MetricEvent> hashSet = result;
            if (hashSet == null) {
                PhpIncludePathUsagesCollector.$$$reportNull$$$0(1);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            PhpIncludePathUsagesCollector.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpIncludePathUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpIncludePathUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

