/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.structuralsearch;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExprTypePredicate
extends MatchPredicate {
    private final boolean myHierarchy;
    private final PhpType myPatternType;

    public PhpExprTypePredicate(String type, boolean hierarchy) {
        this.myHierarchy = hierarchy;
        this.myPatternType = this.buildPatternType(type);
    }

    public PhpType buildPatternType(String type) {
        PhpType.PhpTypeBuilder builder2 = PhpType.builder();
        StringUtil.split((String)type, (String)"|").stream().map(PhpLangUtil::toFQN).forEach(builder2::add);
        return builder2.build();
    }

    public boolean match(@NotNull PsiElement matchedNode, int start, int end, @NotNull MatchContext context) {
        if (matchedNode == null) {
            PhpExprTypePredicate.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpExprTypePredicate.$$$reportNull$$$0(1);
        }
        if ((matchedNode = (PsiElement)ObjectUtils.tryCast((Object)this.getParentIfNeeded(matchedNode), PhpTypedElement.class)) == null) {
            return false;
        }
        PhpType type = ((PhpTypedElement)matchedNode).getGlobalType().filterUnknown().filterMixed();
        if (type.isEmpty()) {
            return false;
        }
        return PhpType.intersects(this.myPatternType, type) || PhpType.ARRAY.equals(this.myPatternType) && PhpType.isArray(type) || this.myHierarchy && this.myPatternType.isConvertibleFrom(type, PhpIndex.getInstance(matchedNode.getProject()));
    }

    @Nullable
    public PsiElement getParentIfNeeded(PsiElement matchedNode) {
        return (matchedNode = StructuralSearchUtil.getParentIfIdentifier((PsiElement)matchedNode)) instanceof LeafPsiElement ? matchedNode.getParent() : matchedNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "matchedNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/structuralsearch/PhpExprTypePredicate";
        objectArray[2] = "match";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

