/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.structureView.PhpMethodTypeGroup;
import com.jetbrains.php.structureView.PhpStructureViewTreeElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PhpMethodTypeGrouper
implements Grouper {
    public static final String ID = "GROUP_METHODS_BY_TYPE";

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<TreeElement> children) {
        if (parent == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(0);
        }
        if (children == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(1);
        }
        if (PhpMethodTypeGrouper.isParentGrouped(parent)) {
            List<Group> list = Collections.emptyList();
            if (list == null) {
                PhpMethodTypeGrouper.$$$reportNull$$$0(2);
            }
            return list;
        }
        HashMap<Key, Group> groups = new HashMap<Key, Group>();
        for (TreeElement child : children) {
            PhpClass superClass;
            Method method;
            PhpStructureViewTreeElement element = (PhpStructureViewTreeElement)ObjectUtils.tryCast((Object)child, PhpStructureViewTreeElement.class);
            if (element == null || (method = (Method)ObjectUtils.tryCast((Object)element.getPsiElement(), Method.class)) == null || (superClass = element.isInherited() ? method.getContainingClass() : PhpStructureViewTreeElement.getSuperClass(method)) == null) continue;
            PhpMethodTypeGroup.OwnershipType ownershipType = element.isInherited() ? PhpMethodTypeGroup.OwnershipType.INHERITS : PhpMethodTypeGrouper.getOwnershipType(method, superClass);
            Group group = PhpMethodTypeGrouper.getGroup(groups, superClass, ownershipType);
            group.getChildren().add(element);
        }
        Collection<Group> collection = groups.values();
        if (collection == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private static Group getGroup(@NotNull Map<Key, Group> groups, @NotNull PhpClass clazz, @NotNull PhpMethodTypeGroup.OwnershipType ownershipType) {
        if (groups == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(5);
        }
        if (ownershipType == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(6);
        }
        Key key = new Key(clazz, ownershipType);
        Group group = groups.computeIfAbsent(key, e -> new PhpMethodTypeGroup(clazz, ownershipType));
        if (group == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(7);
        }
        return group;
    }

    @NotNull
    private static PhpMethodTypeGroup.OwnershipType getOwnershipType(@NotNull Method method, @NotNull PhpClass superClass) {
        if (method == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(8);
        }
        if (superClass == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(9);
        }
        PhpMethodTypeGroup.OwnershipType ownershipType = method.isAbstract() || !superClass.isAbstract() ? PhpMethodTypeGroup.OwnershipType.OVERRIDES : PhpMethodTypeGroup.OwnershipType.IMPLEMENTS;
        if (ownershipType == null) {
            PhpMethodTypeGrouper.$$$reportNull$$$0(10);
        }
        return ownershipType;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(PhpBundle.message("group.methods.by.type", new Object[0]), null, AllIcons.General.ImplementingMethod);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    private static boolean isParentGrouped(AbstractTreeNode<?> parent) {
        while (parent != null) {
            if (parent.getValue() instanceof PhpMethodTypeGroup) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/structureView/PhpMethodTypeGrouper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownershipType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/structureView/PhpMethodTypeGrouper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnershipType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOwnershipType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 10 -> new IllegalStateException(string);
        };
    }

    private static class Key {
        private final PhpClass myClass;
        private final PhpMethodTypeGroup.OwnershipType myOwnershipType;

        Key(@NotNull PhpClass clazz, @NotNull PhpMethodTypeGroup.OwnershipType ownershipType) {
            if (clazz == null) {
                Key.$$$reportNull$$$0(0);
            }
            if (ownershipType == null) {
                Key.$$$reportNull$$$0(1);
            }
            this.myClass = clazz;
            this.myOwnershipType = ownershipType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.myClass, key.myClass) && this.myOwnershipType == key.myOwnershipType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myClass, this.myOwnershipType});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ownershipType";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/structureView/PhpMethodTypeGrouper$Key";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

