/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.structureView;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.structureView.PhpNaturalOrderSorter;
import com.jetbrains.php.structureView.PhpVisibilityComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStructureViewTreeElement
extends PsiTreeElementBase<PsiElement>
implements StructureViewTreeElement,
PhpVisibilityComparator.AccessLevelSortOrderProvider {
    private final PsiElement myElement;
    private final ItemPresentation myPresentation;
    private final boolean myInherited;
    private static final TextAttributes INHERITED_MEMBER_TEXT = SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes();
    public static final TextAttributesKey INHERITED_MEMBER = TextAttributesKey.createTextAttributesKey((String)"PHP_INHERITED_MEMBER", (TextAttributes)INHERITED_MEMBER_TEXT);

    public PhpStructureViewTreeElement(PsiElement psiElement, boolean isInherited) {
        super(psiElement);
        this.myElement = psiElement;
        this.myInherited = isInherited;
        this.myPresentation = PhpStructureViewTreeElement.createPresentation(this.myElement, (TextAttributesKey)(isInherited ? INHERITED_MEMBER : null), isInherited);
        assert (this.myPresentation.getPresentableText() != null) : "PsiElement " + psiElement + " doesn't have any presentable text";
    }

    public PhpStructureViewTreeElement(PsiElement psiElement) {
        this(psiElement, false);
    }

    @Nullable
    public PsiElement getValue() {
        return this.myElement.isValid() ? this.myElement : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = this.myPresentation;
        if (itemPresentation == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(0);
        }
        return itemPresentation;
    }

    private static TextAttributesKey getDeprecatedAttributes(PsiElement myElement) {
        if (myElement instanceof PhpNamedElement && PhpNamedElementImpl.getDeprecatedSinceVersion((PhpNamedElement)myElement) != null) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        return null;
    }

    @NotNull
    public static PresentationData createPresentation(PsiElement myElement, TextAttributesKey textAttrsKey) {
        return PhpStructureViewTreeElement.createPresentation(myElement, textAttrsKey, false);
    }

    @NotNull
    public static PresentationData createPresentation(PsiElement myElement, TextAttributesKey textAttrsKey, boolean isInherited) {
        TextAttributesKey deprecatedAttributes = PhpStructureViewTreeElement.getDeprecatedAttributes(myElement);
        if (deprecatedAttributes != null) {
            textAttrsKey = deprecatedAttributes;
        }
        if (myElement instanceof PhpFile) {
            PresentationData presentationData = PhpPresentationUtil.getFilePresentation((PhpFile)myElement);
            if (presentationData == null) {
                PhpStructureViewTreeElement.$$$reportNull$$$0(1);
            }
            return presentationData;
        }
        if (myElement instanceof PhpNamespace) {
            PresentationData presentation = PhpPresentationUtil.getNamespacePresentation((PhpNamespace)myElement);
            presentation.setLocationString(null);
            PresentationData presentationData = presentation;
            if (presentationData == null) {
                PhpStructureViewTreeElement.$$$reportNull$$$0(2);
            }
            return presentationData;
        }
        if (myElement instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)myElement;
            String className = phpClass.isAnonymous() ? PhpStructureViewTreeElement.getAnonymousClassName(phpClass) : phpClass.getName();
            Icon classIcon = phpClass.getIcon();
            return new PresentationData(className, null, classIcon, textAttrsKey);
        }
        if (myElement instanceof Method) {
            Method e = (Method)myElement;
            return new PresentationData(PhpPresentationUtil.formatFunction(e), PhpStructureViewTreeElement.getLocation(e, isInherited), e.getIcon(), textAttrsKey);
        }
        if (myElement instanceof Field || myElement instanceof PhpEnumCase) {
            PhpNamedElement field = (PhpNamedElement)myElement;
            StringBuilder builder2 = new StringBuilder().append(field.getName());
            PhpPresentationUtil.formatType(builder2, field);
            if (field instanceof Field) {
                PhpPresentationUtil.appendDefaultValue(builder2, ((Field)field).getDefaultValuePresentation());
                return new PresentationData(builder2.toString(), PhpStructureViewTreeElement.getLocation((PhpClassMember)myElement, isInherited), field.getIcon(), textAttrsKey);
            }
            PhpEnumCase.PhpDefaultValueDescriptor descriptor = ((PhpEnumCase)myElement).getDefaultValueDescriptor();
            if (descriptor != null) {
                PhpPresentationUtil.appendDefaultValue(builder2, descriptor.getValue());
            }
            return new PresentationData(builder2.toString(), null, field.getIcon(), textAttrsKey);
        }
        if (myElement instanceof Function) {
            Function function = (Function)myElement;
            RowIcon rowIcon = IconManager.getInstance().createRowIcon(2);
            rowIcon.setIcon(function.getIcon(), 0);
            rowIcon.setIcon(PhpPresentationUtil.getAccessIcon(PhpModifier.Access.PUBLIC), 1);
            return new PresentationData(PhpPresentationUtil.formatFunction(function), null, (Icon)rowIcon, textAttrsKey);
        }
        if (myElement instanceof Constant) {
            Constant e = (Constant)myElement;
            StringBuilder b = new StringBuilder().append(e.getName());
            PhpPresentationUtil.formatType(b, e);
            PhpPresentationUtil.appendDefaultValue(b, e.getValuePresentation());
            return new PresentationData(b.toString(), null, e.getIcon(), textAttrsKey);
        }
        if (myElement instanceof Include) {
            Include e = (Include)myElement;
            StringBuilder b = new StringBuilder();
            Icon icon = e.getIcon();
            try {
                if (!DumbService.isDumb((Project)myElement.getProject())) {
                    String name = e.getFileName();
                    if (name != null) {
                        b.append(name);
                    } else {
                        b.append(e.getArgument().getText());
                    }
                } else {
                    b.append(PhpBundle.message("php.structure.view.dumb.mode.resolving", new Object[0]));
                    icon = PhpIcons.WAITING;
                }
            }
            catch (Exception otherEx) {
                b.append("?");
            }
            return new PresentationData(b.toString(), null, icon, null);
        }
        return new PresentationData(myElement.getText(), null, null, null);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        if (!this.myElement.isValid()) {
            Set<StructureViewTreeElement> set = Collections.emptySet();
            if (set == null) {
                PhpStructureViewTreeElement.$$$reportNull$$$0(3);
            }
            return set;
        }
        ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>();
        PhpStructureViewTreeElement.collectChildren(children, this.myElement);
        ContainerUtil.sort(children, (Comparator)PhpNaturalOrderSorter.INSTANCE.getComparator());
        ArrayList<StructureViewTreeElement> arrayList = children;
        if (arrayList == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static void collectChildren(@NotNull List<StructureViewTreeElement> result, @NotNull PsiElement myElement) {
        block15: {
            block14: {
                Method[] methods;
                if (result == null) {
                    PhpStructureViewTreeElement.$$$reportNull$$$0(5);
                }
                if (myElement == null) {
                    PhpStructureViewTreeElement.$$$reportNull$$$0(6);
                }
                if (!(myElement instanceof PhpClass)) break block14;
                for (Method method : methods = ((PhpClass)myElement).getOwnMethods()) {
                    boolean isOwnMethod;
                    PhpClass containingClass = method.getContainingClass();
                    boolean bl = isOwnMethod = containingClass == myElement;
                    if (containingClass == null || PhpLangUtil.isObject(containingClass)) continue;
                    result.add(new PhpStructureViewTreeElement(method, !isOwnMethod));
                }
                Field[] fields = ((PhpClass)myElement).getOwnFields();
                for (Field field : fields) {
                    PsiElement parent;
                    PhpClass containingClass = field.getContainingClass();
                    if (containingClass == null || PhpLangUtil.isObject(containingClass) || (parent = field.getParent()) == null || parent instanceof FieldReference) continue;
                    boolean isOwnField = containingClass == myElement;
                    result.add(new PhpStructureViewTreeElement(field, !isOwnField));
                }
                for (PhpEnumCase aCase : ((PhpClass)myElement).getEnumCases()) {
                    result.add(new PhpStructureViewTreeElement((PsiElement)aCase));
                }
                break block15;
            }
            PsiElement[] children = myElement.getChildren();
            if (children.length == 0) {
                return;
            }
            ArrayList<PhpNamespace> namespaces = null;
            for (PsiElement child : children) {
                if (child instanceof PhpNamespace) {
                    if (namespaces == null) {
                        namespaces = new ArrayList<PhpNamespace>();
                    }
                    namespaces.add((PhpNamespace)child);
                    continue;
                }
                if (child instanceof PhpNamedElement) {
                    if (!(child instanceof PhpFile) && (!(child instanceof Function) || child instanceof Method) && !(child instanceof Constant) && !(child instanceof PhpClass)) continue;
                    result.add(new PhpStructureViewTreeElement(child));
                    continue;
                }
                if (child instanceof Include) {
                    result.add(new PhpStructureViewTreeElement(child));
                    continue;
                }
                if (child instanceof PhpExpression && !(child instanceof AssignmentExpression)) continue;
                PhpStructureViewTreeElement.collectChildren(result, child);
            }
            if (namespaces == null) break block15;
            if (namespaces.size() == 1) {
                PhpStructureViewTreeElement.collectChildren(result, (PsiElement)namespaces.get(0));
            } else {
                for (PhpNamespace namespace : namespaces) {
                    result.add(new PhpStructureViewTreeElement((PsiElement)namespace));
                }
            }
        }
    }

    public void navigate(boolean requestFocus) {
        PsiElement psiElement = this.myElement;
        if (psiElement instanceof Include) {
            Include include = (Include)psiElement;
            if (requestFocus) {
                PsiReference[] refs;
                for (PsiReference ref : refs = include.getReferences()) {
                    PsiElement item = ref.resolve();
                    if (!(item instanceof PhpFile)) continue;
                    NavigationUtil.activateFileWithPsiElement((PsiElement)((PhpFile)item).getOriginalFile());
                    return;
                }
            }
        }
        ((Navigatable)this.myElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((Navigatable)this.myElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Navigatable)this.myElement).canNavigateToSource();
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    @Override
    public int getAccessLevelSortOrder() {
        PsiElement psiElement = this.myElement;
        if (psiElement instanceof Field) {
            Field field = (Field)psiElement;
            return PhpStructureViewTreeElement.modifierToAccessLevelSortOrder(field.getModifier());
        }
        psiElement = this.myElement;
        if (psiElement instanceof Method) {
            Method method = (Method)psiElement;
            return PhpStructureViewTreeElement.modifierToAccessLevelSortOrder(method.getModifier());
        }
        return -1;
    }

    private static int modifierToAccessLevelSortOrder(@NotNull PhpModifier modifier) {
        if (modifier == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(7);
        }
        if (modifier.isPublic()) {
            return 2;
        }
        if (modifier.isProtected()) {
            return 1;
        }
        if (modifier.isPrivate()) {
            return 0;
        }
        return -1;
    }

    public int getMemberKindWeight() {
        if (this.myElement instanceof Include) {
            return 5;
        }
        if (this.myElement instanceof Constant) {
            return 10;
        }
        if (this.myElement instanceof Field) {
            if (((Field)this.myElement).isConstant()) {
                return 10;
            }
            return 20;
        }
        return 1000;
    }

    public PsiElement getPsiElement() {
        return this.myElement;
    }

    @Nullable
    public String getPresentableText() {
        return ((PhpNamedElement)this.myElement).getName();
    }

    @NotNull
    @Nls
    public static String getAnonymousClassName(PhpClass phpClass) {
        String accessibleName = PhpStructureViewTreeElement.getAccessibleName(phpClass);
        if (accessibleName == null) {
            String string = PhpBundle.message("anonymous.class", new Object[0]);
            if (string == null) {
                PhpStructureViewTreeElement.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = PhpBundle.message("anonymous.0", accessibleName);
        if (string == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NlsSafe
    private static String getAccessibleName(PhpClass phpClass) {
        String name = phpClass.getSuperName();
        if (name != null) {
            return name;
        }
        String[] interfaceNames = phpClass.getInterfaceNames();
        return interfaceNames.length == 1 ? interfaceNames[0] : null;
    }

    @Nullable
    public static String getLocation(@NotNull PhpClassMember member, boolean isInherited) {
        PhpClass containingClass;
        if (member == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(10);
        }
        if ((containingClass = member.getContainingClass()) != null && isInherited) {
            char rightArrow = '\u2192';
            return StartupUiUtil.getLabelFont().canDisplay(rightArrow) ? rightArrow + member.getContainingClass().getName() : containingClass.getName();
        }
        PhpClass superClass = PhpStructureViewTreeElement.getSuperClass(member);
        if (superClass != null) {
            char upArrow = '\u2191';
            return StartupUiUtil.getLabelFont().canDisplay(upArrow) ? upArrow + superClass.getName() : superClass.getName();
        }
        return null;
    }

    @Nullable
    public static PhpClass getSuperClass(@NotNull PhpClassMember member) {
        if (member == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(11);
        }
        Ref refClass = new Ref();
        Ref refInterface = new Ref();
        if (!DumbService.isDumb((Project)member.getProject())) {
            PhpClassHierarchyUtils.processSuperMembers(member, (superMethod, subClass, baseClass) -> {
                if (baseClass.isInterface()) {
                    refInterface.set((Object)superMethod.getContainingClass());
                } else if (refClass.get() == null) {
                    refClass.set((Object)superMethod.getContainingClass());
                }
                return true;
            });
            return refInterface.get() == null ? (PhpClass)refClass.get() : (PhpClass)refInterface.get();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/structureView/PhpStructureViewTreeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/structureView/PhpStructureViewTreeElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousClassName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifierToAccessLevelSortOrder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

