/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import java.io.File;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

public final class PhpLocalTerminalCustomizer
extends LocalTerminalCustomizer {
    private static final Logger LOG = Logger.getInstance(PhpLocalTerminalCustomizer.class);
    @NonNls
    private static final String INTELLIJ_FORCE_PREPEND_PREFIX = "_INTELLIJ_FORCE_PREPEND_";

    public String[] customizeCommandAndEnvironment(@NotNull Project project, @Nullable String workingDirectory, String[] command, @NotNull Map<String, String> envs) {
        String executable;
        if (project == null) {
            PhpLocalTerminalCustomizer.$$$reportNull$$$0(0);
        }
        if (envs == null) {
            PhpLocalTerminalCustomizer.$$$reportNull$$$0(1);
        }
        if (!PhpTerminalSettings.getInstance(project).isInterpreterAdded()) {
            return command;
        }
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
        if (interpreter == null || interpreter.isRemote()) {
            LOG.info(String.format("Do not initialise terminal for null or remote sdk: %s", interpreter));
            return command;
        }
        if (command.length > 0 && !StringUtil.isEmpty((String)(executable = interpreter.getPathToPhpExecutable()))) {
            LOG.info(String.format("Running terminal in the context of %s", interpreter));
            envs.put("_INTELLIJ_FORCE_PREPEND_PATH", PathUtil.getParentPath((String)executable) + File.pathSeparator);
            PhpLocalTerminalCustomizer.showNotification(project);
        }
        return super.customizeCommandAndEnvironment(project, workingDirectory, command, envs);
    }

    private static void showNotification(@NotNull Project project) {
        if (project == null) {
            PhpLocalTerminalCustomizer.$$$reportNull$$$0(2);
        }
        TerminalToolWindowManager terminalToolWindowManager = TerminalToolWindowManager.getInstance((Project)project);
        ToolWindow window = terminalToolWindowManager.getToolWindow();
        Disposable notificationDisposable = Disposer.newDisposable((Disposable)window.getDisposable(), (String)"php.terminal.customization");
        String path = SystemInfo.isWindows ? "%PATH%" : "$PATH";
        GotItTooltip tooltip = new GotItTooltip("php.terminal.customization", PhpBundle.message("php.path.was.updated.text", path), notificationDisposable).withHeader(PhpBundle.message("php.path.was.updated", path)).withLink(PhpBundle.message("php.turn.off.path.modification", path), () -> {
            PhpTerminalSettings instance = PhpTerminalSettings.getInstance(project);
            instance.setInterpreterAdded(false);
            terminalToolWindowManager.newTab(window, null);
        }).withPosition(Balloon.Position.below);
        JComponent component = null;
        for (TerminalWidget w : terminalToolWindowManager.getTerminalWidgets()) {
            if (!"Local".equals(w.getTerminalTitle().getDefaultTitle())) continue;
            component = w.getComponent();
        }
        if (component != null) {
            tooltip.show(component, GotItTooltip.TOP_MIDDLE);
        }
    }

    @Nullable
    public PhpInterpreterTerminalConfigurable getConfigurable(@NotNull Project project) {
        if (project == null) {
            PhpLocalTerminalCustomizer.$$$reportNull$$$0(3);
        }
        return new PhpInterpreterTerminalConfigurable(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/terminal/PhpLocalTerminalCustomizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCommandAndEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @State(name="PhpTerminalSettingsCustomizer", storages={@Storage(value="php.xml", roamingType=RoamingType.DISABLED)})
    public static class PhpTerminalSettings
    implements PersistentStateComponent<SettingsState> {
        private SettingsState myState = new SettingsState();

        public boolean isInterpreterAdded() {
            return this.myState.myIsInterpreterAdded;
        }

        private void setInterpreterAdded(boolean isInterpreterAdded) {
            this.myState.myIsInterpreterAdded = isInterpreterAdded;
        }

        @Nullable
        public SettingsState getState() {
            return this.myState;
        }

        public void loadState(@NotNull SettingsState state) {
            if (state == null) {
                PhpTerminalSettings.$$$reportNull$$$0(0);
            }
            this.myState = state;
        }

        @NotNull
        public static PhpTerminalSettings getInstance(@NotNull Project project) {
            if (project == null) {
                PhpTerminalSettings.$$$reportNull$$$0(1);
            }
            PhpTerminalSettings phpTerminalSettings = (PhpTerminalSettings)project.getService(PhpTerminalSettings.class);
            if (phpTerminalSettings == null) {
                PhpTerminalSettings.$$$reportNull$$$0(2);
            }
            return phpTerminalSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/terminal/PhpLocalTerminalCustomizer$PhpTerminalSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/terminal/PhpLocalTerminalCustomizer$PhpTerminalSettings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        public static class SettingsState {
            public boolean myIsInterpreterAdded = true;
        }
    }

    private static class PhpInterpreterTerminalConfigurable
    implements UnnamedConfigurable {
        private final JCheckBox myCheckbox;
        private final PhpTerminalSettings mySettings;

        PhpInterpreterTerminalConfigurable(@NotNull Project project) {
            if (project == null) {
                PhpInterpreterTerminalConfigurable.$$$reportNull$$$0(0);
            }
            this.myCheckbox = new JCheckBox(PhpBundle.message("terminal.add.interpreter.to.path", SystemInfo.isWindows ? "%PATH%" : "$PATH"));
            this.mySettings = PhpTerminalSettings.getInstance(project);
        }

        @Nullable
        public JComponent createComponent() {
            return this.myCheckbox;
        }

        public boolean isModified() {
            return this.mySettings.isInterpreterAdded() != this.myCheckbox.isSelected();
        }

        public void apply() throws ConfigurationException {
            this.mySettings.setInterpreterAdded(this.myCheckbox.isSelected());
        }

        public void reset() {
            this.myCheckbox.setSelected(this.mySettings.isInterpreterAdded());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/terminal/PhpLocalTerminalCustomizer$PhpInterpreterTerminalConfigurable", "<init>"));
        }
    }
}

