/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkBaseSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkOldConfigHolder;
import com.jetbrains.php.testFramework.PhpTestFrameworkStateListener;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PhpTestFrameworkSettingsManager
implements Disposable {
    private final PhpTestFrameworkProjectSettingsManager myProjectManager;
    private final PhpTestFrameworkApplicationSettingsManager myApplicationManager;
    @Nullable
    private Project myProject;

    public static PhpTestFrameworkSettingsManager getInstance(@Nullable Project project) {
        Project targetProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (PhpTestFrameworkSettingsManager)targetProject.getService(PhpTestFrameworkSettingsManager.class);
    }

    public PhpTestFrameworkSettingsManager(final @Nullable Project project) {
        this.myProject = project;
        this.myApplicationManager = PhpTestFrameworkApplicationSettingsManager.getInstance();
        if (project != null && !project.isDefault()) {
            this.myProjectManager = PhpTestFrameworkProjectSettingsManager.getInstance(project);
            PhpTestFrameworkStateListener listener = new PhpTestFrameworkStateListener(){

                @Override
                public void onSettingsUpdate() {
                    PhpTestFrameworkSettingsManager.this.resolvePossibleCollisions(project);
                }
            };
            this.myProjectManager.addListener(this, listener);
            this.myApplicationManager.addListener(this, listener);
            this.resolvePossibleCollisions(project);
        } else {
            this.myProjectManager = null;
        }
    }

    private void resolvePossibleCollisions(@NotNull Project project) {
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(0);
        }
        if (this.myProjectManager == null) {
            return;
        }
        Set<PhpTestFrameworkType> frameworks = this.getFrameworks();
        for (PhpTestFrameworkType frameworkType : frameworks) {
            this.resolvePossibleCollisions(project, frameworkType);
        }
    }

    public void onInterpretersUpdate() {
        if (this.myProjectManager == null) {
            return;
        }
        this.resolvePossibleCollisions(this.myProjectManager.myProject);
    }

    @NotNull
    public @Unmodifiable Set<PhpTestFrameworkType> getFrameworks() {
        if (this.myProjectManager == null) {
            Set<PhpTestFrameworkType> set = this.myApplicationManager.getFrameworks();
            if (set == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set set = ContainerUtil.union(this.myProjectManager.getFrameworks(), this.myApplicationManager.getFrameworks());
        if (set == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    private void resolvePossibleCollisions(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType) {
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(3);
        }
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(4);
        }
        if (this.myProjectManager == null) {
            return;
        }
        boolean hasApplicationLevel = this.myProjectManager.getConfigurations(frameworkType).stream().anyMatch(configuration -> !configuration.isProjectLevel());
        if (!hasApplicationLevel) {
            boolean hasProjectLevel = this.myApplicationManager.getConfigurations(frameworkType).stream().anyMatch(PhpTestFrameworkConfiguration::isProjectLevel);
            if (hasProjectLevel) {
                this.setConfigurations(frameworkType, this.getConfigurations(frameworkType));
            }
            return;
        }
        SmartList newConfigurations = new SmartList();
        ArrayList<PhpTestFrameworkConfiguration> projectLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        ArrayList<PhpTestFrameworkConfiguration> applicationLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        for (PhpTestFrameworkConfiguration configuration2 : this.myApplicationManager.getConfigurations(frameworkType)) {
            if (configuration2.isProjectLevel()) {
                projectLevel.add(configuration2);
                continue;
            }
            applicationLevel.add(configuration2);
        }
        for (PhpTestFrameworkConfiguration config : this.myProjectManager.getConfigurations(frameworkType)) {
            if (!config.isProjectLevel()) {
                PhpTestFrameworkConfiguration existing = this.myApplicationManager.getConfigById(frameworkType, config.getId(project));
                if (existing != null) {
                    PhpTestFrameworkConfiguration copy;
                    if (existing.equals(config) || (copy = config.copyWithSettingsSource(project)) == null) continue;
                    newConfigurations.add(existing.getPresentableName(project));
                    projectLevel.add(copy);
                    continue;
                }
                applicationLevel.add(config);
                continue;
            }
            projectLevel.add(config);
        }
        this.myApplicationManager.setConfigurations(frameworkType, applicationLevel);
        this.myProjectManager.setConfigurations(frameworkType, projectLevel);
        if (!newConfigurations.isEmpty()) {
            PhpTestFrameworkSettingsManager.showWarning(project, frameworkType, (List<String>)newConfigurations);
        }
    }

    private static void showWarning(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType, @NotNull List<@NlsSafe String> newSettings) {
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(5);
        }
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(6);
        }
        if (newSettings == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(7);
        }
        String toolName = frameworkType.getDisplayName();
        HtmlBuilder builder2 = new HtmlBuilder().append(PhpBundle.message("php.test.framework.interpreter.conflict", toolName));
        for (String name : newSettings) {
            builder2.append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.text((String)("'" + name + "'")).bold());
        }
        String title = PhpBundle.message("php.test.framework.interpreter.conflict.title", toolName);
        PhpUnitUtil.NOTIFICATION_GROUP.createNotification(title, builder2.toString(), NotificationType.WARNING).notify(project);
    }

    public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(8);
        }
        ArrayList<PhpTestFrameworkConfiguration> result = new ArrayList<PhpTestFrameworkConfiguration>();
        if (this.myProjectManager != null) {
            result.addAll(this.myProjectManager.getConfigurations(frameworkType));
        }
        result.addAll(this.myApplicationManager.getConfigurations(frameworkType));
        return result;
    }

    @NotNull
    public PhpTestFrameworkConfiguration addSettingsIfAbsent(@NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestFrameworkConfiguration config, @Nullable String interpreterId, @Nullable VirtualFile locationContext) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(9);
        }
        if (config == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(10);
        }
        if (this.myProjectManager == null) {
            PhpTestFrameworkConfiguration phpTestFrameworkConfiguration = this.myApplicationManager.addIfAbsent(frameworkType, config, interpreterId, locationContext);
            if (phpTestFrameworkConfiguration == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(11);
            }
            return phpTestFrameworkConfiguration;
        }
        if (config.isProjectLevel()) {
            PhpTestFrameworkConfiguration phpTestFrameworkConfiguration = this.myProjectManager.addIfAbsent(frameworkType, config, interpreterId, locationContext);
            if (phpTestFrameworkConfiguration == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(12);
            }
            return phpTestFrameworkConfiguration;
        }
        PhpTestFrameworkConfiguration phpTestFrameworkConfiguration = this.myApplicationManager.addIfAbsent(frameworkType, config, interpreterId, locationContext);
        if (phpTestFrameworkConfiguration == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(13);
        }
        return phpTestFrameworkConfiguration;
    }

    public void setConfigurations(@NotNull PhpTestFrameworkType frameworkType, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(14);
        }
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(15);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setConfigurations(frameworkType, configurations);
            return;
        }
        ArrayList<PhpTestFrameworkConfiguration> applicationLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        ArrayList<PhpTestFrameworkConfiguration> projectLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        for (PhpTestFrameworkConfiguration config : configurations) {
            if (config.isProjectLevel()) {
                projectLevel.add(config);
                continue;
            }
            applicationLevel.add(config);
        }
        this.myApplicationManager.setConfigurations(frameworkType, applicationLevel);
        this.myProjectManager.setConfigurations(frameworkType, projectLevel);
    }

    @NotNull
    public List<PhpTestFrameworkConfiguration> getAllConfigurations() {
        ArrayList<PhpTestFrameworkConfiguration> result = new ArrayList<PhpTestFrameworkConfiguration>();
        for (PhpTestFrameworkType frameworkType : this.getFrameworks()) {
            result.addAll(this.getConfigurations(frameworkType));
        }
        Project project = this.myProjectManager != null ? this.myProjectManager.myProject : null;
        result.addAll(PhpUnitSettingsManager.getInstance(project).getAllSettings());
        ArrayList<PhpTestFrameworkConfiguration> arrayList = result;
        if (arrayList == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public void setAllConfigurations(@NotNull List<PhpTestFrameworkConfiguration> configurations) {
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(17);
        }
        HashMap<PhpTestFrameworkType, SmartList> configurationByKey = new HashMap<PhpTestFrameworkType, SmartList>();
        for (PhpTestFrameworkType phpTestFrameworkType : this.getFrameworks()) {
            configurationByKey.put(phpTestFrameworkType, new SmartList());
        }
        ArrayList<PhpUnitSettings> phpUnitConfig = new ArrayList<PhpUnitSettings>();
        for (PhpTestFrameworkConfiguration config : configurations) {
            if (config instanceof PhpUnitSettings) {
                phpUnitConfig.add((PhpUnitSettings)config);
                continue;
            }
            PhpTestFrameworkType type = config.getFrameworkType();
            if (!configurationByKey.containsKey(type)) {
                configurationByKey.put(type, new SmartList());
            }
            ((List)configurationByKey.get(type)).add(config);
        }
        Project project = this.myProjectManager != null ? this.myProjectManager.myProject : null;
        PhpUnitSettingsManager.getInstance(project).setSettings(phpUnitConfig);
        for (Map.Entry entry : configurationByKey.entrySet()) {
            this.setConfigurations((PhpTestFrameworkType)entry.getKey(), (List)entry.getValue());
        }
    }

    @Deprecated
    @Nullable
    public PhpTestFrameworkConfiguration getLocalConfig(@NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(18);
        }
        if (this.myProjectManager != null) {
            return this.myProjectManager.getLocalConfig(frameworkType);
        }
        return null;
    }

    @Nullable
    public PhpTestFrameworkConfiguration getLocalConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable VirtualFile locationContext) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(19);
        }
        if (this.myProjectManager != null) {
            return this.myProjectManager.getLocalConfig(frameworkType, locationContext);
        }
        return null;
    }

    @Nullable
    public PhpTestFrameworkConfiguration getRemoteConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable VirtualFile locationContext) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(20);
        }
        if (this.myProjectManager != null) {
            return this.myProjectManager.getRemoteConfig(frameworkType, locationContext);
        }
        return null;
    }

    @Nullable
    public PhpTestFrameworkConfiguration getDefaultLocalConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable VirtualFile locationContext) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(21);
        }
        if (this.myProjectManager != null) {
            VirtualFile mainConfig;
            VirtualFile composerConfig;
            PhpTestFrameworkConfiguration localConfig = this.myProjectManager.getLocalConfig(frameworkType, locationContext);
            if (localConfig == null && this.myProject != null && !Objects.equals(composerConfig = ComposerConfigManager.getInstance(this.myProject).getConfig(locationContext), mainConfig = ComposerConfigManager.getInstance(this.myProject).getMainConfig())) {
                return this.getLocalConfig(frameworkType, mainConfig);
            }
            return localConfig;
        }
        return null;
    }

    @Nullable
    public PhpTestFrameworkConfiguration getDefaultRemoteConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable VirtualFile locationContext) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(22);
        }
        if (this.myProjectManager != null) {
            VirtualFile mainConfig;
            VirtualFile composerConfig;
            PhpTestFrameworkConfiguration remoteConfig = this.myProjectManager.getRemoteConfig(frameworkType, locationContext);
            if (remoteConfig == null && this.myProject != null && !Objects.equals(composerConfig = ComposerConfigManager.getInstance(this.myProject).getConfig(locationContext), mainConfig = ComposerConfigManager.getInstance(this.myProject).getMainConfig())) {
                return this.getRemoteConfig(frameworkType, mainConfig);
            }
            return remoteConfig;
        }
        return null;
    }

    @Nullable
    public PhpTestFrameworkConfiguration getDefaultConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable VirtualFile locationContext) {
        PhpTestFrameworkConfiguration defaultLocalSettings;
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(23);
        }
        if ((defaultLocalSettings = this.getDefaultLocalConfig(frameworkType, locationContext)) != null) {
            return defaultLocalSettings;
        }
        return this.getDefaultRemoteConfig(frameworkType, locationContext);
    }

    public void setLocalConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpTestFrameworkConfiguration localConfig) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(24);
        }
        List configs = ContainerUtil.filter(this.getConfigurations(frameworkType), config -> !config.isLocal());
        if (localConfig != null) {
            configs = ContainerUtil.append((List)configs, (Object[])new PhpTestFrameworkConfiguration[]{localConfig});
        }
        this.setConfigurations(frameworkType, configs);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getOrCreateByInterpreter(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile locationContext) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(25);
        }
        return this.getOrCreateByInterpreter(frameworkType, interpreter, locationContext, false);
    }

    @Deprecated
    @Nullable
    public PhpTestFrameworkConfiguration getOrCreateByInterpreter(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter, boolean onTheFly) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(26);
        }
        return this.getOrCreateByInterpreter(frameworkType, interpreter, null, onTheFly);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getOrCreateByInterpreter(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile locationContext, boolean onTheFly) {
        PhpTestFrameworkConfiguration config;
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(27);
        }
        if ((config = this.getConfigByInterpreter(frameworkType, interpreter, locationContext)) != null) {
            return config;
        }
        PhpTestFrameworkConfiguration defaultConfig = this.getDefaultConfig(frameworkType, locationContext);
        if (onTheFly && defaultConfig == null) {
            return null;
        }
        List<PhpTestFrameworkConfigurationFactory> factories = frameworkType.getFactories();
        for (PhpTestFrameworkConfigurationFactory factory : factories) {
            Object newConfig = factory.createByInterpreter(interpreter);
            if (newConfig == null) continue;
            if (!onTheFly) {
                String interpreterId = interpreter != null ? interpreter.getId() : null;
                return this.addSettingsIfAbsent(frameworkType, (PhpTestFrameworkConfiguration)newConfig, interpreterId, locationContext);
            }
            PhpTestFrameworkSettingsManager.fillSettings(factory, interpreter, defaultConfig, newConfig, this.myProject);
            return newConfig;
        }
        assert (false);
        return null;
    }

    public static NullableFunction<String, String> getPathMappingFunction(@Nullable Project project, @Nullable PhpInterpreter interpreter, boolean isRemote) {
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (project == null || manager == null || interpreter == null || !interpreter.isRemote()) {
            return s -> s;
        }
        PathMappingSettings mappings = manager.createPathMappings(project, interpreter.getPhpSdkAdditionalData());
        return s -> s == null ? null : (isRemote ? mappings.convertToLocal(s) : mappings.convertToRemote(s));
    }

    public static void fillSettings(@NotNull PhpTestFrameworkConfigurationFactory factory, @Nullable PhpInterpreter interpreter, @Nullable PhpTestFrameworkConfiguration defaultSettings, @NotNull PhpTestFrameworkConfiguration newSettings, @Nullable Project project) {
        PhpInterpreter defaultSettingsInterpreter;
        if (factory == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(28);
        }
        if (newSettings == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(29);
        }
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
        if (defaultSettings instanceof PhpSdkDependentConfiguration) {
            PhpSdkDependentConfiguration sdkDependentSettings = (PhpSdkDependentConfiguration)((Object)defaultSettings);
            v0 = manager.findInterpreterById(sdkDependentSettings.getInterpreterId());
        } else {
            v0 = defaultSettingsInterpreter = interpreter;
        }
        if (defaultSettings != null && defaultSettingsInterpreter != null) {
            NullableFunction<String, String> pathMappingFunction = PhpTestFrameworkSettingsManager.getPathMappingFunction(project, defaultSettingsInterpreter, defaultSettings instanceof PhpSdkDependentConfiguration);
            factory.fillSettingsByDefaultValue(defaultSettings, newSettings, pathMappingFunction);
        }
    }

    @Nullable
    public PhpTestFrameworkConfiguration getConfigByInterpreter(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile context) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(30);
        }
        if (frameworkType == PhpUnitFrameworkType.getInstance()) {
            Project project = this.myProjectManager != null ? this.myProjectManager.myProject : null;
            return PhpUnitSettingsManager.getInstance(project).getSettingsByInterpreter(interpreter, context);
        }
        if (interpreter == null || !interpreter.isRemote()) {
            return this.getLocalConfig(frameworkType, context);
        }
        if (!Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            String id = "interpreter-" + interpreter.getId();
            PhpTestFrameworkConfiguration config = this.myApplicationManager.getConfigById(frameworkType, id);
            if (config == null && this.myProjectManager != null) {
                config = this.myProjectManager.getConfigById(frameworkType, id);
            }
            return config;
        }
        if (this.myProject == null || StringUtil.isEmpty((String)interpreter.getName()) || StringUtil.isEmpty((String)interpreter.getId())) {
            return null;
        }
        List<PhpTestFrameworkConfiguration> appConfigs = this.myApplicationManager.getConfigurations(frameworkType);
        PhpTestFrameworkConfiguration appConfig = PhpTestFrameworkSettingsManager.getConfigurationByInterpreter(this.myProject, appConfigs, interpreter, context);
        if (appConfig != null) {
            return appConfig;
        }
        if (this.myProjectManager != null) {
            return PhpTestFrameworkSettingsManager.getConfigurationByInterpreter(this.myProject, this.myProjectManager.getConfigurations(frameworkType), interpreter, context);
        }
        return null;
    }

    public void dispose() {
    }

    @NotNull
    public static <T extends PhpTestFrameworkConfiguration> Collection<T> filterConfigsByLocation(@NotNull Project project, @NotNull Collection<T> configurations, @Nullable VirtualFile locationContext) {
        boolean doesComposerUpdateSettings;
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(31);
        }
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(32);
        }
        if (!Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            Collection<T> collection = configurations;
            if (collection == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(33);
            }
            return collection;
        }
        ComposerConfigManager composerConfigManager = ComposerConfigManager.getInstance(project);
        VirtualFile composerConfig = composerConfigManager.getConfig(locationContext);
        boolean bl = doesComposerUpdateSettings = locationContext != null && "composer.json".equals(locationContext.getName());
        if (composerConfig == null || !doesComposerUpdateSettings && configurations.size() <= 1) {
            Collection<T> collection = configurations;
            if (collection == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(34);
            }
            return collection;
        }
        return PhpTestFrameworkSettingsManager.filterConfigsByLocation(project, configurations, null, locationContext);
    }

    @NotNull
    public static <T extends PhpTestFrameworkConfiguration> Collection<T> filterConfigsByLocation(@NotNull Project project, @NotNull Collection<T> configurations, @Nullable PathMappingSettings pathMapping, @Nullable VirtualFile locationContext) {
        boolean doesComposerUpdateSettings;
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(35);
        }
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(36);
        }
        if (!Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            Collection<T> collection = configurations;
            if (collection == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(37);
            }
            return collection;
        }
        ComposerConfigManager composerConfigManager = ComposerConfigManager.getInstance(project);
        VirtualFile composerConfig = composerConfigManager.getConfig(locationContext);
        boolean bl = doesComposerUpdateSettings = locationContext != null && "composer.json".equals(locationContext.getName());
        if (composerConfig == null || !doesComposerUpdateSettings && configurations.size() <= 1) {
            Collection<T> collection = configurations;
            if (collection == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(38);
            }
            return collection;
        }
        List list = ContainerUtil.filter(configurations, c -> PhpTestFrameworkSettingsManager.isControlledByComposer(project, composerConfig, c, pathMapping));
        if (list == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(39);
        }
        return list;
    }

    private static boolean isControlledByComposer(@NotNull Project project, @NotNull VirtualFile composerConfig, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable PathMappingSettings pathMapping) {
        String finalExecutablePath;
        String executablePath;
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(40);
        }
        if (composerConfig == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(41);
        }
        if (configuration == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(42);
        }
        if ((executablePath = configuration.getExecutablePath()) == null) {
            return false;
        }
        PathMappingSettings finalPathMapping = pathMapping != null ? pathMapping : PhpTestFrameworkSettingsManager.getPathMappingsByConfiguration(project, configuration);
        String string = finalExecutablePath = finalPathMapping != null ? finalPathMapping.convertToLocal(executablePath) : executablePath;
        if (finalPathMapping != null && !FileUtil.exists((String)finalExecutablePath)) {
            return composerConfig.equals(ComposerConfigManager.getInstance(project).getMainConfig());
        }
        return PhpTestFrameworkComposerConfig.isControlledByComposer(project, finalExecutablePath, composerConfig);
    }

    private static PathMappingSettings getPathMappingsByConfiguration(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration configuration) {
        if (configuration == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(43);
        }
        if (configuration instanceof PhpSdkDependentConfiguration) {
            PhpSdkDependentConfiguration sdkDependentConfiguration = (PhpSdkDependentConfiguration)((Object)configuration);
            PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
            PhpInterpreter configurationInterpreter = manager.findInterpreterById(sdkDependentConfiguration.getInterpreterId());
            if (configurationInterpreter != null) {
                PhpRemoteInterpreterManager remoteManager = PhpRemoteInterpreterManager.getInstance();
                PhpSdkAdditionalData sdkData = configurationInterpreter.getPhpSdkAdditionalData();
                return remoteManager != null && configurationInterpreter.isRemote() ? remoteManager.createPathMappings(project, sdkData) : null;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends PhpTestFrameworkConfiguration> T getConfigurationByInterpreter(@NotNull Project project, @NotNull Collection<T> configurations, @NotNull PhpInterpreter interpreter, @Nullable VirtualFile locationContext) {
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(44);
        }
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(45);
        }
        if (interpreter == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(46);
        }
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        PhpSdkAdditionalData sdkData = interpreter.getPhpSdkAdditionalData();
        PathMappingSettings pathMappings = manager != null && interpreter.isRemote() ? manager.createPathMappings(project, sdkData) : null;
        for (PhpTestFrameworkConfiguration setting : PhpTestFrameworkSettingsManager.filterConfigsByLocation(project, configurations, pathMappings, locationContext)) {
            if (!(setting instanceof PhpSdkDependentConfiguration)) continue;
            PhpSdkDependentConfiguration sdkConfig = (PhpSdkDependentConfiguration)((Object)setting);
            if (!interpreter.getId().equals(sdkConfig.getInterpreterId())) continue;
            return (T)setting;
        }
        return null;
    }

    public static <T extends PhpTestFrameworkConfiguration> T findLocalConfiguration(@NotNull Collection<T> configurations) {
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(47);
        }
        for (PhpTestFrameworkConfiguration configuration : configurations) {
            if (!configuration.isLocal()) continue;
            return (T)configuration;
        }
        return null;
    }

    public static <T extends PhpTestFrameworkConfiguration> T findRemoteConfiguration(@NotNull Collection<T> configurations) {
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(48);
        }
        for (PhpTestFrameworkConfiguration configuration : configurations) {
            if (configuration.isLocal()) continue;
            return (T)configuration;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 11, 12, 13, 16, 33, 34, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 7: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 15: 
            case 17: 
            case 32: 
            case 36: 
            case 45: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerConfig";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworks";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addSettingsIfAbsent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfigurations";
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "filterConfigsByLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleCollisions";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsIfAbsent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAllConfigurations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLocalConfig";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteConfig";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLocalConfig";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRemoteConfig";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfig";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setLocalConfig";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateByInterpreter";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fillSettings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getConfigByInterpreter";
                break;
            }
            case 31: 
            case 32: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "filterConfigsByLocation";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isControlledByComposer";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingsByConfiguration";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationByInterpreter";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findLocalConfiguration";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 11, 12, 13, 16, 33, 34, 37, 38, 39 -> new IllegalStateException(string);
        };
    }

    @State(name="PhpTestFrameworkSettings", storages={@Storage(value="php-test-framework.xml")}, category=SettingsCategory.TOOLS)
    public static class PhpTestFrameworkApplicationSettingsManager
    extends PhpTestFrameworkBaseSettingsManager {
        public static PhpTestFrameworkApplicationSettingsManager getInstance() {
            return (PhpTestFrameworkApplicationSettingsManager)ApplicationManager.getApplication().getService(PhpTestFrameworkApplicationSettingsManager.class);
        }

        @Override
        @NotNull
        public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType frameworkType) {
            if (frameworkType == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(0);
            }
            List<PhpTestFrameworkConfiguration> list = this.myState.getConfigurationsByKey(frameworkType.getID());
            if (list == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(1);
            }
            return list;
        }

        public PhpTestFrameworkConfiguration addIfAbsent(@NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable String interpreterId, @Nullable VirtualFile locationContext) {
            if (frameworkType == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(2);
            }
            if (configuration == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(3);
            }
            return this.myState.addIfAbsent(frameworkType.getID(), this.myProject, configuration, interpreterId, locationContext);
        }

        @Override
        public void setConfigurations(@NotNull PhpTestFrameworkType frameworkType, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
            if (frameworkType == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(4);
            }
            if (configurations == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(5);
            }
            if (configurations.isEmpty()) {
                this.myState.removeConfigurations(frameworkType.getID());
            } else {
                this.myState.setConfigurationsByKey(frameworkType.getID(), configurations, this.myProject);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameworkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkApplicationSettingsManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkApplicationSettingsManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addIfAbsent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setConfigurations";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @State(name="PhpTestFrameworkSettings", storages={@Storage(value="php-test-framework.xml")})
    private static class PhpTestFrameworkProjectSettingsManager
    extends PhpTestFrameworkBaseSettingsManager {
        public static PhpTestFrameworkProjectSettingsManager getInstance(@NotNull Project project) {
            if (project == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(0);
            }
            return (PhpTestFrameworkProjectSettingsManager)project.getService(PhpTestFrameworkProjectSettingsManager.class);
        }

        PhpTestFrameworkProjectSettingsManager(@NotNull Project project) {
            if (project == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(1);
            }
            super(project);
        }

        @Override
        @NotNull
        public Set<PhpTestFrameworkType> getFrameworks() {
            HashSet<PhpTestFrameworkType> frameworks = new HashSet<PhpTestFrameworkType>(super.getFrameworks());
            for (PhpTestFrameworkOldConfigHolder holder : PhpTestFrameworkOldConfigHolder.getInstances()) {
                frameworks.add(holder.getFrameworkType());
            }
            HashSet<PhpTestFrameworkType> hashSet = frameworks;
            if (hashSet == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public PhpTestFrameworkConfiguration getLocalConfig(@NotNull PhpTestFrameworkType frameworkType) {
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(3);
            }
            return PhpTestFrameworkSettingsManager.findLocalConfiguration(this.getConfigurations(frameworkType));
        }

        @Nullable
        public PhpTestFrameworkConfiguration getLocalConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable VirtualFile locationContext) {
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(4);
            }
            Collection<PhpTestFrameworkConfiguration> configurations = PhpTestFrameworkSettingsManager.filterConfigsByLocation(this.myProject, this.getConfigurations(frameworkType), locationContext);
            return PhpTestFrameworkSettingsManager.findLocalConfiguration(configurations);
        }

        @Nullable
        public PhpTestFrameworkConfiguration getRemoteConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable VirtualFile locationContext) {
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(5);
            }
            Collection<PhpTestFrameworkConfiguration> configurations = PhpTestFrameworkSettingsManager.filterConfigsByLocation(this.myProject, this.getConfigurations(frameworkType), locationContext);
            return PhpTestFrameworkSettingsManager.findRemoteConfiguration(configurations);
        }

        @Override
        @NotNull
        public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType frameworkType) {
            List<PhpTestFrameworkConfiguration> configurations;
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(6);
            }
            if (!(configurations = this.myState.getConfigurationsByKey(frameworkType.getID())).isEmpty()) {
                configurations.forEach(i -> i.setFrameworkType(frameworkType));
                List<PhpTestFrameworkConfiguration> list = configurations;
                if (list == null) {
                    PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(7);
                }
                return list;
            }
            for (PhpTestFrameworkOldConfigHolder holder : PhpTestFrameworkOldConfigHolder.getInstances()) {
                if (!holder.getFrameworkType().equals(frameworkType)) continue;
                List<PhpTestFrameworkConfiguration> list = holder.getConfigurations(this.myProject);
                if (list == null) {
                    PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(8);
                }
                return list;
            }
            return new SmartList();
        }

        public PhpTestFrameworkConfiguration addIfAbsent(@NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable String interpreterId, @Nullable VirtualFile locationContext) {
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(9);
            }
            if (configuration == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(10);
            }
            return this.myState.addIfAbsent(frameworkType.getID(), this.myProject, configuration, interpreterId, locationContext);
        }

        @Override
        public void setConfigurations(@NotNull PhpTestFrameworkType frameworkType, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(11);
            }
            if (configurations == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(12);
            }
            for (PhpTestFrameworkOldConfigHolder holder : PhpTestFrameworkOldConfigHolder.getInstances()) {
                if (!holder.getFrameworkType().equals(frameworkType)) continue;
                holder.removeAllConfigurations(this.myProject);
            }
            if (configurations.isEmpty()) {
                this.myState.removeConfigurations(frameworkType.getID());
            } else {
                this.myState.setConfigurationsByKey(frameworkType.getID(), configurations, this.myProject);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkProjectSettingsManager";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameworkType";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkProjectSettingsManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrameworks";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalConfig";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getRemoteConfig";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addIfAbsent";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setConfigurations";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

