/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.google.gson.JsonElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a$\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"getRemovedAutoConfigurable", "", "Lcom/jetbrains/php/testFramework/PhpTestFrameworkComposerConfig;", "project", "Lcom/intellij/openapi/project/Project;", "newExecutablePaths", "", "", "hasComposerPackage", "", "executablePath", "composerClient", "getComposerConfigClient", "configuration", "Lcom/jetbrains/php/testFramework/PhpTestFrameworkConfiguration;", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpTestFrameworksAutoConfigurableChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpTestFrameworksAutoConfigurableChecker.kt\ncom/jetbrains/php/testFramework/PhpTestFrameworksAutoConfigurableCheckerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n774#2:43\n865#2,2:44\n1557#2:46\n1628#2,3:47\n774#2:50\n865#2,2:51\n*S KotlinDebug\n*F\n+ 1 PhpTestFrameworksAutoConfigurableChecker.kt\ncom/jetbrains/php/testFramework/PhpTestFrameworksAutoConfigurableCheckerKt\n*L\n14#1:43\n14#1:44,2\n15#1:46\n15#1:47,3\n16#1:50\n16#1:51,2\n*E\n"})
public final class PhpTestFrameworksAutoConfigurableCheckerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PhpTestFrameworkComposerConfig> getRemovedAutoConfigurable(@NotNull Project project, @NotNull Set<String> newExecutablePaths) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        PhpTestFrameworkConfiguration it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(newExecutablePaths, (String)"newExecutablePaths");
        ComposerDataService composerDataService = ComposerDataService.getInstance(project);
        List<PhpTestFrameworkConfiguration> list = PhpTestFrameworkSettingsManager.getInstance(project).getAllConfigurations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllConfigurations(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PhpTestFrameworkConfiguration)element$iv$iv;
            boolean bl = false;
            if (!it.isLocal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PhpTestFrameworkConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getExecutablePath();
            Intrinsics.checkNotNull((Object)it);
            collection.add(TuplesKt.to((Object)string, (Object)PhpTestFrameworksAutoConfigurableCheckerKt.getComposerConfigClient(project, it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            PhpTestFrameworkComposerConfig composerClient = (PhpTestFrameworkComposerConfig)pair.component2();
            if (!(composerClient != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set autoConfiguredPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (autoConfiguredPaths.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)autoConfiguredPaths), arg_0 -> PhpTestFrameworksAutoConfigurableCheckerKt.getRemovedAutoConfigurable$lambda$3(newExecutablePaths, project, composerDataService, arg_0)), PhpTestFrameworksAutoConfigurableCheckerKt::getRemovedAutoConfigurable$lambda$4));
    }

    private static final boolean hasComposerPackage(Project project, String executablePath, PhpTestFrameworkComposerConfig composerClient) {
        if (executablePath == null || composerClient == null) {
            return false;
        }
        String string = ComposerConfigManager.Companion.getInstance(project).getConfigPath(executablePath);
        if (string == null) {
            return false;
        }
        String composerPath = string;
        VirtualFile virtualFile = ComposerUtils.refreshAndFindFileByPath(composerPath);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile composerFile = virtualFile;
        JsonElement composerJson = ComposerConfigUtils.parseJson(composerFile);
        return composerClient.hasPackage(project, composerJson, composerFile);
    }

    private static final PhpTestFrameworkComposerConfig getComposerConfigClient(Project project, PhpTestFrameworkConfiguration configuration) {
        if (!configuration.isLocal()) {
            return null;
        }
        String string = ComposerConfigManager.Companion.getInstance(project).getConfigPath(configuration.getExecutablePath());
        if (string == null) {
            return null;
        }
        String composerPath = string;
        VirtualFile composerFile = ComposerUtils.refreshAndFindFileByPath(composerPath);
        Object object = ComposerLibraryServiceFactory.Companion.getInstance(project, composerFile).getVendorDir();
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object vendorPath = object;
        return (PhpTestFrameworkComposerConfig)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)ComposerConfigClient.EP_NAME.getExtensionList()), PhpTestFrameworkComposerConfig.class), arg_0 -> PhpTestFrameworksAutoConfigurableCheckerKt.getComposerConfigClient$lambda$5((String)vendorPath, configuration, arg_0)));
    }

    private static final boolean getRemovedAutoConfigurable$lambda$3(Set $newExecutablePaths, Project $project, ComposerDataService $composerDataService, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String autoConfiguredPath = (String)pair.component1();
        PhpTestFrameworkComposerConfig composerClient = (PhpTestFrameworkComposerConfig)pair.component2();
        return composerClient != null && !CollectionsKt.contains((Iterable)$newExecutablePaths, (Object)autoConfiguredPath) && PhpTestFrameworksAutoConfigurableCheckerKt.hasComposerPackage($project, autoConfiguredPath, composerClient) && $composerDataService.isTestFrameworkSyncEnabled(composerClient.getFrameworkType());
    }

    private static final PhpTestFrameworkComposerConfig getRemovedAutoConfigurable$lambda$4(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        PhpTestFrameworkComposerConfig composerClient = (PhpTestFrameworkComposerConfig)pair.component2();
        return composerClient;
    }

    private static final boolean getComposerConfigClient$lambda$5(String $vendorPath, PhpTestFrameworkConfiguration $configuration, PhpTestFrameworkComposerConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getExecutablePath($vendorPath), (Object)$configuration.getExecutablePath());
    }
}

