/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.run;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.Function;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.ComposerInstallAction;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRefactoringListenerRunConfiguration;
import com.jetbrains.php.run.PhpRunConfigurationExtensionsManager;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.RunConfigurationInterpreterProvider;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationEditor;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerConfigurationEditor;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettingsValidator;
import com.jetbrains.php.util.PhpConfigurationUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestRunConfiguration
extends PhpRefactoringListenerRunConfiguration<PhpTestRunConfigurationSettings>
implements LocatableConfiguration,
SMRunnerConsolePropertiesProvider,
RunConfigurationInterpreterProvider {
    private final PhpTestFrameworkType myFrameworkType;
    private final Runnable myShowSettingsRunnable;
    private final PhpTestRunnerSettingsValidator myValidator;
    private final PhpTestRunConfigurationHandler myHandler;
    private final PhpTestFrameworkVersionDetector myVersionDetector;
    private static final Logger LOG = Logger.getInstance(PhpTestRunConfiguration.class);
    SettingsEditor extensionSettingsEditor;

    protected PhpTestRunConfiguration(Project project, ConfigurationFactory factory, String name, @NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestRunnerSettingsValidator validator, @NotNull PhpTestRunConfigurationHandler handler) {
        if (frameworkType == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (validator == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(2);
        }
        this(project, factory, name, frameworkType, validator, handler, null);
    }

    protected PhpTestRunConfiguration(Project project, ConfigurationFactory factory, String name, @NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestRunnerSettingsValidator validator, @NotNull PhpTestRunConfigurationHandler handler, @Nullable PhpTestFrameworkVersionDetector versionDetector) {
        if (frameworkType == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(3);
        }
        if (validator == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(4);
        }
        if (handler == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(5);
        }
        super(project, factory, name);
        this.myFrameworkType = frameworkType;
        this.myValidator = validator;
        this.myHandler = handler;
        this.myVersionDetector = versionDetector;
        this.myShowSettingsRunnable = PhpTestFrameworksConfigurable.createFix(project, this.myFrameworkType, this.getInterpreter());
    }

    @NotNull
    public String getFrameworkName() {
        String string = this.myFrameworkType.getDisplayName();
        if (string == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected PhpTestRunConfigurationSettings createSettings() {
        return new PhpTestRunConfigurationSettings();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhpTestRunConfigurationEditor phpTestRunConfigurationEditor = this.getConfigurationEditor(new EnumMap<PhpTestRunnerSettings.Scope, String>(PhpTestRunnerSettings.Scope.class));
        if (phpTestRunConfigurationEditor == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(7);
        }
        return phpTestRunConfigurationEditor;
    }

    protected SettingsEditor<? extends RunConfiguration> addExtensionEditor(PhpTestRunConfigurationEditor testEditor) {
        return PhpRunConfigurationExtensionsManager.getInstance().addExtensionEditor(testEditor, this, () -> testEditor.getInterpreter());
    }

    @NotNull
    protected PhpTestRunConfigurationEditor getConfigurationEditor(@NotNull Map<PhpTestRunnerSettings.Scope, @Nls String> scopes) {
        if (scopes == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(8);
        }
        return new PhpTestRunConfigurationEditor(this.getProject(), this.myFrameworkType, scopes, (Function<? super PhpTestRunnerConfigurationEditor, ? extends TextFieldCompletionProvider>)((Function)this::createMethodFieldCompletionProvider));
    }

    @NotNull
    protected abstract TextFieldCompletionProvider createMethodFieldCompletionProvider(@NotNull PhpTestRunnerConfigurationEditor var1);

    public void checkConfiguration() throws RuntimeConfigurationException {
        Project project = this.getProject();
        PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)this.getSettings();
        PhpInterpreter interpreter = this.getInterpreter();
        PhpRunUtil.checkCommandLineSettings(project, settings.getCommandLineSettings(), settings.getCommandLineSettings().getInterpreterSettings().getInterpreterName());
        PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
        VirtualFile baseFile = this.getBaseFile(null, interpreter);
        PhpTestFrameworkConfiguration configuration = PhpTestFrameworkSettingsManager.getInstance(project).getOrCreateByInterpreter(this.myFrameworkType, interpreter, baseFile, true);
        if (configuration == null) {
            VirtualFile composerConfig = ComposerConfigManager.getInstance(project).getConfig(baseFile);
            ComposerLibraryService composerService = ComposerLibraryServiceFactory.getInstance(project, composerConfig);
            ComposerDataService composerDataService = ComposerDataService.getInstance(project);
            if (composerDataService.isConfigWellConfigured() && ComposerConfigUtils.findRequiresDirectiveValue(composerConfig, this.myFrameworkType.getComposerPackageNames(), true) != null && !composerService.vendorDirExists()) {
                throw new RuntimeConfigurationError(PhpBundle.message("test.not.tests.was.executed.title", this.getFrameworkName()), () -> new ComposerInstallAction().act(project, composerConfig, "PhpTestRunConfiguration"));
            }
            String target = interpreter != null && interpreter.isRemote() ? "'" + interpreter.getName() + "' interpreter" : "local machine";
            String message = PhpBundle.message("php.test.framework.settings.is.not.provided.or.empty", this.getFrameworkName(), target);
            throw new RuntimeConfigurationError(message, this.myShowSettingsRunnable);
        }
        VirtualFile workingDirectory = PhpTestRunConfiguration.findDirectory(project, interpreter, this.getWorkingDirectory(project, settings, configuration));
        if (workingDirectory == null) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Working directory"));
        }
        switch (testRunnerSettings.getScope()) {
            case Type: {
                String typeError = this.myValidator.isTypeValid(testRunnerSettings.getSelectedType());
                if (!StringUtil.isNotEmpty((String)typeError)) break;
                throw new RuntimeConfigurationError(typeError);
            }
            case Directory: {
                String path = testRunnerSettings.getDirectoryPath();
                if (StringUtil.isEmpty((String)path)) {
                    if (this.myValidator.isEmptyDirectoryValid()) break;
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Directory"));
                }
                String error = this.myValidator.isDirectoryValid(PhpRunUtil.findDirectory(path), workingDirectory);
                if (!StringUtil.isNotEmpty((String)error)) break;
                throw new RuntimeConfigurationError(error);
            }
            case File: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                String error = this.myValidator.isFileValid(file, workingDirectory);
                if (!StringUtil.isNotEmpty((String)error)) break;
                throw new RuntimeConfigurationError(error);
            }
            case Method: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                String fileError = this.myValidator.isFileValid(file, workingDirectory);
                if (StringUtil.isNotEmpty((String)fileError)) {
                    throw new RuntimeConfigurationError(fileError);
                }
                String methodError = this.myValidator.isMethodValid(file, testRunnerSettings.getMethodName());
                if (!StringUtil.isNotEmpty((String)methodError)) break;
                throw new RuntimeConfigurationError(methodError);
            }
            case ConfigurationFile: {
                if (testRunnerSettings.isUseAlternativeConfigurationFile() || configuration.isUseConfigurationFile()) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Configuration file"), this.myShowSettingsRunnable);
            }
        }
        if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
            if (!PhpRunUtil.isValidFilePath(testRunnerSettings.getConfigurationFilePath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Configuration file"));
            }
        } else if (configuration.isUseConfigurationFile() && interpreter != null && !interpreter.isRemote() && !PhpRunUtil.isValidFilePath(configuration.getConfigurationFilePath())) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Configuration file"), this.myShowSettingsRunnable);
        }
        if (interpreter != null && !interpreter.isRemote() && !PhpRunUtil.isValidFileOrDirectoryPath(configuration.getExecutablePath())) {
            String name = "Path to " + this.getFrameworkName();
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", name), this.myShowSettingsRunnable);
        }
    }

    @Nullable
    protected String getWorkingDirectory(@NotNull Project project, @NotNull PhpTestRunConfigurationSettings settings, @Nullable PhpTestFrameworkConfiguration config) {
        PhpCommandLineSettings cli;
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(10);
        }
        if (StringUtil.isNotEmpty((String)(cli = settings.getCommandLineSettings()).getWorkingDirectory())) {
            return cli.getWorkingDirectory();
        }
        VirtualFile baseFile = this.getBaseFile(config, this.getInterpreter());
        if (baseFile != null) {
            ComposerConfigManager composerConfigManager = ComposerConfigManager.getInstance(project);
            VirtualFile composerConfig = composerConfigManager.getConfig(baseFile);
            if (composerConfig != null && !composerConfig.equals(composerConfigManager.getMainConfig())) {
                return composerConfig.getParent().getPath();
            }
            VirtualFile root = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(baseFile);
            if (root != null) {
                return root.getPath();
            }
        }
        return project.getBasePath();
    }

    @Nullable
    public VirtualFile getBaseFile(@Nullable PhpTestFrameworkConfiguration config, @Nullable PhpInterpreter interpreter) {
        PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)this.getSettings()).getRunnerSettings();
        PhpTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Directory: {
                String directory = testRunnerSettings.getDirectoryPath();
                if (StringUtil.isEmptyOrSpaces((String)directory)) break;
                return PhpTestRunConfiguration.findDirectory(this.getProject(), interpreter, directory);
            }
            case File: 
            case Method: {
                String filePath = testRunnerSettings.getFilePath();
                if (StringUtil.isEmptyOrSpaces((String)filePath)) break;
                return PhpTestRunConfiguration.findFile(this.getProject(), interpreter, filePath);
            }
            case ConfigurationFile: {
                String configurationFilePath = PhpTestRunConfiguration.getConfigurationFile(testRunnerSettings, config);
                if (StringUtil.isEmptyOrSpaces((String)configurationFilePath)) break;
                return PhpTestRunConfiguration.findFile(this.getProject(), interpreter, configurationFilePath);
            }
        }
        return null;
    }

    public static VirtualFile findFileOrDirectory(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable String path) {
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(11);
        }
        if (interpreter == null || !interpreter.isRemote()) {
            return PhpRunUtil.findFileOrDirectory(path, false);
        }
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        PhpSdkAdditionalData interpreterData = interpreter.getPhpSdkAdditionalData();
        PathMappingSettings pathMappings = manager != null ? manager.createPathMappings(project, interpreterData) : null;
        String actualPath = pathMappings != null && path != null ? pathMappings.convertToLocal(path) : path;
        return PhpRunUtil.findFileOrDirectory(actualPath, false);
    }

    public static VirtualFile findFile(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable String path) {
        VirtualFile file;
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(12);
        }
        return (file = PhpTestRunConfiguration.findFileOrDirectory(project, interpreter, path)) != null && !file.isDirectory() ? file : null;
    }

    public static VirtualFile findDirectory(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable String path) {
        VirtualFile file;
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(13);
        }
        return (file = PhpTestRunConfiguration.findFileOrDirectory(project, interpreter, path)) != null && file.isDirectory() ? file : null;
    }

    @Nullable
    public static String getConfigurationFile(@NotNull PhpTestRunnerSettings testRunnerSettings, @Nullable PhpTestFrameworkConfiguration configuration) {
        if (testRunnerSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(14);
        }
        if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
            return testRunnerSettings.getConfigurationFilePath();
        }
        if (configuration != null && configuration.isUseConfigurationFile()) {
            return configuration.getConfigurationFilePath();
        }
        return null;
    }

    @NotNull
    public PhpCommandSettings createCommand(@NotNull PhpInterpreter interpreter, @NotNull Map<String, String> env, @NotNull List<String> arguments, boolean withDebugger) throws ExecutionException {
        if (interpreter == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(15);
        }
        if (env == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(16);
        }
        if (arguments == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(17);
        }
        VirtualFile baseFile = this.getBaseFile(null, interpreter);
        PhpTestFrameworkConfiguration frameworkConfig = PhpTestFrameworkSettingsManager.getInstance(this.myProject).getOrCreateByInterpreter(this.myFrameworkType, interpreter, baseFile, true);
        PhpCommandSettings phpCommandSettings = this.createCommand(interpreter, env, arguments, frameworkConfig, withDebugger);
        if (phpCommandSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(18);
        }
        return phpCommandSettings;
    }

    @NotNull
    public PhpCommandSettings createCommand(@NotNull PhpInterpreter interpreter, @NotNull Map<String, String> env, @NotNull List<String> arguments, @Nullable PhpTestFrameworkConfiguration frameworkConfig, boolean withDebugger) throws ExecutionException {
        if (interpreter == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(19);
        }
        if (env == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(20);
        }
        if (arguments == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(21);
        }
        if (this.myHandler == null) {
            throw new ExecutionException(PhpBundle.message("can.not.execute.tests", new Object[0]));
        }
        Project project = this.getProject();
        PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)this.getSettings();
        PhpCommandSettings command = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug(withDebugger).build();
        if (frameworkConfig == null || StringUtil.isEmptyOrSpaces((String)frameworkConfig.getExecutablePath())) {
            String target = command.isRemote() ? "'" + interpreter.getName() + "' interpreter" : "local machine";
            String message = PhpBundle.message("php.interpreter.base.configuration.is.not.provided.or.empty", this.getFrameworkName(), target);
            throw new ExecutionException(message);
        }
        String version = null;
        if (this.myVersionDetector != null && StringUtil.isEmpty((String)(version = PhpTestFrameworkVersionCache.getCache(project, frameworkConfig)))) {
            try {
                version = this.myVersionDetector.getVersion(project, interpreter, frameworkConfig.getExecutablePath()).toString();
                PhpTestFrameworkVersionCache.setCache(project, frameworkConfig, version);
            }
            catch (ExecutionException message) {
                // empty catch block
            }
        }
        this.myHandler.prepareCommand(project, command, frameworkConfig.getExecutablePath(), version);
        String workingDirectory = this.getWorkingDirectory(project, settings, frameworkConfig);
        if (StringUtil.isEmptyOrSpaces((String)workingDirectory)) {
            throw new ExecutionException(PhpBundle.message("php.interpreter.base.configuration.working.directory", new Object[0]));
        }
        command.importCommandLineSettings(settings.getCommandLineSettings(), workingDirectory);
        command.addEnvs(env);
        PhpTestRunConfiguration.fillTestRunnerArguments(project, workingDirectory, settings.getRunnerSettings(), arguments, command, frameworkConfig, this.myHandler);
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(22);
        }
        return phpCommandSettings;
    }

    public static void fillTestRunnerArguments(@NotNull Project project, @NotNull String workingDirectory, @NotNull PhpTestRunnerSettings testRunnerSettings, @NotNull List<String> arguments, @NotNull PhpCommandSettings command, @Nullable PhpTestFrameworkConfiguration configuration, @NotNull PhpTestRunConfigurationHandler handler) throws ExecutionException {
        String testRunnerOptions;
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(23);
        }
        if (workingDirectory == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(24);
        }
        if (testRunnerSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(25);
        }
        if (arguments == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(26);
        }
        if (command == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(27);
        }
        if (handler == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(28);
        }
        if (StringUtil.isNotEmpty((String)(testRunnerOptions = testRunnerSettings.getTestRunnerOptions()))) {
            command.addArguments(Arrays.asList(ParametersList.parse((String)testRunnerOptions)));
        }
        command.addArguments(arguments);
        String configurationFilePath = PhpTestRunConfiguration.getConfigurationFile(testRunnerSettings, configuration);
        if (StringUtil.isNotEmpty((String)configurationFilePath)) {
            command.addArgument(handler.getConfigFileOption());
            if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
                command.addPathArgument(configurationFilePath);
            } else {
                command.addArgument(configurationFilePath);
            }
        }
        PhpTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Type: {
                handler.runType(project, command, StringUtil.notNullize((String)testRunnerSettings.getSelectedType()), workingDirectory);
                break;
            }
            case Directory: {
                handler.runDirectory(project, command, StringUtil.notNullize((String)testRunnerSettings.getDirectoryPath()), workingDirectory);
                break;
            }
            case File: {
                handler.runFile(project, command, StringUtil.notNullize((String)testRunnerSettings.getFilePath()), workingDirectory);
                break;
            }
            case Method: {
                String filePath = StringUtil.notNullize((String)testRunnerSettings.getFilePath());
                handler.runMethod(project, command, filePath, testRunnerSettings.getMethodName(), workingDirectory);
                break;
            }
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        PhpInterpreter interpreter;
        if (executor == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(29);
        }
        if (env == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(30);
        }
        if ((interpreter = this.getInterpreter()) == null) {
            return null;
        }
        PhpCommandSettings command = this.createCommand(interpreter, Collections.emptyMap(), (List<String>)new SmartList(), false);
        return this.getState(env, command, null);
    }

    @Override
    public PhpInterpreter getInterpreter() {
        String interpreterName = ((PhpTestRunConfigurationSettings)this.getSettings()).getCommandLineSettings().getInterpreterSettings().getInterpreterName();
        if (interpreterName != null) {
            return PhpInterpretersManagerImpl.getInstance(this.getProject()).findInterpreter(interpreterName);
        }
        return PhpProjectConfigurationFacade.getInstance(this.getProject()).getInterpreter();
    }

    protected boolean isPtyEnabled() {
        return PtyCommandLine.isEnabled();
    }

    @Nullable
    public RunProfileState getState(@NotNull ExecutionEnvironment env, final @NotNull PhpCommandSettings command, final @Nullable ProcessListener listener) throws ExecutionException {
        if (env == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(31);
        }
        if (command == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(32);
        }
        final Project project = this.getProject();
        final PhpPathMapper pathMapper = command.getPathProcessor().createPathMapper(project);
        CommandLineState commandLineState = new CommandLineState(env){

            @NotNull
            protected ProcessHandler startProcess() throws ExecutionException {
                GeneralCommandLine commandLine = command.createGeneralCommandLine(PhpTestRunConfiguration.this.isPtyEnabled());
                PhpRunConfigurationExtensionsManager.getInstance().patchCommandLine((RunConfigurationBase)PhpTestRunConfiguration.this.getRunConfiguration(), this.getRunnerSettings(), commandLine, this.getEnvironment().getRunner().getRunnerId(), this.getEnvironment().getExecutor());
                ProcessHandler processHandler = PhpTestRunConfiguration.this.createProcessHandler(PhpTestRunConfiguration.this.getProject(), command, PhpTestRunConfiguration.this.isPtyEnabled(), commandLine);
                PhpRunUtil.attachProcessOutputDebugDumper(processHandler);
                PhpTestRunConfiguration.attachIntegrationTestDumper(processHandler, project);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
                if (listener != null) {
                    processHandler.addProcessListener(listener);
                }
                ProcessHandler processHandler2 = processHandler;
                if (processHandler2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processHandler2;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(2);
                }
                ProcessHandler processHandler = this.startProcess();
                SMTRunnerConsoleProperties properties = PhpTestRunConfiguration.this.createTestConsoleProperties(executor);
                Ref ref = Ref.create();
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole((String)PhpTestRunConfiguration.this.myFrameworkType.getID(), (TestConsoleProperties)properties);
                    console.attachToProcess(processHandler);
                    Disposer.register((Disposable)PhpTestFrameworkSettingsManager.getInstance(project), (Disposable)console);
                    ref.set((Object)console);
                });
                ConsoleView consoleView = (ConsoleView)ref.get();
                PhpTestRunConfiguration.this.addMessageFilters(consoleView, project, pathMapper);
                DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
                AbstractRerunFailedTestsAction rerun = PhpTestRunConfiguration.this.createRerunAction(consoleView, properties);
                if (rerun != null) {
                    rerun.setModelProvider(() -> {
                        if (consoleView instanceof SMTRunnerConsoleView) {
                            return ((SMTRunnerConsoleView)consoleView).getResultsViewer();
                        }
                        return null;
                    });
                    result.setRestartActions(new AnAction[]{rerun, new ToggleAutoTestAction()});
                }
                DefaultExecutionResult defaultExecutionResult = result;
                if (defaultExecutionResult == null) {
                    1.$$$reportNull$$$0(3);
                }
                return defaultExecutionResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        commandLineState.addConsoleFilters(PhpExecutionUtil.getConsoleMessageFilters(project, pathMapper));
        return commandLineState;
    }

    private static void attachIntegrationTestDumper(@NotNull ProcessHandler processHandler, @NotNull Project project) {
        if (processHandler == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(33);
        }
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(34);
        }
        if (!ApplicationManagerEx.isInIntegrationTest()) {
            return;
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        final Path dumpFile = Objects.requireNonNull(projectDir).toNioPath().resolve("test_dump.txt");
        try {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                private final Writer myWriter;
                private boolean myIsTerminated;
                {
                    this.myWriter = Files.newBufferedWriter(dumpFile, new OpenOption[0]);
                    this.myIsTerminated = false;
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (ApplicationManagerEx.isInIntegrationTest() && !this.myIsTerminated) {
                        try {
                            this.myWriter.append(event.getText());
                        }
                        catch (IOException e) {
                            LOG.error("Failed to log event for integration test", (Throwable)e);
                        }
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    try {
                        if (StringUtil.isNotEmpty((String)event.getText())) {
                            this.myWriter.append(event.getText());
                        }
                        this.myWriter.close();
                        this.myIsTerminated = true;
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close dump writer for integration test", (Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (IOException e) {
            LOG.error("Failed to configure dump writer for integration test", (Throwable)e);
        }
    }

    @Nullable
    protected AbstractRerunFailedTestsAction createRerunAction(@NotNull ConsoleView consoleView, @NotNull SMTRunnerConsoleProperties properties) {
        if (consoleView == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(35);
        }
        if (properties == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(36);
        }
        return null;
    }

    protected void addMessageFilters(@NotNull ConsoleView consoleView, @NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (consoleView == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(37);
        }
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(38);
        }
        if (pathMapper == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(39);
        }
        PhpExecutionUtil.addMessageFilters(project, consoleView, pathMapper);
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(40);
        }
        return new SMTRunnerConsoleProperties((RunConfiguration)this, this.myFrameworkType.getID(), executor);
    }

    public boolean isGeneratedName() {
        return PhpRunUtil.isGeneratedName(this);
    }

    @Nullable
    public String suggestedName() {
        PhpTestRunnerSettings runner = ((PhpTestRunConfigurationSettings)this.getSettings()).getRunnerSettings();
        PhpTestRunnerSettings.Scope scope = runner.getScope();
        return switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case PhpTestRunnerSettings.Scope.Type -> StringUtil.notNullize((String)runner.getSelectedType());
            case PhpTestRunnerSettings.Scope.File -> PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getFilePath()));
            case PhpTestRunnerSettings.Scope.Directory -> PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getDirectoryPath()));
            case PhpTestRunnerSettings.Scope.Method -> {
                String file = PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getFilePath()));
                yield file + "::" + runner.getMethodName();
            }
            case PhpTestRunnerSettings.Scope.ConfigurationFile -> PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getConfigurationFilePath()));
        };
    }

    @Nullable
    public String getActionName() {
        PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)this.getSettings()).getRunnerSettings();
        PhpTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        if (scope == PhpTestRunnerSettings.Scope.Method && StringUtil.isNotEmpty((String)testRunnerSettings.getMethodName())) {
            String methodName = testRunnerSettings.getMethodName();
            return methodName.length() < 20 ? methodName : methodName.substring(0, 20) + "...";
        }
        return super.getActionName();
    }

    @Override
    protected void fixSettingsAfterDeserialization(@NotNull PhpTestRunConfigurationSettings settings) {
        if (settings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(41);
        }
        PhpTestRunnerSettings runnerSettings = settings.getRunnerSettings();
        runnerSettings.setDirectoryPath(PhpConfigurationUtil.deserializePath(runnerSettings.getDirectoryPath()));
        runnerSettings.setFilePath(PhpConfigurationUtil.deserializePath(runnerSettings.getFilePath()));
        runnerSettings.setConfigurationFilePath(PhpConfigurationUtil.deserializePath(runnerSettings.getConfigurationFilePath()));
    }

    @Override
    protected void fixSettingsBeforeSerialization(@NotNull PhpTestRunConfigurationSettings settings) {
        if (settings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(42);
        }
        PhpTestRunnerSettings runnerSettings = settings.getRunnerSettings();
        runnerSettings.setDirectoryPath(PhpConfigurationUtil.serializePath(runnerSettings.getDirectoryPath()));
        runnerSettings.setFilePath(PhpConfigurationUtil.serializePath(runnerSettings.getFilePath()));
        runnerSettings.setConfigurationFilePath(PhpConfigurationUtil.serializePath(runnerSettings.getConfigurationFilePath()));
    }

    @Override
    @NotNull
    protected List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> getPathsToUpdate() {
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> toUpdate = super.getPathsToUpdate();
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().getDirectoryPath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().setDirectoryPath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().getFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().setFilePath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().getConfigurationFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().setConfigurationFilePath(newValue);
            }
        });
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> list = toUpdate;
        if (list == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(43);
        }
        return list;
    }

    protected TextFieldCompletionProvider createMethodFileCompletionProvider(final @NotNull Project project, final PhpTestRunnerConfigurationEditor editor, final Predicate<Method> filter) {
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(44);
        }
        return new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                PhpClass phpClass;
                PsiFile file;
                if (text == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    6.$$$reportNull$$$0(2);
                }
                if ((file = PhpRunUtil.findPsiFile(project, editor.getByScope(PhpTestRunnerSettings.Scope.File).getText())) instanceof PhpFile && (phpClass = (PhpClass)ContainerUtil.getFirstItem(PhpPsiUtil.findAllClasses((PhpFile)file))) != null) {
                    PhpClassHierarchyUtils.processMethods(phpClass, phpClass, (method, subClass, baseClass) -> {
                        if (filter.test(method)) {
                            result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)method).withIcon(method.getIcon()));
                        }
                        return true;
                    }, false, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration$6";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected boolean showVerboseOutput() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 18, 22, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: 
            case 5: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 22: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 34: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 16: 
            case 20: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 18: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 22: 
            case 43: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationEditor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileOrDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fillTestRunnerArguments";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "attachIntegrationTestDumper";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createRerunAction";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilters";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsAfterDeserialization";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsBeforeSerialization";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFileCompletionProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 18, 22, 43 -> new IllegalStateException(string);
        };
    }
}

