/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.PhpExternalFormatterPanelKt;
import com.jetbrains.php.tools.quality.QualityToolConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolsExternalFormatterConfiguration;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintConfigurableForm;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintConfiguration;
import com.jetbrains.php.tools.quality.laravelPint.LaravelPintProjectConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfigurableForm;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerProjectConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfigurableForm;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSProjectConfiguration;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 92\u00020\u0001:\u00019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010%\u001a\u00020\u001eJ\u0014\u0010*\u001a\u00020+*\u00020\t2\u0006\u0010,\u001a\u00020-H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00100\u001a\u00020-H\u0002J\b\u00103\u001a\u000204H\u0002J\u000e\u00105\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u00106\u001a\u00020+2\u0006\u00100\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u00107\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u00108\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010&\u001a\u00020'*\b\u0012\u0004\u0012\u00020\t0\u00178F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006:"}, d2={"Lcom/jetbrains/php/tools/quality/PhpExternalFormatterPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myPhpCSBfButton", "Lcom/intellij/ui/components/JBRadioButton;", "myPhpCSFixerButton", "myLaravelPintButton", "myNoFormatterButton", "myErrorLabel", "Ljavax/swing/JLabel;", "getMyErrorLabel", "()Ljavax/swing/JLabel;", "setMyErrorLabel", "(Ljavax/swing/JLabel;)V", "myInfoLabel", "getMyInfoLabel", "setMyInfoLabel", "link", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/ActionLink;", "getLink", "()Lcom/intellij/ui/dsl/builder/Cell;", "setLink", "(Lcom/intellij/ui/dsl/builder/Cell;)V", "mainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getMainPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "setMainPanel", "(Lcom/intellij/openapi/ui/DialogPanel;)V", "validationPanel", "infoPanel", "getPanel", "selected", "Lcom/intellij/ui/layout/ComponentPredicate;", "getSelected", "(Lcom/intellij/ui/dsl/builder/Cell;)Lcom/intellij/ui/layout/ComponentPredicate;", "configure", "", "visible", "", "getConfiguration", "Lcom/jetbrains/php/tools/quality/QualityToolConfiguration;", "onInit", "getSelectedFormatterTitle", "", "getFormatter", "Lcom/jetbrains/php/tools/quality/QualityToolsExternalFormatterConfiguration$ExternalFormatter;", "reset", "validateConfiguration", "isModified", "apply", "Companion", "intellij.php.impl"})
public final class PhpExternalFormatterPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private JBRadioButton myPhpCSBfButton;
    private JBRadioButton myPhpCSFixerButton;
    private JBRadioButton myLaravelPintButton;
    private JBRadioButton myNoFormatterButton;
    public JLabel myErrorLabel;
    public JLabel myInfoLabel;
    public Cell<? extends ActionLink> link;
    @NotNull
    private DialogPanel mainPanel;
    @NotNull
    private DialogPanel validationPanel;
    @NotNull
    private DialogPanel infoPanel;

    public PhpExternalFormatterPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.validationPanel = BuilderKt.panel(arg_0 -> PhpExternalFormatterPanel.validationPanel$lambda$1(this, arg_0));
        this.infoPanel = BuilderKt.panel(arg_0 -> PhpExternalFormatterPanel.infoPanel$lambda$4(this, arg_0));
        this.mainPanel = BuilderKt.panel(arg_0 -> PhpExternalFormatterPanel._init_$lambda$12(this, arg_0));
        this.mainPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ApplicationManager.getApplication().invokeAndWait(() -> 2.ancestorAdded$lambda$0(this));
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            private static final void ancestorAdded$lambda$0(PhpExternalFormatterPanel this$0) {
                this$0.validateConfiguration(true, this$0.getProject());
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JLabel getMyErrorLabel() {
        JLabel jLabel = this.myErrorLabel;
        if (jLabel != null) {
            return jLabel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myErrorLabel");
        return null;
    }

    public final void setMyErrorLabel(@NotNull JLabel jLabel) {
        Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
        this.myErrorLabel = jLabel;
    }

    @NotNull
    public final JLabel getMyInfoLabel() {
        JLabel jLabel = this.myInfoLabel;
        if (jLabel != null) {
            return jLabel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myInfoLabel");
        return null;
    }

    public final void setMyInfoLabel(@NotNull JLabel jLabel) {
        Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
        this.myInfoLabel = jLabel;
    }

    @NotNull
    public final Cell<ActionLink> getLink() {
        Cell<? extends ActionLink> cell = this.link;
        if (cell != null) {
            return cell;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"link");
        return null;
    }

    public final void setLink(@NotNull Cell<? extends ActionLink> cell) {
        Intrinsics.checkNotNullParameter(cell, (String)"<set-?>");
        this.link = cell;
    }

    @NotNull
    public final DialogPanel getMainPanel() {
        return this.mainPanel;
    }

    public final void setMainPanel(@NotNull DialogPanel dialogPanel) {
        Intrinsics.checkNotNullParameter((Object)dialogPanel, (String)"<set-?>");
        this.mainPanel = dialogPanel;
    }

    @NotNull
    public final DialogPanel getPanel() {
        return BuilderKt.panel(arg_0 -> PhpExternalFormatterPanel.getPanel$lambda$15(this, arg_0));
    }

    @NotNull
    public final ComponentPredicate getSelected(@NotNull Cell<? extends JBRadioButton> $this$selected) {
        Intrinsics.checkNotNullParameter($this$selected, (String)"<this>");
        return ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)$this$selected.getComponent()));
    }

    private final void configure(JBRadioButton $this$configure, boolean visible) {
        $this$configure.addActionListener(arg_0 -> PhpExternalFormatterPanel.configure$lambda$17($this$configure, this, visible, arg_0));
        $this$configure.addActionListener(arg_0 -> PhpExternalFormatterPanel.configure$lambda$18($this$configure, this, visible, arg_0));
    }

    private final QualityToolConfiguration getConfiguration(boolean onInit, Project project) {
        try {
            if (onInit) {
                return Companion.getConfiguration(project);
            }
            JBRadioButton jBRadioButton = this.myPhpCSBfButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSBfButton");
                jBRadioButton = null;
            }
            if (jBRadioButton.isSelected()) {
                return PhpCSProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
            }
            JBRadioButton jBRadioButton2 = this.myPhpCSFixerButton;
            if (jBRadioButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSFixerButton");
                jBRadioButton2 = null;
            }
            if (jBRadioButton2.isSelected()) {
                return PhpCSFixerProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
            }
            JBRadioButton jBRadioButton3 = this.myLaravelPintButton;
            if (jBRadioButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLaravelPintButton");
                jBRadioButton3 = null;
            }
            if (jBRadioButton3.isSelected()) {
                return LaravelPintProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
            }
        }
        catch (QualityToolValidationException e) {
            PhpExternalFormatterPanelKt.access$getLOG$p().warn(e.getMessage());
        }
        return null;
    }

    private final String getSelectedFormatterTitle(boolean onInit) {
        String string;
        if (onInit) {
            String string2;
            QualityToolsExternalFormatterConfiguration.ExternalFormatter externalFormatter = QualityToolsExternalFormatterConfiguration.getInstance(this.project).getExternalFormatter();
            switch (externalFormatter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[externalFormatter.ordinal()]) {
                case 1: {
                    String string3 = PhpBundle.message("external.formatter.phpcbf", new Object[0]);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    break;
                }
                case 2: {
                    String string4 = PhpBundle.message("external.formatter.phpcsfixer", new Object[0]);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    break;
                }
                case 3: {
                    String string5 = PhpBundle.message("quality.tool.laravel.pint", new Object[0]);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    break;
                }
                default: {
                    string2 = "";
                }
            }
            return string2;
        }
        JBRadioButton jBRadioButton = this.myPhpCSBfButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSBfButton");
            jBRadioButton = null;
        }
        if (jBRadioButton.isSelected()) {
            String string6 = PhpBundle.message("external.formatter.phpcbf", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            return string6;
        }
        JBRadioButton jBRadioButton2 = this.myPhpCSFixerButton;
        if (jBRadioButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSFixerButton");
            jBRadioButton2 = null;
        }
        if (jBRadioButton2.isSelected()) {
            String string7 = PhpBundle.message("external.formatter.phpcsfixer", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            return string7;
        }
        JBRadioButton jBRadioButton3 = this.myLaravelPintButton;
        if (jBRadioButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLaravelPintButton");
            jBRadioButton3 = null;
        }
        if (jBRadioButton3.isSelected()) {
            String string8 = PhpBundle.message("quality.tool.laravel.pint", new Object[0]);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        } else {
            string = "";
        }
        return string;
    }

    private final QualityToolsExternalFormatterConfiguration.ExternalFormatter getFormatter() {
        QualityToolsExternalFormatterConfiguration.ExternalFormatter externalFormatter;
        JBRadioButton jBRadioButton = this.myPhpCSBfButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSBfButton");
            jBRadioButton = null;
        }
        if (jBRadioButton.isSelected()) {
            externalFormatter = QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CBF;
        } else {
            JBRadioButton jBRadioButton2 = this.myPhpCSFixerButton;
            if (jBRadioButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSFixerButton");
                jBRadioButton2 = null;
            }
            if (jBRadioButton2.isSelected()) {
                externalFormatter = QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CS_FIXER;
            } else {
                JBRadioButton jBRadioButton3 = this.myLaravelPintButton;
                if (jBRadioButton3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myLaravelPintButton");
                    jBRadioButton3 = null;
                }
                externalFormatter = jBRadioButton3.isSelected() ? QualityToolsExternalFormatterConfiguration.ExternalFormatter.LARAVEL_PINT : QualityToolsExternalFormatterConfiguration.ExternalFormatter.NO;
            }
        }
        return externalFormatter;
    }

    public final void reset(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        QualityToolsExternalFormatterConfiguration.ExternalFormatter externalFormatter = QualityToolsExternalFormatterConfiguration.getInstance(project).getExternalFormatter();
        switch (externalFormatter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[externalFormatter.ordinal()]) {
            case 1: {
                JBRadioButton jBRadioButton = this.myPhpCSFixerButton;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSFixerButton");
                    jBRadioButton = null;
                }
                jBRadioButton.setSelected(true);
                break;
            }
            case 2: {
                JBRadioButton jBRadioButton = this.myPhpCSBfButton;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSBfButton");
                    jBRadioButton = null;
                }
                jBRadioButton.setSelected(true);
                break;
            }
            case 3: {
                JBRadioButton jBRadioButton = this.myLaravelPintButton;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myLaravelPintButton");
                    jBRadioButton = null;
                }
                jBRadioButton.setSelected(true);
                break;
            }
            default: {
                JBRadioButton jBRadioButton = this.myNoFormatterButton;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myNoFormatterButton");
                    jBRadioButton = null;
                }
                jBRadioButton.setSelected(true);
            }
        }
    }

    public final void validateConfiguration(boolean onInit, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        QualityToolConfiguration configuration = this.getConfiguration(onInit, project);
        if (configuration == null) {
            String formatter = this.getSelectedFormatterTitle(onInit);
            if (((CharSequence)formatter).length() == 0) {
                return;
            }
            Object[] objectArray = new Object[]{formatter};
            String string = PhpBundle.message("quality.tool.empty.path.phpcs", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            QualityToolConfigurableForm.updateValidationLabel((Pair<Boolean, String>)Pair.create((Object)false, (Object)message), this.getMyErrorLabel(), (JPanel)this.mainPanel);
            return;
        }
        QualityToolConfigurableForm<? extends QualityToolConfiguration> qualityToolConfigurableForm = Companion.getConfigurableForm(project, configuration);
        if (qualityToolConfigurableForm == null) {
            return;
        }
        QualityToolConfigurableForm<? extends QualityToolConfiguration> form = qualityToolConfigurableForm;
        Pair<Boolean, String> pair = form.validateConfiguration(configuration.getToolPath());
        Intrinsics.checkNotNullExpressionValue(pair, (String)"validateConfiguration(...)");
        Pair<Boolean, String> mainValidate = pair;
        QualityToolConfigurableForm.updateValidationLabel(mainValidate, this.getMyErrorLabel(), (JPanel)this.mainPanel);
        if (configuration instanceof PhpCSConfiguration) {
            Pair<Boolean, String> pair2 = form.validateConfiguration(((PhpCSConfiguration)configuration).getPhpCodeBeautifierPath());
            Intrinsics.checkNotNullExpressionValue(pair2, (String)"validateConfiguration(...)");
            Pair<Boolean, String> phpcbf = pair2;
            QualityToolConfigurableForm.updateValidationLabel((Boolean)phpcbf.first != false || StringUtil.isEmpty((String)((String)phpcbf.second)) ? mainValidate : phpcbf, this.getMyErrorLabel(), (JPanel)this.mainPanel);
        }
    }

    public final boolean isModified(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return QualityToolsExternalFormatterConfiguration.getInstance(project).getExternalFormatter() != this.getFormatter();
    }

    public final void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        QualityToolsExternalFormatterConfiguration.getInstance(project).setExternalFormatter(this.getFormatter());
    }

    private static final Unit validationPanel$lambda$1$lambda$0(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setMyErrorLabel((JLabel)$this$row.label("").visible(false).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit validationPanel$lambda$1(PhpExternalFormatterPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExternalFormatterPanel.validationPanel$lambda$1$lambda$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit infoPanel$lambda$4$lambda$3$lambda$2(PhpExternalFormatterPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AdvancedSettings.Companion.setBoolean("php.use.internal.formatter", true);
        this$0.getMyInfoLabel().setVisible(false);
        this$0.getLink().visible(false);
        return Unit.INSTANCE;
    }

    private static final Unit infoPanel$lambda$4$lambda$3(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setMyInfoLabel((JLabel)$this$row.label("").visible(false).getComponent());
        String string = PhpBundle.message("link.label.builtin.formatter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.setLink((Cell<? extends ActionLink>)$this$row.link(string, arg_0 -> PhpExternalFormatterPanel.infoPanel$lambda$4$lambda$3$lambda$2(this$0, arg_0)));
        this$0.getLink().visible(this$0.getMyInfoLabel().isVisible());
        return Unit.INSTANCE;
    }

    private static final Unit infoPanel$lambda$4(PhpExternalFormatterPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExternalFormatterPanel.infoPanel$lambda$4$lambda$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$9$lambda$5(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PhpBundle.message("external.formatter.phpcbf", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.myPhpCSBfButton = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
        JBRadioButton jBRadioButton = this$0.myPhpCSBfButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSBfButton");
            jBRadioButton = null;
        }
        this$0.configure(jBRadioButton, true);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$9$lambda$6(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PhpBundle.message("external.formatter.phpcsfixer", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.myPhpCSFixerButton = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
        JBRadioButton jBRadioButton = this$0.myPhpCSFixerButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myPhpCSFixerButton");
            jBRadioButton = null;
        }
        this$0.configure(jBRadioButton, true);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$9$lambda$7(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PhpBundle.message("quality.tool.laravel.pint", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.myLaravelPintButton = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
        JBRadioButton jBRadioButton = this$0.myLaravelPintButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLaravelPintButton");
            jBRadioButton = null;
        }
        this$0.configure(jBRadioButton, true);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$9$lambda$8(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PhpBundle.message("no.external.formatter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.myNoFormatterButton = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
        JBRadioButton jBRadioButton = this$0.myNoFormatterButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myNoFormatterButton");
            jBRadioButton = null;
        }
        this$0.configure(jBRadioButton, false);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$9(PhpExternalFormatterPanel this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PhpExternalFormatterPanel.lambda$12$lambda$9$lambda$5(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PhpExternalFormatterPanel.lambda$12$lambda$9$lambda$6(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PhpExternalFormatterPanel.lambda$12$lambda$9$lambda$7(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PhpExternalFormatterPanel.lambda$12$lambda$9$lambda$8(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$10(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.validationPanel);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$11(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.infoPanel);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$12(PhpExternalFormatterPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> PhpExternalFormatterPanel.lambda$12$lambda$9(this$0, arg_0), (int)3, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExternalFormatterPanel.lambda$12$lambda$10(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExternalFormatterPanel.lambda$12$lambda$11(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getPanel$lambda$15$lambda$14$lambda$13(PhpExternalFormatterPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.mainPanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit getPanel$lambda$15$lambda$14(PhpExternalFormatterPanel this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> PhpExternalFormatterPanel.getPanel$lambda$15$lambda$14$lambda$13(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getPanel$lambda$15(PhpExternalFormatterPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)PhpBundle.message("php.external.formatter.title", new Object[0]), (boolean)false, arg_0 -> PhpExternalFormatterPanel.getPanel$lambda$15$lambda$14(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void configure$lambda$17$lambda$16(PhpExternalFormatterPanel this$0) {
        this$0.validateConfiguration(false, this$0.project);
    }

    private static final void configure$lambda$17(JBRadioButton $this_configure, PhpExternalFormatterPanel this$0, boolean $visible, ActionEvent it) {
        if ($this_configure.isSelected()) {
            this$0.validationPanel.setVisible($visible);
            this$0.getMyErrorLabel().setText("");
            this$0.getMyErrorLabel().setVisible(false);
            ApplicationManager.getApplication().invokeLater(() -> PhpExternalFormatterPanel.configure$lambda$17$lambda$16(this$0));
        }
    }

    private static final void configure$lambda$18(JBRadioButton $this_configure, PhpExternalFormatterPanel this$0, boolean $visible, ActionEvent it) {
        if ($this_configure.isSelected() && !AdvancedSettings.Companion.getBoolean("php.use.internal.formatter")) {
            this$0.infoPanel.setVisible($visible);
            this$0.getMyInfoLabel().setText(PhpBundle.message("external.formatter.after", new Object[0]));
            this$0.getMyInfoLabel().setIcon(UIUtil.getBalloonInformationIcon());
            this$0.getLink().visible(true);
            this$0.getMyInfoLabel().setVisible(true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/tools/quality/PhpExternalFormatterPanel$Companion;", "", "<init>", "()V", "getConfigurableForm", "Lcom/jetbrains/php/tools/quality/QualityToolConfigurableForm;", "Lcom/jetbrains/php/tools/quality/QualityToolConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "getConfiguration", "validateConfiguration", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final QualityToolConfigurableForm<? extends QualityToolConfiguration> getConfigurableForm(@NotNull Project project, @Nullable QualityToolConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            QualityToolConfiguration qualityToolConfiguration = configuration;
            return qualityToolConfiguration instanceof PhpCSConfiguration ? (QualityToolConfigurableForm)new PhpCSConfigurableForm<PhpCSConfiguration>(project, (PhpCSConfiguration)configuration) : (qualityToolConfiguration instanceof PhpCSFixerConfiguration ? (QualityToolConfigurableForm)new PhpCSFixerConfigurableForm<PhpCSFixerConfiguration>(project, (PhpCSFixerConfiguration)configuration) : (qualityToolConfiguration instanceof LaravelPintConfiguration ? (QualityToolConfigurableForm)new LaravelPintConfigurableForm<LaravelPintConfiguration>(project, (LaravelPintConfiguration)configuration) : null));
        }

        @Nullable
        public final QualityToolConfiguration getConfiguration(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            QualityToolsExternalFormatterConfiguration.ExternalFormatter externalFormatter = QualityToolsExternalFormatterConfiguration.getInstance(project).getExternalFormatter();
            switch (externalFormatter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[externalFormatter.ordinal()]) {
                case 1: {
                    return PhpCSProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
                }
                case 2: {
                    return PhpCSFixerProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
                }
                case 3: {
                    return LaravelPintProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
                }
            }
            return null;
        }

        @Nullable
        public final QualityToolConfiguration validateConfiguration(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            try {
                QualityToolConfiguration qualityToolConfiguration = this.getConfiguration(project);
                if (qualityToolConfiguration == null) {
                    return null;
                }
                QualityToolConfiguration configuration = qualityToolConfiguration;
                QualityToolConfigurableForm<? extends QualityToolConfiguration> qualityToolConfigurableForm = this.getConfigurableForm(project, configuration);
                if (qualityToolConfigurableForm == null) {
                    return null;
                }
                QualityToolConfigurableForm<? extends QualityToolConfiguration> form = qualityToolConfigurableForm;
                return (Boolean)form.validateConfiguration((String)configuration.getToolPath()).first != false ? configuration : null;
            }
            catch (QualityToolValidationException e) {
                PhpExternalFormatterPanelKt.access$getLOG$p().warn(e.getMessage());
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[QualityToolsExternalFormatterConfiguration.ExternalFormatter.values().length];
                try {
                    nArray[QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CBF.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CS_FIXER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QualityToolsExternalFormatterConfiguration.ExternalFormatter.LARAVEL_PINT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QualityToolsExternalFormatterConfiguration.ExternalFormatter.values().length];
            try {
                nArray[QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CS_FIXER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QualityToolsExternalFormatterConfiguration.ExternalFormatter.PHP_CBF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QualityToolsExternalFormatterConfiguration.ExternalFormatter.LARAVEL_PINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

