/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolAnnotationAppender;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolConfigurableList;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import com.jetbrains.php.tools.quality.QualityToolsNotifier;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolAnnotator<T extends QualityToolValidationInspection<T>>
extends ExternalAnnotator<QualityToolAnnotatorInfo<T>, QualityToolMessageProcessor>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(QualityToolAnnotator.class);
    public static final String GROUP_ID = "PHP External Quality Tools";

    public final QualityToolAnnotatorInfo<T> collectAnnotatorInfo(@Nullable PsiFile file, @Nullable Editor editor, @NotNull Project project, @Nullable String profile, boolean isOnTheFly) {
        int caretPos;
        PsiElement currElement;
        String id;
        InspectionToolWrapper inspectionTool;
        Function profileWrapperFunction;
        InspectionProfileImpl inspectionProfile;
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(0);
        }
        InspectionProjectProfileManager instance = InspectionProjectProfileManager.getInstance((Project)project);
        InspectionProfileImpl inspectionProfileImpl = inspectionProfile = profile == null ? instance.getCurrentProfile() : instance.getProfile(profile);
        if (file != null && (profileWrapperFunction = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)file)) != null) {
            inspectionProfile = ((InspectionProfileWrapper)profileWrapperFunction.apply(inspectionProfile)).getInspectionProfile();
        }
        if ((inspectionTool = inspectionProfile.getInspectionTool(id = this.getQualityToolType().getInspectionId(), (PsiElement)file)) == null || isOnTheFly && !inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)id), (PsiElement)file)) {
            return null;
        }
        QualityToolValidationInspection tool = (QualityToolValidationInspection)(inspectionTool instanceof LocalInspectionToolWrapper ? (LocalInspectionTool)inspectionTool.getTool() : ((GlobalInspectionTool)inspectionTool.getTool()).getSharedLocalInspectionTool());
        if (tool == null) {
            return null;
        }
        if (file != null && !this.isFileSuitable(file, project)) {
            return null;
        }
        if (file != null && SuppressionUtil.inspectionResultSuppressed((PsiElement)file, (LocalInspectionTool)tool)) {
            return null;
        }
        QualityToolConfiguration configuration = this.getConfiguration(project, tool);
        if (configuration == null || StringUtil.isEmpty((String)configuration.getToolPath())) {
            return null;
        }
        QualityToolAnnotatorInfo<QualityToolValidationInspection> info = this.createAnnotatorInfo(file, tool, (InspectionProfile)inspectionProfile, project, configuration, isOnTheFly);
        if (isOnTheFly && editor != null && file != null && (currElement = file.findElementAt((caretPos = editor.getCaretModel().getOffset()) - 1)) != null) {
            PsiElement parent;
            for (parent = currElement; parent != null && !PhpElementTypes.ANY_GROUP_STATEMENT.contains(parent.getNode().getElementType()) && !(parent instanceof PsiFile); parent = parent.getParent()) {
            }
            if (parent == null) {
                parent = file;
            }
            info.setContextElement(parent);
        }
        return info;
    }

    @NotNull
    protected QualityToolAnnotatorInfo<T> createAnnotatorInfo(@Nullable PsiFile file, T tool, InspectionProfile inspectionProfile, Project project, QualityToolConfiguration configuration, boolean isOnTheFly) {
        return new QualityToolAnnotatorInfo<T>(file, tool, inspectionProfile, project, configuration, isOnTheFly);
    }

    protected boolean isFileSuitable(@NotNull PsiFile file, @NotNull Project inspection) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(1);
        }
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(2);
        }
        return file instanceof PhpFile && file.getViewProvider().getBaseLanguage() == PhpLanguage.INSTANCE && file.getContext() == null && !"/PHP Console".equals(file.getOriginalFile().getVirtualFile().getPath());
    }

    public String getPairedBatchInspectionShortName() {
        return this.getQualityToolType().getInspection().getShortName();
    }

    private QualityToolAnnotatorInfo<T> collectInformation(@NotNull PsiFile file, @Nullable Editor editor, boolean hasErrors, boolean isOnTheFly) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(3);
        }
        return hasErrors ? null : this.collectAnnotatorInfo(file, editor, file.getProject(), null, isOnTheFly);
    }

    @Nullable
    public QualityToolAnnotatorInfo<T> collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            QualityToolAnnotator.$$$reportNull$$$0(5);
        }
        return this.collectInformation(file, editor, hasErrors, true);
    }

    @Nullable
    public QualityToolAnnotatorInfo<T> collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(6);
        }
        return this.collectInformation(file, null, false, InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)file) != null);
    }

    @Nullable
    protected QualityToolConfiguration getConfiguration(@NotNull Project project, @NotNull LocalInspectionTool inspection) {
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(7);
        }
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(8);
        }
        try {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return this.getQualityToolType().getConfigurationManager(project).getOrCreateLocalSettings();
            }
            return this.getQualityToolType().getProjectConfiguration(project).findSelectedConfiguration(project);
        }
        catch (QualityToolValidationException qualityToolValidationException) {
            return null;
        }
    }

    @NotNull
    protected abstract QualityToolType<?> getQualityToolType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final QualityToolMessageProcessor doAnnotate(QualityToolAnnotatorInfo<T> collectedInfo) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.testTool(collectedInfo);
        }
        if (!ApplicationManager.getApplication().isActive()) {
            LOG.info("Don't run quality tools for background project");
            return null;
        }
        Project activeProject = ProjectUtil.getActiveProject();
        if (activeProject != null && !activeProject.equals(collectedInfo.getProject())) {
            LOG.info("Don't run quality tools for second project");
            return null;
        }
        if (collectedInfo.getPsiFile() != null && InjectedLanguageManager.getInstance((Project)collectedInfo.getProject()).isInjectedFragment(collectedInfo.getPsiFile())) {
            return null;
        }
        String id = collectedInfo.getInterpreterId();
        PhpSdkAdditionalData sdkData = StringUtil.isEmpty((String)id) ? null : PhpInterpretersManagerImpl.getInstance(collectedInfo.getProject()).findInterpreterDataById(id);
        PhpSdkFileTransfer transfer = PhpSdkFileTransfer.getSdkFileTransfer(sdkData);
        if (collectedInfo.isOnTheFly()) {
            ProgressManager.checkCanceled();
            try {
                if (collectedInfo.getOriginalFile() != null) {
                    this.createTempFile(collectedInfo, transfer);
                }
            }
            catch (com.intellij.execution.ExecutionException e) {
                this.showProcessErrorMessage(collectedInfo, StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("quality.tool.can.not.create.temporary.file", new Object[0])));
                QualityToolAnnotator.logWarning(collectedInfo, "Can not create temporary file", (Exception)((Object)e));
                return null;
            }
            catch (IOException e) {
                this.showProcessErrorMessage(collectedInfo, e.getMessage());
                QualityToolAnnotator.logWarning(collectedInfo, "Can not create temporary file", e);
                return null;
            }
        }
        ProgressManager.checkCanceled();
        QualityToolMessageProcessor messageProcessor = this.createMessageProcessor(collectedInfo);
        try {
            this.runTool(messageProcessor, collectedInfo, transfer);
        }
        catch (com.intellij.execution.ExecutionException e) {
            this.showProcessErrorMessage(collectedInfo, e.getMessage());
            QualityToolAnnotator.logWarning(collectedInfo, "Can not execute quality tool", (Exception)((Object)e));
        }
        finally {
            if (collectedInfo.isOnTheFly()) {
                try {
                    if (collectedInfo.getOriginalFile() != null) {
                        QualityToolAnnotator.removeTempFile(collectedInfo, transfer);
                    }
                }
                catch (com.intellij.execution.ExecutionException e) {
                    QualityToolAnnotator.logWarning(collectedInfo, "Can not remove temporary file", (Exception)((Object)e));
                }
            }
        }
        return messageProcessor.isFatalError() ? null : messageProcessor;
    }

    public static void logWarning(@NotNull QualityToolAnnotatorInfo<?> collectedInfo, @NotNull String prefix, @Nullable Exception e) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            QualityToolAnnotator.$$$reportNull$$$0(10);
        }
        String message = prefix + " for '" + (collectedInfo.isOnTheFly() ? collectedInfo.getTempFilePath() : (collectedInfo.getOriginalFile() != null ? collectedInfo.getOriginalFile().getPath() : null)) + "' on " + QualityToolAnnotator.toPresentableLocation(collectedInfo);
        LOG.warn(message + (String)(e == null ? "" : ": " + e.getMessage()));
    }

    private void createTempFile(@NotNull QualityToolAnnotatorInfo<?> collectedInfo, @NotNull PhpSdkFileTransfer transfer) throws IOException, com.intellij.execution.ExecutionException {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(11);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(12);
        }
        Project project = collectedInfo.getProject();
        String path = null;
        String basePath = project.getBasePath();
        if (collectedInfo.getOriginalFile() == null) {
            return;
        }
        String pathToOriginalFile = FileUtil.toSystemIndependentName((String)collectedInfo.getOriginalFile().getPath());
        if (StringUtil.isNotEmpty((String)basePath) && FileUtil.isAncestor((String)basePath, (String)pathToOriginalFile, (boolean)true)) {
            path = FileUtil.getRelativePath((String)basePath, (String)pathToOriginalFile, (char)'/');
        }
        if (StringUtil.isEmpty(path)) {
            path = collectedInfo.getOriginalFile().getName();
        }
        if (project.isDisposed()) {
            throw new com.intellij.execution.ExecutionException(PhpBundle.message("dialog.message.cannot.create.file.because.project.already.disposed", new Object[0]));
        }
        String file = transfer.createFile(project, path, QualityToolAnnotator.getFileContent(collectedInfo.getPsiFile()), this.getTemporaryFilesFolder(), collectedInfo.getTimeout() / 2);
        collectedInfo.setTempFile(file);
    }

    private static String getFileContent(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(13);
        }
        return (String)ReadAction.compute(() -> file.getText());
    }

    private static void removeTempFile(@NotNull QualityToolAnnotatorInfo<?> collectedInfo, @NotNull PhpSdkFileTransfer transfer) throws com.intellij.execution.ExecutionException {
        String tempFile;
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(14);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(15);
        }
        if ((tempFile = collectedInfo.getTempFile()) == null) {
            return;
        }
        transfer.delete(collectedInfo.getProject(), collectedInfo.getTimeout() / 2, false);
    }

    @NotNull
    protected String getTemporaryFilesFolder() {
        String string = this.getQualityToolType().getDisplayName() + "temp_folder";
        if (string == null) {
            QualityToolAnnotator.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static String toPresentableLocation(@NotNull QualityToolAnnotatorInfo<?> collectedInfo) {
        PhpInterpreter interpreter;
        Project project;
        String interpreterId;
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(17);
        }
        if (StringUtil.isNotEmpty((String)(interpreterId = collectedInfo.getInterpreterId())) && !(project = collectedInfo.getProject()).isDisposed() && (interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId)) != null) {
            return interpreter.getPhpSdkAdditionalData().toPresentablePath();
        }
        return "local";
    }

    protected void runTool(@NotNull QualityToolMessageProcessor messageProcessor, @NotNull QualityToolAnnotatorInfo<T> annotatorInfo, @NotNull PhpSdkFileTransfer transfer) throws com.intellij.execution.ExecutionException {
        if (messageProcessor == null) {
            QualityToolAnnotator.$$$reportNull$$$0(18);
        }
        if (annotatorInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(19);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(20);
        }
        T inspection = annotatorInfo.getInspection();
        Project project = annotatorInfo.getProject();
        String workingDirectory = this.getWorkingDir(project, inspection);
        if (this.runOnTempFiles()) {
            List<String> options = this.getOptions(annotatorInfo.isOnTheFly() ? annotatorInfo.getTempFilePath() : (annotatorInfo.getOriginalFile() != null ? annotatorInfo.getOriginalFile().getPath() : null), inspection, annotatorInfo.getProfile(), project, annotatorInfo.isOnTheFly());
            if (options == null) {
                return;
            }
            this.checkOptions(options, workingDirectory, project);
            if (annotatorInfo.getOriginalFile() != null && annotatorInfo.isOnTheFly()) {
                messageProcessor.addSubstitution(annotatorInfo.getTempFileName(), annotatorInfo.getOriginalFileName());
            }
            workingDirectory = QualityToolAnnotator.updateIfRemote(workingDirectory, project, messageProcessor.getQualityToolType());
            QualityToolProcessCreator.runToolProcess(annotatorInfo, this.getQualityToolType().getQualityToolBlackList(project), messageProcessor, workingDirectory, transfer, this.getEnvironment(), options);
            QualityToolMessage message = messageProcessor.getInternalErrorMessage();
            if (message != null && annotatorInfo.isOnTheFly()) {
                String messageText = message.getMessageText();
                boolean showMessage = this.showMessage(messageText);
                if (annotatorInfo.isOnTheFly() && showMessage) {
                    this.showProcessErrorMessage(annotatorInfo, messageProcessor.getType().equals((Object)QualityToolMessageProcessor.ErrorMessageType.TIMEOUT) ? this.getAdditionalTimeoutActions() : Collections.emptyList(), messageText);
                    QualityToolAnnotator.logWarning(annotatorInfo, messageText, null);
                }
                if (showMessage) {
                    messageProcessor.setFatalError();
                }
            }
            return;
        }
        VirtualFile originalFile = annotatorInfo.getOriginalFile();
        if (originalFile == null) {
            return;
        }
        QualityToolBlackList blackList = this.getQualityToolType().getQualityToolBlackList(project);
        if (blackList.containsFile(originalFile)) {
            return;
        }
        List<String> options = this.getOptions(this.runOnTempFiles() ? annotatorInfo.getTempFilePath() : (annotatorInfo.getOriginalFile() != null ? annotatorInfo.getOriginalFile().getPath() : null), inspection, annotatorInfo.getProfile(), project, annotatorInfo.isOnTheFly());
        if (options == null) {
            return;
        }
        int timeout = annotatorInfo.isOnTheFly() ? annotatorInfo.getTimeout() : 900000;
        String path = annotatorInfo.getToolPath();
        String interpreterId = annotatorInfo.getInterpreterId();
        try {
            ProcessHandler handler = QualityToolProcessCreator.QUALITY_TOOL_EXECUTOR.submit(() -> {
                ProcessHandler handler1 = QualityToolProcessCreator.createProcessHandler(project, path, interpreterId, messageProcessor, this.getWorkingDir(project, inspection), transfer, this.getEnvironment(), ArrayUtilRt.toStringArray((Collection)options));
                OutputStream processInput = handler1.getProcessInput();
                assert (processInput != null);
                String text = (String)ReadAction.compute(() -> annotatorInfo.getPsiFile().getText());
                processInput.write(text.getBytes(annotatorInfo.getPsiFile().getVirtualFile().getCharset()));
                processInput.flush();
                processInput.close();
                handler1.startNotify();
                handler1.waitFor(annotatorInfo.isOnTheFly() ? (long)annotatorInfo.getTimeout() : 900000L);
                return handler1;
            }).get(timeout, TimeUnit.MILLISECONDS);
            if (!handler.isProcessTerminated()) {
                handler.destroyProcess();
                messageProcessor.addInternalMessage(1, QualityToolProcessCreator.getHangupMessage(path, timeout, ArrayUtilRt.toStringArray(options)), QualityToolMessageProcessor.ErrorMessageType.TIMEOUT);
            }
        }
        catch (TimeoutException e) {
            throw new com.intellij.execution.ExecutionException(StringUtil.isEmpty((String)e.getMessage()) ? PhpBundle.message("no.response.from.0.after.1.ms", path, timeout) : e.getMessage());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        if (messageProcessor.getInternalErrorMessage() != null && annotatorInfo.isOnTheFly()) {
            String message = messageProcessor.getInternalErrorMessage().getMessageText();
            this.showProcessErrorMessage(annotatorInfo, messageProcessor.getType().equals((Object)QualityToolMessageProcessor.ErrorMessageType.TIMEOUT) ? this.getAdditionalTimeoutActions() : Collections.emptyList(), message);
            QualityToolAnnotator.logWarning(annotatorInfo, message, null);
            messageProcessor.setFatalError();
        }
    }

    protected boolean runOnTempFiles() {
        return true;
    }

    protected boolean showMessage(@NotNull String message) {
        if (message == null) {
            QualityToolAnnotator.$$$reportNull$$$0(21);
        }
        return true;
    }

    protected Map<String, String> getEnvironment() {
        return null;
    }

    protected void checkOptions(@NotNull List<String> options, @NotNull String workingDir, @NotNull Project project) {
        if (options == null) {
            QualityToolAnnotator.$$$reportNull$$$0(22);
        }
        if (workingDir == null) {
            QualityToolAnnotator.$$$reportNull$$$0(23);
        }
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(24);
        }
    }

    @Nullable
    protected abstract List<String> getOptions(@Nullable String var1, @NotNull T var2, @Nullable InspectionProfile var3, @NotNull Project var4);

    @Nullable
    protected List<String> getOptions(@Nullable String filePath, @NotNull T inspection, @Nullable InspectionProfile profile, @NotNull Project project, boolean isOnTheFly) {
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(25);
        }
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(26);
        }
        return this.getOptions(filePath, inspection, profile, project);
    }

    protected String getWorkingDir(@NotNull Project project, @NotNull T inspection) {
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(27);
        }
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(28);
        }
        return project.getBasePath();
    }

    protected abstract QualityToolMessageProcessor createMessageProcessor(@NotNull QualityToolAnnotatorInfo<T> var1);

    @Nullable
    private QualityToolMessageProcessor testTool(@NotNull QualityToolAnnotatorInfo<T> annotatorInfo) {
        if (annotatorInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(29);
        }
        QualityToolMessageProcessor messageProcessor = this.createMessageProcessor(annotatorInfo);
        try {
            if (annotatorInfo.getOriginalFile() == null) {
                return null;
            }
            File testFile = new File(FileUtilRt.getNameWithoutExtension((String)annotatorInfo.getOriginalFile().getPath()) + ".txt");
            if (!testFile.exists()) {
                return null;
            }
            try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(testFile), StandardCharsets.UTF_8));){
                input.lines().map(line -> line + "\n").forEach(messageProcessor::parseLine);
                messageProcessor.done();
            }
            return messageProcessor.isFatalError() ? null : messageProcessor;
        }
        catch (Exception e) {
            LOG.warn("Can not run quality tool: " + e.getMessage());
            return null;
        }
    }

    public void showProcessErrorMessage(@NotNull QualityToolAnnotatorInfo<?> collectedInfo, @NotNull @NlsSafe String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(30);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(31);
        }
        if (!collectedInfo.isOnTheFly() || collectedInfo.getProject().isDisposed()) {
            LOG.warn(messageText);
            return;
        }
        Object inspection = collectedInfo.getInspection();
        @NlsSafe String text = MessageFormat.format("{0}{1}", messageText, StringUtil.endsWith((CharSequence)messageText, (CharSequence)"</a>") ? " " + PhpBundle.message("or.disable.inspection", new Object[0]) + " " : "<br>");
        final QualityToolType<?> type = this.getQualityToolType();
        AnAction openSettingsAction = new AnAction(PhpBundle.message("open.tool.settings", type.getDisplayName())){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null && !project.isDisposed()) {
                    QualityToolAnnotator.editQualityToolConfig(project, type);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolAnnotator$1", "actionPerformed"));
            }
        };
        QualityToolAnnotator.showProcessErrorMessage(inspection, text, Collections.singletonList(openSettingsAction));
    }

    public void showProcessErrorMessage(@NotNull QualityToolAnnotatorInfo<?> collectedInfo, @NotNull List<AnAction> timeoutActions, @NlsSafe @NotNull String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(32);
        }
        if (timeoutActions == null) {
            QualityToolAnnotator.$$$reportNull$$$0(33);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(34);
        }
        Object inspection = collectedInfo.getInspection();
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(messageText);
        builder2.append((HtmlChunk)HtmlChunk.br());
        QualityToolAnnotator.showProcessErrorMessage(inspection, builder2.toString(), ContainerUtil.concat(timeoutActions, List.of(new AnAction(PhpBundle.message("open.tool.settings", ((QualityToolValidationInspection)((Object)inspection)).getToolName())){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                Project project = e.getProject();
                QualityToolType<?> type = QualityToolAnnotator.this.getQualityToolType();
                if (project != null && !project.isDisposed()) {
                    QualityToolAnnotator.editQualityToolConfig(project, type);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolAnnotator$2", "actionPerformed"));
            }
        }, NotificationAction.createSimpleExpiring((String)PhpBundle.message("turn.off.inspection.tool", ((QualityToolValidationInspection)((Object)inspection)).getToolName()), () -> {
            Project project = collectedInfo.getProject();
            InspectionProfileManager.getInstance((Project)project).getCurrentProfile().setToolEnabled(this.getQualityToolType().getInspectionShortName(project), false);
        }))));
    }

    private static <C extends QualityToolConfiguration> void editQualityToolConfig(Project project, final QualityToolType<C> type) {
        PhpUiUtil.editConfigurable(project, (Configurable)new QualityToolConfigurableList<C>(project, type, null){

            @Override
            protected QualityToolType<C> getQualityToolType() {
                return type;
            }
        });
    }

    public void showProcessErrorMessage(final @NotNull QualityToolAnnotatorInfo<?> collectedInfo, final @NotNull QualityToolBlackList blackList, @NlsSafe @NotNull String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(35);
        }
        if (blackList == null) {
            QualityToolAnnotator.$$$reportNull$$$0(36);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(37);
        }
        Object inspection = collectedInfo.getInspection();
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(messageText);
        builder2.append((HtmlChunk)HtmlChunk.br());
        if (collectedInfo.getOriginalFile() == null) {
            return;
        }
        QualityToolAnnotator.showProcessErrorMessage(inspection, builder2.toString(), ContainerUtil.concat((List)ContainerUtil.emptyList(), Collections.singletonList(new AnAction(PhpBundle.message("exclude.0.from.1.analysis.a", collectedInfo.getOriginalFile().getName(), ((QualityToolValidationInspection)((Object)inspection)).getToolName()), (QualityToolValidationInspection)((Object)inspection)){
            final /* synthetic */ QualityToolValidationInspection val$inspection;
            {
                this.val$inspection = qualityToolValidationInspection;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                VirtualFile originalFile;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (blackList.addFile(originalFile = collectedInfo.getOriginalFile())) {
                    Notifications.Bus.notify((Notification)new Notification(QualityToolAnnotator.GROUP_ID, this.val$inspection.getToolName(), PhpBundle.message("quality.tools.0.added.to.ignored.files.list", originalFile.getName()), NotificationType.INFORMATION));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolAnnotator$4", "actionPerformed"));
            }
        })));
    }

    protected List<AnAction> getAdditionalTimeoutActions() {
        return Collections.emptyList();
    }

    public static void showProcessErrorMessage(@NotNull QualityToolValidationInspection<?> inspection, @NotNull @NlsContexts.NotificationContent String messageText, @NotNull List<AnAction> actions) {
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(38);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(39);
        }
        if (actions == null) {
            QualityToolAnnotator.$$$reportNull$$$0(40);
        }
        if (QualityToolsNotifier.getInstance().getStatus().equals((Object)QualityToolsNotifier.Status.MUTED)) {
            return;
        }
        actions = new ArrayList<AnAction>(actions);
        actions.add((AnAction)NotificationAction.createSimpleExpiring((String)PhpBundle.message("mute.until.restart", new Object[0]), () -> QualityToolsNotifier.getInstance().setStatus(QualityToolsNotifier.Status.MUTED)));
        new Notification(GROUP_ID, inspection.getToolName(), messageText, NotificationType.ERROR).addActions(actions).notify(null);
    }

    private static PhpPathMapper getPathMapper(Project project, QualityToolType<?> type) {
        try {
            Object configuration = type.getProjectConfiguration(project).findSelectedConfiguration(project, false);
            if (configuration != null) {
                String interpreterId = ((QualityToolConfiguration)configuration).getInterpreterId();
                PhpInterpreter id = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
                PhpRemoteInterpreterManager instance = PhpRemoteInterpreterManager.getInstance();
                return instance != null && id != null && id.isRemote() ? PhpPathMapper.create(instance.createPathMappings(project, id.getPhpSdkAdditionalData()).getPathMappings()) : PhpPathMapper.createDefaultMapper();
            }
        }
        catch (QualityToolValidationException qualityToolValidationException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static String updateToLocalIfRemote(@NotNull String path, Project project, QualityToolType<?> type) {
        PhpPathMapper pathMapper;
        if (path == null) {
            QualityToolAnnotator.$$$reportNull$$$0(41);
        }
        String localPath = (pathMapper = QualityToolAnnotator.getPathMapper(project, type)) != null ? pathMapper.getLocalPath(path) : path;
        String string = localPath != null ? localPath : path;
        if (string == null) {
            QualityToolAnnotator.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public static String updateIfRemoteMappingExists(@NotNull String path, Project project, QualityToolType<?> type) {
        String remotePath;
        if (path == null) {
            QualityToolAnnotator.$$$reportNull$$$0(43);
        }
        String string = (remotePath = QualityToolAnnotator.updateIfRemote(path, project, type)) != null ? remotePath : path;
        if (string == null) {
            QualityToolAnnotator.$$$reportNull$$$0(44);
        }
        return string;
    }

    @Nullable
    public static String updateIfRemote(@NotNull String path, Project project, QualityToolType<?> type) {
        PhpPathMapper pathMapper;
        if (path == null) {
            QualityToolAnnotator.$$$reportNull$$$0(45);
        }
        return (pathMapper = QualityToolAnnotator.getPathMapper(project, type)) != null ? pathMapper.getRemoteFilePath(path) : path;
    }

    public void apply(@NotNull PsiFile file, QualityToolMessageProcessor annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(46);
        }
        if (holder == null) {
            QualityToolAnnotator.$$$reportNull$$$0(47);
        }
        new OnTheFlyAnnotationAppender(file, new OnTheFlyAnnotationTarget(file.getProject(), holder)).apply(annotationResult);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 42, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 13: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 25: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transfer";
                break;
            }
            case 16: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolAnnotator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatorInfo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 31: 
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageText";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeoutActions";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blackList";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryFilesFolder";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "updateToLocalIfRemote";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIfRemoteMappingExists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotatorInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileSuitable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logWarning";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeTempFile";
                break;
            }
            case 16: 
            case 42: 
            case 44: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableLocation";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkOptions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "testTool";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "showProcessErrorMessage";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "updateToLocalIfRemote";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "updateIfRemoteMappingExists";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateIfRemote";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 42, 44 -> new IllegalStateException(string);
        };
    }

    private static class OnTheFlyAnnotationAppender
    extends QualityToolAnnotationAppender {
        OnTheFlyAnnotationAppender(PsiFile file, QualityToolAnnotationAppender.AnnotationTarget holder) {
            super(file, holder);
        }
    }

    protected static class OnTheFlyAnnotationTarget
    implements QualityToolAnnotationAppender.AnnotationTarget {
        private final AnnotationHolder myHolder;
        private final Project myProject;

        public OnTheFlyAnnotationTarget(Project project, AnnotationHolder holder) {
            this.myHolder = holder;
            this.myProject = project;
        }

        @Override
        public void createAnnotation(HighlightDisplayLevel severity, TextRange range, @InspectionMessage String messageText, IntentionAction ... actions) {
            AnnotationBuilder builder2 = this.myHolder.newAnnotation(severity.getSeverity(), messageText).needsUpdateOnTyping(false).range(range);
            TextAttributes key = SeverityRegistrar.getSeverityRegistrar((Project)this.myProject).getTextAttributesBySeverity(severity.getSeverity());
            if (key != null) {
                builder2 = builder2.enforcedTextAttributes(key);
            }
            for (IntentionAction fix : actions) {
                builder2 = builder2.withFix(fix);
            }
            if (range.isEmpty()) {
                builder2 = builder2.afterEndOfLine();
            }
            builder2.create();
        }

        @Override
        public void creteInternalErrorAnnotation(@NotNull PsiFile file, @NotNull TextRange textRange, @NotNull @InspectionMessage String messageText, IntentionAction ... quickFix) {
            if (file == null) {
                OnTheFlyAnnotationTarget.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                OnTheFlyAnnotationTarget.$$$reportNull$$$0(1);
            }
            if (messageText == null) {
                OnTheFlyAnnotationTarget.$$$reportNull$$$0(2);
            }
            AnnotationBuilder builder2 = this.myHolder.newAnnotation(HighlightSeverity.WARNING, messageText).fileLevel().range(textRange).needsUpdateOnTyping(false);
            Arrays.stream(quickFix).forEach(q -> builder2.withFix(q));
            builder2.create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotator$OnTheFlyAnnotationTarget";
            objectArray[2] = "creteInternalErrorAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ContextValidator
    extends PsiRecursiveElementVisitor {
        private boolean myIsValid = true;

        public boolean isValid(PsiElement rootElement) {
            if (rootElement == null) {
                return true;
            }
            ApplicationManager.getApplication().runReadAction(() -> this.visitElement(rootElement));
            return this.myIsValid;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ContextValidator.$$$reportNull$$$0(0);
            }
            if (!this.myIsValid) {
                return;
            }
            if (element instanceof PsiErrorElement) {
                this.myIsValid = false;
                return;
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/tools/quality/QualityToolAnnotator$ContextValidator", "visitElement"));
        }
    }
}

