/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolAnnotatorInfo<T extends QualityToolValidationInspection<T>> {
    private final VirtualFile myOriginalFile;
    private String myTempFile;
    private final PsiFile myPsiFile;
    @NotNull
    private final T myInspection;
    private final InspectionProfile myProfile;
    @NotNull
    private final Project myProject;
    private final boolean myIsOnTheFly;
    private PsiElement myContextElement;
    private final String myInterpreterId;
    private final String myToolPath;
    private final int myMaxMessagesPerFile;
    private final int myTimeout;

    public QualityToolAnnotatorInfo(@Nullable PsiFile psiFile, @NotNull T inspection, @NotNull InspectionProfile profile, @NotNull Project project, @Nullable String interpreterId, @NotNull String toolPath, int maxMessagesPerFile, int timeout, boolean isOnTheFly) {
        if (inspection == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(1);
        }
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(2);
        }
        if (toolPath == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(3);
        }
        this.myInspection = inspection;
        this.myProfile = profile;
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myOriginalFile = psiFile != null ? psiFile.getVirtualFile() : null;
        this.myInterpreterId = interpreterId;
        this.myToolPath = toolPath;
        this.myMaxMessagesPerFile = maxMessagesPerFile;
        this.myTimeout = timeout;
        this.myIsOnTheFly = isOnTheFly;
    }

    public QualityToolAnnotatorInfo(@Nullable PsiFile psiFile, @NotNull T inspection, @NotNull InspectionProfile profile, @NotNull Project project, @NotNull QualityToolConfiguration configuration, boolean isOnTheFly) {
        if (inspection == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(4);
        }
        if (profile == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(5);
        }
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(7);
        }
        this(psiFile, inspection, profile, project, configuration.getInterpreterId(), configuration.getToolPath(), configuration.getMaxMessagesPerFile(), configuration.getTimeout(), isOnTheFly);
    }

    public String getTempFile() {
        return this.myTempFile;
    }

    public void setTempFile(@NotNull String tempFile) {
        if (tempFile == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(8);
        }
        this.myTempFile = tempFile;
    }

    public String getTempFilePath() {
        return PathUtil.toSystemIndependentName((String)this.myTempFile);
    }

    public String getTempFileName() {
        return QualityToolAnnotatorInfo.truncateExtension(PathUtil.getFileName((String)this.myTempFile));
    }

    @Nullable
    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    @NotNull
    public T getInspection() {
        T t = this.myInspection;
        if (t == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Nullable
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    @NotNull
    public String getToolPath() {
        String string = this.myToolPath;
        if (string == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public String getOriginalFileName() {
        return QualityToolAnnotatorInfo.truncateExtension(this.myOriginalFile.getName());
    }

    public InspectionProfile getProfile() {
        return this.myProfile;
    }

    private static String truncateExtension(@NotNull String fileName) {
        int extPos;
        if (fileName == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(12);
        }
        return (extPos = fileName.lastIndexOf(".")) >= 0 ? fileName.substring(0, extPos) : fileName;
    }

    public boolean isOnTheFly() {
        return this.myIsOnTheFly;
    }

    public PsiElement getContextElement() {
        return this.myContextElement;
    }

    public void setContextElement(PsiElement contextElement) {
        this.myContextElement = contextElement;
    }

    public int getMaxMessagesPerFile() {
        return this.myMaxMessagesPerFile;
    }

    public int getTimeout() {
        return this.myTimeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolAnnotatorInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotatorInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTempFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "truncateExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

