/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolExecutionException;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolMessageProcessor {
    private ErrorMessageType myType;
    private final List<QualityToolMessage> myMessages = ContainerUtil.createConcurrentList(new ArrayList());
    private final int myMaxMessages;
    protected PsiFile myFile;
    private QualityToolMessage internalErrorMessage;
    private final Map<String, String> mySubstitutions = new HashMap<String, String>();
    private boolean myFatalError = false;
    private HighlightDisplayLevel myDefaultHighlightDisplayLevel = HighlightDisplayLevel.WARNING;
    private final IntentionAction myConfigureFix = new ConfigureFix();

    protected QualityToolMessageProcessor(QualityToolAnnotatorInfo<?> info) {
        this(info, Registry.get((String)"php.quality.tools.messages.limit").isChangedFromDefault() ? Registry.intValue((String)"php.quality.tools.messages.limit", (int)Integer.MAX_VALUE) : Integer.MAX_VALUE);
    }

    protected QualityToolMessageProcessor(int maxMessages) {
        this.myMaxMessages = maxMessages;
    }

    protected QualityToolMessageProcessor(QualityToolAnnotatorInfo<?> info, int maxMessages) {
        this.myFile = info.getPsiFile();
        this.myMaxMessages = maxMessages;
        if (!info.getProject().isDisposed()) {
            this.myDefaultHighlightDisplayLevel = info.getProfile().getErrorLevel(HighlightDisplayKey.find((String)this.getQualityToolType().getInspectionId()), (PsiElement)info.getPsiFile());
        }
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public ErrorMessageType getType() {
        return this.myType;
    }

    public boolean processStdErrMessages() {
        return true;
    }

    public boolean processStdErrMessages(StringBuffer error) {
        return true;
    }

    public abstract void parseLine(String var1);

    public abstract void done() throws QualityToolExecutionException;

    @Nullable
    @InspectionMessage
    protected String getMessagePrefix() {
        return null;
    }

    public final void addSubstitution(String sample, String replacement) {
        this.mySubstitutions.put(sample, replacement);
    }

    @NotNull
    public final List<QualityToolMessage> getMessages() {
        List<QualityToolMessage> list = this.myMessages;
        if (list == null) {
            QualityToolMessageProcessor.$$$reportNull$$$0(0);
        }
        return list;
    }

    public int getMessageCount() {
        return this.myMessages.size();
    }

    public final void addInternalMessage(int line, @InspectionMessage String messageText) {
        this.addInternalMessage(line, messageText, ErrorMessageType.GENERAL);
    }

    public final void addInternalMessage(int line, @InspectionMessage String messageText, ErrorMessageType type) {
        this.addMessage(new QualityToolMessage(this, line, QualityToolMessage.Severity.INTERNAL_ERROR, messageText, new IntentionAction[0]));
        this.myType = type;
    }

    protected boolean show(@NotNull String message) {
        if (message == null) {
            QualityToolMessageProcessor.$$$reportNull$$$0(1);
        }
        return true;
    }

    protected void addMessage(QualityToolMessage message) {
        if (message.isInternalError() && this.show(message.getMessageText())) {
            this.internalErrorMessage = message;
        }
        if (this.myMessages.size() < this.myMaxMessages) {
            for (String sample : this.mySubstitutions.keySet()) {
                if (!message.getMessageText().contains(sample)) continue;
                message.substitute(sample, this.mySubstitutions.get(sample));
            }
            HighlightDisplayLevel displayLevel = this.severityToDisplayLevel(message.getSeverity());
            message.setDisplayLevel(displayLevel != null ? displayLevel : this.myDefaultHighlightDisplayLevel);
            this.myMessages.add(message);
        } else if (this.myMessages.size() == this.myMaxMessages) {
            QualityToolMessage lastMessage = this.myMessages.get(this.myMessages.size() - 1);
            QualityToolMessage errorMessage = new QualityToolMessage(this, lastMessage.getTextRange(), QualityToolMessage.Severity.INTERNAL_ERROR, PhpBundle.message("inspection.message.too.many.messages.per.file.only.first.errors.warnings.are.shown", this.myMaxMessages), this.myConfigureFix);
            this.myMessages.add(errorMessage);
        }
    }

    @Nullable
    protected HighlightDisplayLevel severityToDisplayLevel(@NotNull QualityToolMessage.Severity severity) {
        if (severity == null) {
            QualityToolMessageProcessor.$$$reportNull$$$0(2);
        }
        return null;
    }

    @IntentionFamilyName
    protected abstract QualityToolType<?> getQualityToolType();

    public QualityToolMessage getInternalErrorMessage() {
        return this.internalErrorMessage;
    }

    public void setFatalError() {
        this.myFatalError = true;
    }

    public boolean isFatalError() {
        return this.myFatalError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolMessageProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolMessageProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "severityToDisplayLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private class ConfigureFix
    implements IntentionAction {
        private ConfigureFix() {
        }

        @NotNull
        public String getText() {
            String string = PhpBundle.message("configure", new Object[0]);
            if (string == null) {
                ConfigureFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QualityToolMessageProcessor.this.getQualityToolType().getDisplayName();
            if (string == null) {
                ConfigureFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                ConfigureFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                ConfigureFix.$$$reportNull$$$0(3);
            }
            Configurable toolConfigurable = QualityToolMessageProcessor.this.getQualityToolType().getToolConfigurable(project);
            ShowSettingsUtil.getInstance().editConfigurable(project, toolConfigurable);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                ConfigureFix.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                ConfigureFix.$$$reportNull$$$0(5);
            }
            if (file == null) {
                ConfigureFix.$$$reportNull$$$0(6);
            }
            Configurable toolConfigurable = QualityToolMessageProcessor.this.getQualityToolType().getToolConfigurable(project);
            return new IntentionPreviewInfo.Html(PhpBundle.message("show.0.settings.window", toolConfigurable.getDisplayName()));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolMessageProcessor$ConfigureFix";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolMessageProcessor$ConfigureFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    public static enum ErrorMessageType {
        TIMEOUT,
        GENERAL;

    }
}

