/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolConfigurableList;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolExternalFormatter;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolsExternalFormatterConfiguration;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolReformatFile {
    protected static final Logger LOG = Logger.getInstance(QualityToolReformatFile.class);

    public void invoke(@NotNull Project project, @NotNull PsiFile file) throws IncorrectOperationException {
        ProcessHandler handler;
        if (project == null) {
            QualityToolReformatFile.$$$reportNull$$$0(0);
        }
        if (file == null) {
            QualityToolReformatFile.$$$reportNull$$$0(1);
        }
        if ((handler = this.getProcessHandler(project, file)) != null) {
            handler.addProcessListener((ProcessListener)new MyProcessAdapter(file.getVirtualFile(), handler));
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            Document document = documentManager.getDocument(file.getVirtualFile());
            if (document != null) {
                WriteAction.runAndWait(() -> documentManager.saveDocument(document));
            }
            handler.startNotify();
        } else {
            this.notifyAboutProcessCreationProblem(project);
        }
    }

    @Nullable
    public ProcessHandler getProcessHandler(@NotNull Project project, @NotNull PsiFile file) throws IncorrectOperationException {
        VirtualFile virtualFile;
        if (project == null) {
            QualityToolReformatFile.$$$reportNull$$$0(2);
        }
        if (file == null) {
            QualityToolReformatFile.$$$reportNull$$$0(3);
        }
        return (virtualFile = file.getVirtualFile()) != null ? this.getProcessHandler(project, virtualFile) : null;
    }

    protected String getToolPath(QualityToolConfiguration settings) {
        return settings.getToolPath();
    }

    public abstract QualityToolType getQualityToolType();

    private static ProcessHandler getLocalProcessHandler(String workDirectory, List<String> options, String toolPath) {
        GeneralCommandLine cmd = new GeneralCommandLine();
        cmd.setExePath(toolPath);
        cmd.addParameters(options);
        cmd.setWorkDirectory(workDirectory);
        QualityToolProcessCreator.logProcessStart(cmd.getExePath(), workDirectory, true, ArrayUtil.toStringArray(options));
        try {
            return new OSProcessHandler(cmd);
        }
        catch (ExecutionException e) {
            LOG.warn("Can not execute " + toolPath + " with parameters: " + cmd.getPreparedCommandLine(), (Throwable)e);
            return null;
        }
    }

    private ProcessHandler getRemoteProcessHandler(@NotNull Project project, @Nullable String interpreterId, String workDirectory, List<String> options, String toolPath) {
        String executable;
        PhpRemoteInterpreterManager manager;
        if (project == null) {
            QualityToolReformatFile.$$$reportNull$$$0(4);
        }
        if ((manager = PhpRemoteInterpreterManager.getInstance()) == null) {
            return null;
        }
        PhpSdkAdditionalData additionalData = PhpInterpretersManagerImpl.getInstance(project).findInterpreterDataById(interpreterId);
        if (additionalData == null) {
            return null;
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
        if (interpreter == null) {
            return null;
        }
        if (interpreter.isRemote()) {
            PhpCommandSettings command;
            try {
                String executable2 = interpreter.getPathToPhpExecutable();
                if (executable2 != null && toolPath.contains("\\")) {
                    command = PhpCommandSettingsBuilder.create(executable2, manager.createPathMapper(project, additionalData), additionalData);
                    command.setScript(toolPath);
                    QualityToolProcessCreator.disableXDebugOptions(project, interpreter, command);
                } else {
                    command = PhpCommandSettingsBuilder.create(toolPath, manager.createPathMapper(project, additionalData), additionalData);
                }
            }
            catch (ExecutionException e) {
                LOG.warn("Couldn't create PHP command with remote interpreter");
                return null;
            }
            this.fillArguments(options, command, workDirectory);
            PhpSdkFileTransfer.getSdkFileTransfer(additionalData).updateCommand(command);
            QualityToolProcessCreator.logProcessStart(toolPath, workDirectory, ArrayUtil.toStringArray(options));
            GeneralCommandLine commandLine = command.createGeneralCommandLine();
            try {
                return manager.getRemoteProcessHandler(project, additionalData, commandLine, true, new PathMappingSettings.PathMapping[0]);
            }
            catch (Exception e) {
                LOG.warn("Can not execute PHP CS Fixer with parameters: " + commandLine.getPreparedCommandLine(), (Throwable)e);
                return null;
            }
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        if (StringUtil.isNotEmpty((String)workDirectory)) {
            cl.setWorkDirectory(workDirectory);
        }
        if ((executable = interpreter.getPathToPhpExecutable()) != null) {
            cl.setExePath(executable);
            cl.addParameter(toolPath);
            cl.addParameters(options);
        }
        QualityToolProcessCreator.logProcessStart(toolPath, workDirectory, (String[])options.toArray(String[]::new));
        try {
            return new OSProcessHandler(cl);
        }
        catch (ExecutionException e) {
            LOG.warn("Can not execute " + toolPath + " with parameters: " + cl.getPreparedCommandLine(), (Throwable)e);
            return null;
        }
    }

    protected abstract void fillArguments(List<String> var1, PhpCommandSettings var2, String var3);

    public boolean isAvailable(@NotNull Project project) {
        QualityToolConfiguration configuration;
        if (project == null) {
            QualityToolReformatFile.$$$reportNull$$$0(5);
        }
        return (configuration = this.getCurrentConfiguration(project)) != null && StringUtil.isNotEmpty((String)this.getToolPath(configuration));
    }

    protected abstract QualityToolConfiguration getCurrentConfiguration(@NotNull Project var1);

    protected abstract String getName();

    @Nullable
    protected String getWorkingDir(@NotNull Project project) {
        if (project == null) {
            QualityToolReformatFile.$$$reportNull$$$0(6);
        }
        return project.getBasePath();
    }

    @Nullable
    public ProcessHandler getProcessHandler(@NotNull Project project, VirtualFile ... files) throws IncorrectOperationException {
        if (project == null) {
            QualityToolReformatFile.$$$reportNull$$$0(7);
        }
        if (!TrustedProjects.isTrusted((Project)project)) {
            LOG.info("Reformat action with Quality Tools in untrusted project is prohibited");
            return null;
        }
        QualityToolConfiguration settings = this.getCurrentConfiguration(project);
        if (settings == null) {
            return null;
        }
        String workDirectory = this.getWorkingDir(project);
        List<String> options = this.getOptions(project, files);
        String toolPath = this.getToolPath(settings);
        if (settings.isLocal()) {
            return QualityToolReformatFile.getLocalProcessHandler(this.getWorkingDir(project), options, toolPath);
        }
        return this.getRemoteProcessHandler(project, settings.getInterpreterId(), workDirectory, options, toolPath);
    }

    @NotNull
    public abstract List<String> getOptions(@NotNull Project var1, VirtualFile ... var2);

    protected boolean reportNonZeroCodes() {
        return true;
    }

    public void notifyAboutProcessCreationProblem(Project project) {
        Notification notification = ((NotificationGroup)QualityToolExternalFormatter.NOTIFICATION_GROUP.get()).createNotification(PhpBundle.message("php.external.formatter.title", new Object[0]), PhpBundle.message("external.formatter.couldnt.run.tool", this.getName()), NotificationType.INFORMATION);
        notification.setSuggestionType(true);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PhpBundle.message("open.tool.settings", this.getName()), () -> {
            notification.expire();
            final QualityToolType type = this.getQualityToolType();
            if (!project.isDisposed()) {
                PhpUiUtil.editConfigurable(project, (Configurable)new QualityToolConfigurableList(project, type, null){

                    protected QualityToolType getQualityToolType() {
                        return type;
                    }
                });
            }
        }));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PhpBundle.message("turn.off.external.formatter", this.getName()), () -> QualityToolsExternalFormatterConfiguration.getInstance(project).setExternalFormatter(QualityToolsExternalFormatterConfiguration.ExternalFormatter.NO)));
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolReformatFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRemoteProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkingDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyProcessAdapter
    extends ProcessAdapter {
        @NotNull
        protected final VirtualFile myVirtualFile;
        protected final ProcessHandler myProcessHandler;

        public MyProcessAdapter(@NotNull VirtualFile virtualFile, ProcessHandler processHandler) {
            if (virtualFile == null) {
                MyProcessAdapter.$$$reportNull$$$0(0);
            }
            this.myVirtualFile = virtualFile;
            this.myProcessHandler = processHandler;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyProcessAdapter.$$$reportNull$$$0(1);
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myVirtualFile});
            this.myProcessHandler.removeProcessListener((ProcessListener)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolReformatFile$MyProcessAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

