/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolXmlMessageProcessor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolValidationGlobalInspection
extends GlobalSimpleInspectionTool {
    protected final Key<QualityToolMessageProcessor> ANNOTATOR_INFO = Key.create((String)"ANNOTATOR_INFO");

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(0);
        }
        if (globalContext == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(1);
        }
        if (problemDescriptionsProcessor == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(2);
        }
        globalContext.getProject().putUserData(this.getKey(), null);
        this.checkCmdOptions(globalContext.getProject());
    }

    protected void checkCmdOptions(@NotNull Project project) {
        if (project == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(3);
        }
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @Nullable ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        List data;
        if (file == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(6);
        }
        if (globalContext == null) {
            QualityToolValidationGlobalInspection.$$$reportNull$$$0(7);
        }
        if ((data = (List)globalContext.getProject().getUserData(this.getKey())) == null) {
            return;
        }
        List fileData = ContainerUtil.filter((Collection)data, i -> {
            String analyzedFile = QualityToolAnnotator.updateToLocalIfRemote(i.getFile(), manager.getProject(), this.getAnnotator().getQualityToolType());
            analyzedFile = PathUtil.toSystemIndependentName((String)analyzedFile);
            return file.getVirtualFile().getPath().equals(analyzedFile) || file.getVirtualFile().getPath().endsWith(i.getFile());
        });
        for (QualityToolXmlMessageProcessor.ProblemDescription problem : fileData) {
            QualityToolMessageProcessor messageProcessor;
            QualityToolMessage qualityToolMessage;
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            if (document != null && problem.getLineNumber() - 1 > 0 && problem.getLineNumber() - 1 < document.getLineCount()) {
                int end;
                int start = document.getLineStartOffset(problem.getLineNumber() - 1) + problem.getColumn();
                if (start > (end = document.getLineEndOffset(problem.getLineNumber() - 1))) {
                    return;
                }
                qualityToolMessage = new QualityToolMessage(file, TextRange.create((int)start, (int)end), problem.getSeverity(), problem.getMessage(), new IntentionAction[0]);
            } else {
                qualityToolMessage = new QualityToolMessage(file, problem.getLineNumber(), problem.getSeverity(), problem.getMessage(), new IntentionAction[0]);
            }
            if ((messageProcessor = (QualityToolMessageProcessor)globalContext.getProject().getUserData(this.ANNOTATOR_INFO)) == null) continue;
            ReadAction.run(() -> problemsHolder.registerProblem(manager.createProblemDescriptor((PsiElement)file, qualityToolMessage.getTextRange(), PhpBundle.message("0.12", messageProcessor.getMessagePrefix(), qualityToolMessage.getMessageText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])));
        }
    }

    protected abstract Key<List<QualityToolXmlMessageProcessor.ProblemDescription>> getKey();

    @NotNull
    protected abstract QualityToolAnnotator<?> getAnnotator();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolValidationGlobalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectionStarted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCmdOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

