/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolExecutionException;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class QualityToolXmlMessageProcessor
extends QualityToolMessageProcessor {
    private StringBuilder messageBuf;
    private int myPrevLine = -1;
    private final Set<String> lineMessages = new HashSet<String>();
    private StringBuilder errorBuf;
    private boolean myHasMessages = false;
    protected SAXParser mySAXParser;
    private static final Logger LOG = Logger.getInstance(QualityToolXmlMessageProcessor.class);

    protected QualityToolXmlMessageProcessor(QualityToolAnnotatorInfo<?> info) {
        super(info);
        try {
            this.mySAXParser = SAXParserFactory.newDefaultInstance().newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            LOG.error(e.getMessage());
        }
    }

    @Override
    public void parseLine(String line) {
        boolean isErrorMessageEnd;
        boolean isErrorMessageStart;
        if (LOG.isDebugEnabled()) {
            LOG.debug("'" + line + "'");
        }
        if (QualityToolXmlMessageProcessor.canBeMessageStart(line) && this.messageBuf == null) {
            this.messageBuf = new StringBuilder();
        }
        if (this.messageBuf == null) {
            if (!this.myHasMessages && StringUtil.isNotEmpty((String)line)) {
                if (this.errorBuf == null) {
                    this.errorBuf = new StringBuilder();
                }
                this.errorBuf.append(line);
            }
            return;
        }
        String message = this.messageBuf.append(line).toString().trim();
        boolean bl = isErrorMessageStart = this.getMessageStart(message) > -1;
        if (QualityToolXmlMessageProcessor.canBeMessageEnd(message) && !isErrorMessageStart) {
            this.messageBuf = null;
            return;
        }
        boolean bl2 = isErrorMessageEnd = this.getMessageEnd(message) > -1;
        if (isErrorMessageEnd) {
            InputSource source = new InputSource(new StringReader(message));
            this.myHasMessages = true;
            this.messageBuf = null;
            try {
                this.processMessage(source);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
    }

    protected void processMessage(InputSource source) throws SAXException, IOException {
        XMLMessageHandler messageHandler = this.getXmlMessageHandler();
        this.mySAXParser.parse(source, (DefaultHandler)messageHandler);
        if (messageHandler.isStatusValid() && !this.getFile().getProject().isDisposed()) {
            String messageText;
            int endOffset;
            int startOffset;
            Document document = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
            QualityToolMessage qualityToolMessage = document != null && messageHandler.getColumn() != 0 && messageHandler.getLineNumber() > 0 && messageHandler.getLineNumber() < document.getLineCount() ? new QualityToolMessage((QualityToolMessageProcessor)this, (startOffset = document.getLineStartOffset(messageHandler.getLineNumber() - 1) + messageHandler.getColumn()) < (endOffset = document.getLineEndOffset(messageHandler.getLineNumber() - 1)) ? TextRange.create((int)startOffset, (int)endOffset) : TextRange.EMPTY_RANGE, messageHandler.getSeverity(), messageHandler.getMessageText(), this.getQuickFix(messageHandler)) : new QualityToolMessage((QualityToolMessageProcessor)this, messageHandler.getLineNumber(), messageHandler.getSeverity(), messageHandler.getMessageText(), this.getQuickFix(messageHandler));
            int currLine = qualityToolMessage.getLineNum();
            if (currLine != this.myPrevLine) {
                this.lineMessages.clear();
                this.myPrevLine = currLine;
            }
            if (this.lineMessages.add(messageText = qualityToolMessage.getMessageText())) {
                this.addMessage(qualityToolMessage);
            }
        }
    }

    protected IntentionAction @NotNull [] getQuickFix(XMLMessageHandler messageHandler) {
        if (IntentionAction.EMPTY_ARRAY == null) {
            QualityToolXmlMessageProcessor.$$$reportNull$$$0(0);
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    private static boolean canBeMessageStart(String message) {
        return StringUtil.startsWith((CharSequence)message.trim(), (CharSequence)"<");
    }

    private static boolean canBeMessageEnd(String message) {
        return StringUtil.endsWith((CharSequence)message, (CharSequence)">");
    }

    @Override
    public void done() throws QualityToolExecutionException {
        if (!this.myHasMessages && this.errorBuf != null) {
            throw new QualityToolExecutionException(this.errorBuf.toString());
        }
    }

    protected abstract XMLMessageHandler getXmlMessageHandler();

    public abstract int getMessageStart(@NotNull String var1);

    public abstract int getMessageEnd(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/tools/quality/QualityToolXmlMessageProcessor", "getQuickFix"));
    }

    protected static abstract class XMLMessageHandler
    extends DefaultHandler {
        protected int myLineNumber = -1;
        protected QualityToolMessage.Severity mySeverity;
        protected final StringBuilder myMessageBuf = new StringBuilder();

        protected XMLMessageHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.parseTag(qName, attributes);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.myMessageBuf.append(ch, start, length);
        }

        protected abstract void parseTag(@NotNull String var1, @NotNull Attributes var2);

        public int getLineNumber() {
            return this.myLineNumber;
        }

        protected int getColumn() {
            return 0;
        }

        public QualityToolMessage.Severity getSeverity() {
            return this.mySeverity;
        }

        @NlsSafe
        public String getMessageText() {
            String messageText = this.myMessageBuf.toString().trim();
            if (messageText.indexOf(10) >= 0) {
                messageText = messageText.replace('\n', ' ');
            }
            return messageText;
        }

        public boolean isStatusValid() {
            return this.myLineNumber > -1 && this.myMessageBuf.length() > 0;
        }

        protected static int parseLineNumber(@Nullable String lineNumStr) {
            if (lineNumStr != null) {
                try {
                    return Integer.parseInt(lineNumStr);
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Invalid line number: " + lineNumStr);
                }
            } else {
                LOG.error("Missing line number");
            }
            return -1;
        }
    }

    public static class ProblemDescription {
        private final QualityToolMessage.Severity mySeverity;
        private final int myLineNumber;
        private final int myColumn;
        @NlsSafe
        private final String myMessage;
        private final String myFile;

        public ProblemDescription(QualityToolMessage.Severity severity, int lineNumber, int column, @NlsSafe String message, String file) {
            this.mySeverity = severity;
            this.myLineNumber = lineNumber;
            this.myColumn = column;
            this.myMessage = message;
            this.myFile = file;
        }

        public QualityToolMessage.Severity getSeverity() {
            return this.mySeverity;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getColumn() {
            return this.myColumn;
        }

        @NlsSafe
        public String getMessage() {
            return this.myMessage;
        }

        public String getFile() {
            return this.myFile;
        }
    }
}

