/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.google.common.util.concurrent.Runnables;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationComboBox;
import com.jetbrains.php.tools.quality.QualityToolProjectConfiguration;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolsOptionsPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(QualityToolsOptionsPanel.class);
    protected Project myProject;
    protected Runnable myValidate;
    private final QualityToolType myQualityToolType;
    protected boolean updated;

    public QualityToolsOptionsPanel(@Nullable Project project, Runnable validate, QualityToolType qualityToolType) {
        this.myProject = project;
        this.myValidate = validate;
        this.myQualityToolType = qualityToolType;
    }

    public QualityToolsOptionsPanel(@Nullable Project project, QualityToolType qualityToolType) {
        this.myProject = project;
        this.myValidate = Runnables.doNothing();
        this.myQualityToolType = qualityToolType;
    }

    public JPanel getOptionsPanel() {
        return new JPanel();
    }

    @Nullable
    protected PhpSdkAdditionalData getSdkAdditionalData(@NotNull Project project, QualityToolConfigurationComboBox comboBox) {
        PhpInterpreter id;
        if (project == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(0);
        }
        return (id = this.getSelectedInterpreter(project, comboBox)) != null ? id.getPhpSdkAdditionalData() : null;
    }

    @NotNull
    protected QualityToolProjectConfiguration getProjectConfiguration(Project project) {
        QualityToolProjectConfiguration qualityToolProjectConfiguration = this.myQualityToolType.getProjectConfiguration(project);
        if (qualityToolProjectConfiguration == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(1);
        }
        return qualityToolProjectConfiguration;
    }

    protected PhpInterpreter getSelectedInterpreter(@NotNull Project project, String selectedConfigurationItem) {
        if (project == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(2);
        }
        try {
            Object configuration = this.getProjectConfiguration(this.myProject).findConfiguration(project, selectedConfigurationItem);
            if (configuration == null || StringUtil.isEmpty((String)((QualityToolConfiguration)configuration).getInterpreterId())) {
                return null;
            }
            return PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(((QualityToolConfiguration)configuration).getInterpreterId());
        }
        catch (QualityToolValidationException e) {
            return null;
        }
    }

    protected PhpInterpreter getSelectedInterpreter(@NotNull Project project, QualityToolConfigurationComboBox comboBox) {
        if (project == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(3);
        }
        return this.getSelectedInterpreter(project, comboBox.getSelectedItemId());
    }

    protected ActionListener createBrowserAction(@Nullable Project project, @NotNull Component parent, @NotNull TextFieldWithBrowseButton pathField, QualityToolConfigurationComboBox comboBox, String rulesetPath) throws PhpInvalidSdkTypeException {
        PhpInterpreter interpreter;
        if (parent == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(4);
        }
        if (pathField == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(5);
        }
        if ((interpreter = this.getSelectedInterpreter(project, comboBox)) != null && interpreter.isRemote()) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager != null) {
                try {
                    return manager.createRemoteBrowserAction(project, interpreter.getPhpSdkAdditionalData(), "Set Path", pathField.getTextField(), false);
                }
                catch (PhpInvalidSdkTypeException e2) {
                    LOG.warn(e2.getMessage());
                }
            } else {
                LOG.warn(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
            }
        }
        return e -> this.chooseFile(parent, rulesetPath, pathField);
    }

    private void chooseFile(Component parent, String rulesetPath, @NotNull TextFieldWithBrowseButton pathField) {
        FileChooserDescriptor fileChooserDescriptor;
        VirtualFile file2;
        File physicalFile;
        if (pathField == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(6);
        }
        VirtualFile currFile = null;
        if (rulesetPath != null && !rulesetPath.isEmpty() && (physicalFile = new File(rulesetPath)).exists()) {
            currFile = VfsUtil.findFileByIoFile((File)physicalFile, (boolean)true);
        }
        if ((file2 = FileChooser.chooseFile((FileChooserDescriptor)(fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor().withFileFilter(file -> this.containsRulesetXml((VirtualFile)file))), (Component)parent, null, currFile)) != null) {
            pathField.setText(file2.getPath());
        }
    }

    @Nullable
    protected String validatePath() {
        return null;
    }

    @NotNull
    protected Project getCurrentProject(@NotNull DataContext context) {
        Project project;
        if (context == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(7);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        if (project2 == null) {
            QualityToolsOptionsPanel.$$$reportNull$$$0(8);
        }
        return project2;
    }

    protected boolean containsRulesetXml(@Nullable VirtualFile folder) {
        return true;
    }

    public void reset() {
    }

    public boolean isModified() {
        return false;
    }

    public void apply() {
    }

    public void updateStandards() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolsOptionsPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathField";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolsOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSdkAdditionalData";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedInterpreter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBrowserAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8 -> new IllegalStateException(string);
        };
    }
}

