/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.jetbrains.php.PhpBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebuggerLabel
extends JBLabel {
    private static final Pair<@Nls String, @NlsSafe String> xdebugItem = Pair.create((Object)PhpBundle.message("debug.xdebug", new Object[0]), (Object)"php.debugger.XDebug");
    private static final Pair<@Nls String, @NlsSafe String> zendDebuggerItem = Pair.create((Object)PhpBundle.message("debug.zend.debugger", new Object[0]), (Object)"php.debugger.ZendDebugger");
    @NotNull
    private String myDebuggerId;

    public PhpDebuggerLabel() {
        this.myDebuggerId = (String)PhpDebuggerLabel.xdebugItem.second;
    }

    @NotNull
    public String getDebuggerId() {
        String string = this.myDebuggerId;
        if (string == null) {
            PhpDebuggerLabel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setDebugger(@Nullable String debuggerName, @Nullable @NlsSafe String version) {
        Pair<@Nls String, @NlsSafe String> configuration = PhpDebuggerLabel.getDebuggerConfiguration(debuggerName);
        if (configuration != null) {
            this.myDebuggerId = (String)configuration.second;
            String debuggerText = (String)configuration.first + " " + StringUtil.notNullize((String)version);
            this.setText(debuggerText);
        } else {
            this.setText(PhpBundle.message("PhpInterpreterConfigurable.not.installed", new Object[0]));
        }
    }

    private static Pair<@Nls String, @NlsSafe String> getDebuggerConfiguration(@Nullable String name) {
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)((CharSequence)PhpDebuggerLabel.xdebugItem.first))) {
            return xdebugItem;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)((CharSequence)PhpDebuggerLabel.zendDebuggerItem.first))) {
            return zendDebuggerItem;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/ui/PhpDebuggerLabel", "getDebuggerId"));
    }
}

