/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.AnActionLink;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.ui.PhpExpandableInfoComponent;
import com.jetbrains.php.ui.PhpInfoLabelPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpExpandableInfoLabelPanel
extends PhpInfoLabelPanel {
    protected final PhpExpandableInfoComponent myExpandableLabel;

    protected PhpExpandableInfoLabelPanel(@NotNull String title, @NotNull Icon icon, @NotNull @Nls String additionalInfo, boolean adjustWindow, boolean isExpanded, List<AnAction> anActionList) {
        if (title == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(1);
        }
        if (additionalInfo == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        String fullTitle = "<html>" + title + " <a href=\"#\">(...)</a>";
        this.myExpandableLabel = this.createInfoComponent(fullTitle, icon, adjustWindow, anActionList);
        JTextPane infoArea = new JTextPane();
        infoArea.setEditorKit(HTMLEditorKitBuilder.simple());
        this.installHyperlinkSupport(infoArea);
        infoArea.setText(this.prepareAdditionalInfo(additionalInfo));
        infoArea.setEditable(false);
        infoArea.setBackground(UIUtil.getPanelBackground().brighter());
        infoArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(NamedColorUtil.getBoundsColor()), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        infoArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpManager.getInstance().invokeHelp(e.getDescription());
                }
            }
        });
        this.myExpandableLabel.setContentComponent(infoArea);
        this.myExpandableLabel.setOn(isExpanded);
    }

    @NotNull
    @Nls
    protected String prepareAdditionalInfo(@NotNull @Nls String additionalInfo) {
        if (additionalInfo == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(3);
        }
        String string = additionalInfo;
        if (string == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void installHyperlinkSupport(@NotNull JTextPane infoArea) {
        if (infoArea == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(5);
        }
        Messages.installHyperlinkSupport((JTextPane)infoArea);
    }

    @NotNull
    public PhpExpandableInfoComponent createInfoComponent(@NotNull String title, @NotNull Icon icon, boolean adjustWindow, List<AnAction> anActionList) {
        if (title == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(6);
        }
        if (icon == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(7);
        }
        PhpExpandableInfoLabel phpExpandableInfoLabel = PhpExpandableInfoLabel.create(this, title, icon, adjustWindow, anActionList);
        if (phpExpandableInfoLabel == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(8);
        }
        return phpExpandableInfoLabel;
    }

    public void setOn(boolean on) {
        this.myExpandableLabel.setOn(on);
    }

    public boolean isExpanded() {
        return this.myExpandableLabel.isExpanded();
    }

    public void setText(@NlsContexts.Label String title) {
        this.myExpandableLabel.setText(title);
    }

    public String getText() {
        return this.myExpandableLabel.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myExpandableLabel.setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalInfo";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpExpandableInfoLabelPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpExpandableInfoLabelPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAdditionalInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareAdditionalInfo";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installHyperlinkSupport";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInfoComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }

    private static class PhpExpandableInfoLabel
    extends PhpExpandableInfoComponent<JPanel> {
        JLabel myLabel;

        public static PhpExpandableInfoLabel create(JPanel panel, String title, Icon icon, boolean adjustWindow, List<AnAction> anActions) {
            PhpExpandableInfoLabel label = new PhpExpandableInfoLabel(panel, adjustWindow, anActions);
            label.init(title, icon, anActions);
            return label;
        }

        PhpExpandableInfoLabel(JPanel panel, boolean adjustWindow, List<AnAction> anActions) {
            super(panel, adjustWindow);
        }

        @Override
        protected JPanel createCenterComponent(@NotNull @Nls String text, @NotNull Icon icon, List<AnAction> anActions) {
            if (text == null) {
                PhpExpandableInfoLabel.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                PhpExpandableInfoLabel.$$$reportNull$$$0(1);
            }
            this.myLabel = new JLabel(text);
            this.myLabel.setIcon(icon);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0);
            jPanel.add((Component)this.myLabel, gc);
            for (AnAction action : anActions) {
                jPanel.add((Component)new AnActionLink(action.getTemplatePresentation().getText(), action), gc);
            }
            return jPanel;
        }

        @Override
        protected JLabel getLabel() {
            return this.myLabel;
        }

        @Override
        public void setText(@NlsContexts.Label String title) {
            this.getLabel().setText(title);
        }

        @Override
        @NlsSafe
        public String getText() {
            return this.getLabel().getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/ui/PhpExpandableInfoLabelPanel$PhpExpandableInfoLabel";
            objectArray[2] = "createCenterComponent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

