/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.awt.Component;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTargetClassChooser {
    private final JPanel myPanel;
    private final JBCheckBox myTargetClassCheckBox;
    private final LanguageTextField myTargetClassTextField;

    public PhpTargetClassChooser(Project project, String initialValue, boolean checkboxEnabled, Disposable disposable) {
        this.myTargetClassTextField = this.createTextField(project, initialValue, disposable);
        this.myTargetClassCheckBox = this.createCheckBox(checkboxEnabled, StringUtil.isNotEmpty((String)initialValue));
        this.myPanel = this.createPanel();
    }

    @NotNull
    public LanguageTextField createTextField(Project project, String initialValue, Disposable disposable) {
        LanguageTextField field = new LanguageTextField((Language)PhpLanguage.INSTANCE, project, initialValue);
        PhpCompletionUtil.installClassInterfaceCompletion((EditorTextField)field, initialValue, disposable, (Condition<? super PhpClass>)((Condition)aClass -> true), new String[0]);
        LanguageTextField languageTextField = field;
        if (languageTextField == null) {
            PhpTargetClassChooser.$$$reportNull$$$0(0);
        }
        return languageTextField;
    }

    @NotNull
    public JBCheckBox createCheckBox(boolean checkboxEnabled, boolean selected) {
        JBCheckBox box = new JBCheckBox(PhpBundle.message("target.class", new Object[0]));
        box.addChangeListener(e -> this.myTargetClassTextField.setEnabled(box.isSelected()));
        box.setSelected(selected);
        box.setEnabled(checkboxEnabled);
        JBCheckBox jBCheckBox = box;
        if (jBCheckBox == null) {
            PhpTargetClassChooser.$$$reportNull$$$0(1);
        }
        return jBCheckBox;
    }

    @NotNull
    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)this.myTargetClassCheckBox);
        this.myTargetClassCheckBox.setAlignmentX(0.0f);
        panel.add((Component)this.myTargetClassTextField);
        this.myTargetClassTextField.setAlignmentX(0.0f);
        JPanel jPanel = panel;
        if (jPanel == null) {
            PhpTargetClassChooser.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    public String getTargetClassFqn() {
        if (!this.myTargetClassCheckBox.isSelected()) {
            return null;
        }
        String text = this.myTargetClassTextField.getText().trim();
        return StringUtil.isEmpty((String)text) ? null : PhpLangUtil.toFQN(text);
    }

    @Nullable
    public ValidationInfo validate(Project project) {
        if (!this.myTargetClassCheckBox.isSelected()) {
            return null;
        }
        String fqn = StringUtil.notNullize((String)this.getTargetClassFqn());
        Collection<PhpClass> classes = PhpIndex.getInstance(project).getAnyByFQN(fqn);
        if (classes.size() == 1) {
            return null;
        }
        return classes.size() == 0 ? new ValidationInfo(PhpBundle.message("invalid.class.name", new Object[0])) : new ValidationInfo(PhpBundle.message("refactoring.move.members.there.are.several.classes.with.specified.name", fqn));
    }

    @Nullable
    public PhpClass findTargetClass(Project project) {
        if (!this.myTargetClassCheckBox.isSelected()) {
            return null;
        }
        PhpIndex instance = PhpIndex.getInstance(project);
        return (PhpClass)ContainerUtil.getOnlyItem(instance.getAnyByFQN(StringUtil.notNullize((String)this.getTargetClassFqn())));
    }

    public JBCheckBox getTargetClassCheckBox() {
        return this.myTargetClassCheckBox;
    }

    public JComponent getTargetClassFocusable() {
        return this.myTargetClassTextField.getFocusTarget();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/ui/PhpTargetClassChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckBox";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

