/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoDialog;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.ui.PhpSingleConfigurableEditor;
import com.jetbrains.php.ui.ResultMessage;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUiUtil {
    private PhpUiUtil() {
    }

    @Nullable
    public static VirtualFile getFileOrProjectRoot(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            PhpUiUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return project.getBaseDir();
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public static void show(@NotNull DialogWrapper dialog) {
        if (dialog == null) {
            PhpUiUtil.$$$reportNull$$$0(1);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> dialog.show());
    }

    public static void requestFocusIfAppInactive(@NotNull DialogWrapper dialog) {
        Project project;
        Window owner;
        if (dialog == null) {
            PhpUiUtil.$$$reportNull$$$0(2);
        }
        if ((owner = dialog.getOwner()) instanceof IdeFrame && (project = ((IdeFrame)owner).getProject()) != null) {
            ProjectUtil.focusProjectWindow((Project)project, (boolean)true);
        }
    }

    public static int getIntValue(@NotNull String value) {
        if (value == null) {
            PhpUiUtil.$$$reportNull$$$0(3);
        }
        return StringUtilRt.parseInt((String)value, (int)-1);
    }

    @NotNull
    @NlsContexts.Label
    public static String toRedColorHtml(@NotNull @NlsContexts.Label String text) {
        if (text == null) {
            PhpUiUtil.$$$reportNull$$$0(4);
        }
        String string = PhpUiUtil.surroundWithHtml(PhpUiUtil.surroundFontColorRed(text));
        if (string == null) {
            PhpUiUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsContexts.Label
    public static String surroundWithHtml(@NotNull @NlsContexts.Label String text) {
        if (text == null) {
            PhpUiUtil.$$$reportNull$$$0(6);
        }
        return "<html>" + text + "</html>";
    }

    public static String surroundFontColorRed(@NotNull String text) {
        if (text == null) {
            PhpUiUtil.$$$reportNull$$$0(7);
        }
        return "<font color='red'>" + text + "</font>";
    }

    public static boolean editConfigurable(@NotNull Project project, @NotNull Configurable configurable) {
        if (project == null) {
            PhpUiUtil.$$$reportNull$$$0(8);
        }
        if (configurable == null) {
            PhpUiUtil.$$$reportNull$$$0(9);
        }
        PhpSingleConfigurableEditor editor = new PhpSingleConfigurableEditor(project, configurable);
        return editor.showAndGet();
    }

    @NotNull
    public static AnAction createReloadAction(final @NotNull Computable<ResultMessage> computable, final @NotNull BooleanSupplier isEnabledComputable) {
        if (computable == null) {
            PhpUiUtil.$$$reportNull$$$0(10);
        }
        if (isEnabledComputable == null) {
            PhpUiUtil.$$$reportNull$$$0(11);
        }
        return new DumbAwareAction(PhpBundle.message("PhpInterpreterConfigurable.reload.phpinfo", new Object[0]), null, PlatformIcons.SYNCHRONIZE_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ResultMessage result = (ResultMessage)computable.compute();
                InputEvent event = e.getInputEvent();
                if (event instanceof MouseEvent) {
                    PhpUiUtil.showBalloon(result.getMessage(), result.getType(), (MouseEvent)event);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(isEnabledComputable.getAsBoolean());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/ui/PhpUiUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/ui/PhpUiUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static AnAction createShowPhpInfoAction(final @NotNull JComponent parent, final @NotNull Supplier<@Nullable Pair<PhpInfo, PhpNonPersistedInfo>> runnable, final @NotNull Supplier<@Nullable Pair<PhpInfo, PhpNonPersistedInfo>> isEnabledComputable) {
        if (parent == null) {
            PhpUiUtil.$$$reportNull$$$0(12);
        }
        if (runnable == null) {
            PhpUiUtil.$$$reportNull$$$0(13);
        }
        if (isEnabledComputable == null) {
            PhpUiUtil.$$$reportNull$$$0(14);
        }
        return new DumbAwareAction(PhpBundle.message("PhpInterpreterConfigurable.show.phpinfo", new Object[0]), null, UIUtil.getBalloonInformationIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Pair phpInfo;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((phpInfo = (Pair)runnable.get()) != null) {
                    PhpInfoDialog.show(parent, (PhpInfo)phpInfo.getFirst(), (PhpNonPersistedInfo)phpInfo.getSecond());
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(isEnabledComputable.get() != null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/ui/PhpUiUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/ui/PhpUiUtil$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static JComponent createHorizontalActionsToolbar(@NotNull String place, AnAction ... actions) {
        if (place == null) {
            PhpUiUtil.$$$reportNull$$$0(15);
        }
        if (actions == null) {
            PhpUiUtil.$$$reportNull$$$0(16);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (AnAction action : actions) {
            actionGroup.addAction(action);
        }
        JComponent jComponent = ActionManager.getInstance().createActionToolbar(place, (ActionGroup)actionGroup, true).getComponent();
        if (jComponent == null) {
            PhpUiUtil.$$$reportNull$$$0(17);
        }
        return jComponent;
    }

    public static String getShortcutTextByActionName(@NotNull String actionName) {
        if (actionName == null) {
            PhpUiUtil.$$$reportNull$$$0(18);
        }
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction(actionName));
    }

    public static void showBalloon(@NotNull @NlsContexts.PopupContent String message, @NotNull MessageType messageType, @NotNull Component component) {
        if (message == null) {
            PhpUiUtil.$$$reportNull$$$0(19);
        }
        if (messageType == null) {
            PhpUiUtil.$$$reportNull$$$0(20);
        }
        if (component == null) {
            PhpUiUtil.$$$reportNull$$$0(21);
        }
        Rectangle rect = component.getBounds();
        Point p = new Point(rect.x, rect.y + rect.height);
        PhpUiUtil.showBalloon(message, messageType, new RelativePoint(component, p));
    }

    public static void showBalloon(@NotNull @NlsContexts.PopupContent String message, @NotNull MessageType messageType, @NotNull MouseEvent event) {
        if (message == null) {
            PhpUiUtil.$$$reportNull$$$0(22);
        }
        if (messageType == null) {
            PhpUiUtil.$$$reportNull$$$0(23);
        }
        if (event == null) {
            PhpUiUtil.$$$reportNull$$$0(24);
        }
        PhpUiUtil.showBalloon(message, messageType, new RelativePoint(event));
    }

    private static void showBalloon(@NotNull @NlsContexts.PopupContent String message, @NotNull MessageType messageType, @NotNull RelativePoint point) {
        if (message == null) {
            PhpUiUtil.$$$reportNull$$$0(25);
        }
        if (messageType == null) {
            PhpUiUtil.$$$reportNull$$$0(26);
        }
        if (point == null) {
            PhpUiUtil.$$$reportNull$$$0(27);
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(messageType == MessageType.INFO ? 1500L : 10000L);
        Balloon balloon = balloonBuilder.createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)PhpRefactoringSettings.getInstance(), (Disposable)balloon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpUiUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isEnabledComputable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpUiUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toRedColorHtml";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createHorizontalActionsToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrProjectRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requestFocusIfAppInactive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toRedColorHtml";
                break;
            }
            case 5: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "surroundWithHtml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "surroundFontColorRed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "editConfigurable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createReloadAction";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createShowPhpInfoAction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createHorizontalActionsToolbar";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutTextByActionName";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 17 -> new IllegalStateException(string);
        };
    }
}

