/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.uml.PhpUmlEdge;
import com.jetbrains.php.uml.PhpUmlNode;
import com.jetbrains.php.uml.PhpUmlProvider;
import com.jetbrains.php.uml.PhpUmlRelationships;
import com.jetbrains.php.uml.PhpUmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUmlDataModel
extends DiagramDataModel<PsiElement> {
    private final Map<String, SmartPsiElementPointer<PhpClass>> classesAddedByUser = new HashMap<String, SmartPsiElementPointer<PhpClass>>();
    private final Map<String, SmartPsiElementPointer<PhpClass>> classesRemovedByUser = new HashMap<String, SmartPsiElementPointer<PhpClass>>();
    private final Map<String, SmartPsiElementPointer<PsiDirectory>> directoriesAddedByUser = new HashMap<String, SmartPsiElementPointer<PsiDirectory>>();
    private final SmartPointerManager spManager;
    private final Collection<DiagramNode<PsiElement>> myNodes = new HashSet<DiagramNode<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myEdges = new HashSet<DiagramEdge<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myDependencyEdges = new HashSet<DiagramEdge<PsiElement>>();
    private final Collection<DiagramNode<PsiElement>> myNodesOld = new HashSet<DiagramNode<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myEdgesOld = new HashSet<DiagramEdge<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myDependencyEdgesOld = new HashSet<DiagramEdge<PsiElement>>();

    public PhpUmlDataModel(Project project, @Nullable PsiElement psiElement) {
        super(project, PhpUmlProvider.getInstance());
        this.spManager = SmartPointerManager.getInstance((Project)this.getProject());
        if (psiElement instanceof PhpClass) {
            Set<PhpClass> classes = PhpUmlDataModel.getAllParentsForClass((PhpClass)psiElement);
            for (PhpClass aClass : classes) {
                this.classesAddedByUser.put(aClass.getFQN(), (SmartPsiElementPointer<PhpClass>)this.spManager.createSmartPsiElementPointer((PsiElement)aClass));
            }
        }
        if (psiElement instanceof PsiDirectory) {
            for (PsiElement child : psiElement.getChildren()) {
                if (child instanceof PsiDirectory && !((PsiDirectory)child).getVirtualFile().equals(ProjectKt.getProjectStoreDirectory((VirtualFile)((PsiDirectory)psiElement).getVirtualFile()))) {
                    this.directoriesAddedByUser.put(PhpUmlUtil.getFQN(child), (SmartPsiElementPointer<PsiDirectory>)this.spManager.createSmartPsiElementPointer((PsiElement)((PsiDirectory)child)));
                    continue;
                }
                if (!(child instanceof PhpFile)) continue;
                Collection<PhpClass> classes = PhpPsiUtil.findAllClasses((PhpFile)child);
                for (PhpClass it : classes) {
                    this.classesAddedByUser.put(it.getFQN(), (SmartPsiElementPointer<PhpClass>)this.spManager.createSmartPsiElementPointer((PsiElement)it));
                    Set<PhpClass> parentsForClass = PhpUmlDataModel.getAllParentsForClass(it);
                    for (PhpClass parent : parentsForClass) {
                        this.classesAddedByUser.put(parent.getFQN(), (SmartPsiElementPointer<PhpClass>)this.spManager.createSmartPsiElementPointer((PsiElement)parent));
                    }
                }
            }
        }
    }

    private static <T> void clearAndBackup(Collection<T> target, Collection<T> backup) {
        backup.clear();
        backup.addAll(target);
        target.clear();
    }

    private static <T> void mergeWithBackup(Collection<T> target, Collection<T> backup) {
        for (T t : backup) {
            if (!target.contains(t)) continue;
            target.remove(t);
            target.add(t);
        }
    }

    private static void findNearestInterfaces(PhpClass phpClass, Set<String> interfaces, Set<PhpClass> found) {
        for (PhpClass inter : phpClass.getImplementedInterfaces()) {
            if (interfaces.contains(inter.getFQN())) {
                found.add(inter);
                continue;
            }
            PhpUmlDataModel.findNearestInterfaces(inter, interfaces, found);
        }
    }

    private static boolean isGeneralizationEdgeAllowed(PhpClass phpClass) {
        return !phpClass.isInterface();
    }

    private static void addEdge(DiagramNode<PsiElement> from, DiagramNode<PsiElement> to, DiagramRelationshipInfo relationship, Collection<DiagramEdge<PsiElement>> storage) {
        for (DiagramEdge<PsiElement> edge : storage) {
            if (edge.getSource() != from || edge.getTarget() != to || edge.getRelationship() != relationship) continue;
            return;
        }
        storage.add((DiagramEdge<PsiElement>)new PhpUmlEdge(from, to, relationship));
    }

    private static Set<PhpClass> getAllParentsForClass(PhpClass cl) {
        HashSet<PhpClass> superClasses = new HashSet<PhpClass>();
        PhpClassHierarchyUtils.processSupers(cl, true, false, (Processor<? super PhpClass>)((Processor)aClass -> {
            superClasses.add((PhpClass)aClass);
            return true;
        }));
        return superClasses;
    }

    @NotNull
    public Collection<DiagramNode<PsiElement>> getNodes() {
        Collection<DiagramNode<PsiElement>> collection = this.myNodes;
        if (collection == null) {
            PhpUmlDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<PsiElement>> getEdges() {
        if (this.myDependencyEdges.isEmpty()) {
            Collection<DiagramEdge<PsiElement>> collection = this.myEdges;
            if (collection == null) {
                PhpUmlDataModel.$$$reportNull$$$0(1);
            }
            return collection;
        }
        HashSet<DiagramEdge<PsiElement>> allEdges = new HashSet<DiagramEdge<PsiElement>>(this.myEdges);
        allEdges.addAll(this.myDependencyEdges);
        HashSet<DiagramEdge<PsiElement>> hashSet = allEdges;
        if (hashSet == null) {
            PhpUmlDataModel.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    @NonNls
    public String getNodeName(@NotNull DiagramNode<PsiElement> node) {
        PsiElement element;
        if (node == null) {
            PhpUmlDataModel.$$$reportNull$$$0(3);
        }
        if ((element = (PsiElement)node.getIdentifyingElement()) instanceof PhpClass) {
            String string = "Class " + ((PhpClass)element).getName();
            if (string == null) {
                PhpUmlDataModel.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (element instanceof PsiDirectory) {
            String string = "Directory " + ((PsiDirectory)element).getName();
            if (string == null) {
                PhpUmlDataModel.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    public void removeNode(@NotNull DiagramNode<PsiElement> node) {
        if (node == null) {
            PhpUmlDataModel.$$$reportNull$$$0(6);
        }
        this.removeElement((PsiElement)node.getIdentifyingElement());
    }

    public void removeEdge(@NotNull DiagramEdge<PsiElement> edge) {
        if (edge == null) {
            PhpUmlDataModel.$$$reportNull$$$0(7);
        }
        PsiElement source = (PsiElement)edge.getSource().getIdentifyingElement();
        PsiElement target = (PsiElement)edge.getTarget().getIdentifyingElement();
        DiagramRelationshipInfo relationship = edge.getRelationship();
        if (source instanceof PhpClass) {
            PhpClass src = (PhpClass)source;
            if (target instanceof PhpClass) {
                PhpClass trg = (PhpClass)target;
                if (relationship != DiagramRelationshipInfo.NO_RELATIONSHIP) {
                    int exitCode;
                    int n = exitCode = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)src.getProject(), (String)PhpBundle.message("this.will.remove.relationship.link.between.classes", src, trg), (String)PhpBundle.message("remove.relationship.link", new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (exitCode == 0) {
                        String commandName = PhpBundle.message("remove.link.between.0.and.1", src.getName(), trg.getName());
                        Runnable runnable = () -> {
                            if (FileModificationService.getInstance().prepareFileForWrite(src.getContainingFile())) {
                                try {
                                    ExtendsList extendsList = src.getExtendsList();
                                    ImplementsList implementsList = src.getImplementsList();
                                    if (relationship == PhpUmlRelationships.GENERALIZATION || relationship == PhpUmlRelationships.INTERFACE_GENERALIZATION) {
                                        PhpRefactoringUtil.removeReferenceFromExtendsList(extendsList, trg);
                                    } else if (relationship == PhpUmlRelationships.REALIZATION) {
                                        if (trg.isInterface()) {
                                            PhpRefactoringUtil.removeReferenceFromImplementsList(implementsList, trg);
                                        } else {
                                            PhpRefactoringUtil.removeReferenceFromExtendsList(extendsList, trg);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), (Runnable)runnable, (String)commandName, null, (PsiElement[])new PsiElement[]{source.getContainingFile()});
                    }
                }
            }
        }
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    public void expandNode(@NotNull DiagramNode<PsiElement> node) {
        PsiElement element;
        if (node == null) {
            PhpUmlDataModel.$$$reportNull$$$0(8);
        }
        if ((element = (PsiElement)node.getIdentifyingElement()) instanceof PsiDirectory) {
            this.expandPackage((PsiDirectory)element);
            this.removeElement(element);
        }
    }

    public void collapseNode(@NotNull DiagramNode<PsiElement> node) {
        PsiDirectory psiPackage;
        PsiElement element;
        if (node == null) {
            PhpUmlDataModel.$$$reportNull$$$0(9);
        }
        if ((element = (PsiElement)node.getIdentifyingElement()) instanceof PsiDirectory) {
            psiPackage = ((PsiDirectory)element).getParent();
            if (psiPackage == null) {
                return;
            }
        } else {
            psiPackage = PhpUmlUtil.getDirectory(element);
        }
        if (psiPackage == null) {
            return;
        }
        String fqn1 = PhpUmlUtil.getFQN((PsiElement)psiPackage);
        if (fqn1 != null && fqn1.isEmpty()) {
            return;
        }
        String fqnStart = fqn1 + "/";
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String fqn : this.directoriesAddedByUser.keySet()) {
            if (!fqn.startsWith(fqnStart)) continue;
            toRemove.add(fqn);
        }
        for (String fqn : toRemove) {
            this.directoriesAddedByUser.remove(fqn);
        }
        toRemove.clear();
        this.classesAddedByUser.forEach((s, pointer) -> {
            PhpClass phpClass = (PhpClass)pointer.getElement();
            if (phpClass != null && psiPackage.equals(phpClass.getContainingFile().getParent())) {
                toRemove.add(PhpUmlUtil.getFQN((PsiElement)phpClass));
            }
        });
        for (String fqn : toRemove) {
            this.classesAddedByUser.remove(fqn);
        }
        this.directoriesAddedByUser.put(PhpUmlUtil.getFQN((PsiElement)psiPackage), (SmartPsiElementPointer<PsiDirectory>)this.spManager.createSmartPsiElementPointer((PsiElement)psiPackage));
    }

    public void expandPackage(PsiDirectory psiPackage) {
        this.directoriesAddedByUser.remove(PhpUmlUtil.getFQN((PsiElement)psiPackage));
        for (PsiElement element : psiPackage.getChildren()) {
            this.addElement(element);
        }
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            PhpUmlDataModel.$$$reportNull$$$0(10);
        }
        return psiModificationTracker;
    }

    private void clearAll() {
        PhpUmlDataModel.clearAndBackup(this.myNodes, this.myNodesOld);
        PhpUmlDataModel.clearAndBackup(this.myEdges, this.myEdgesOld);
        PhpUmlDataModel.clearAndBackup(this.myDependencyEdges, this.myDependencyEdgesOld);
    }

    private boolean isAllowedToShow(PhpClass phpClass) {
        if (phpClass == null || !phpClass.isValid()) {
            return false;
        }
        if (PhpLangUtil.isObject(phpClass)) {
            return false;
        }
        for (SmartPsiElementPointer<PhpClass> pointer : this.classesRemovedByUser.values()) {
            if (!phpClass.equals(pointer.getElement())) continue;
            return false;
        }
        return true;
    }

    public synchronized void updateDataModel() {
        for (Map.Entry<String, SmartPsiElementPointer<PsiDirectory>> entry : this.directoriesAddedByUser.entrySet()) {
            this.myNodes.add((DiagramNode<PsiElement>)new PhpUmlNode(entry.getValue().getElement(), (DiagramProvider<PsiElement>)this.getProvider()));
        }
        Set<PhpClass> classes = this.getAllClasses();
        HashSet<String> interfaces = new HashSet<String>();
        for (PhpClass phpClass : classes) {
            if (this.isAllowedToShow(phpClass)) {
                this.myNodes.add((DiagramNode<PsiElement>)new PhpUmlNode((PsiElement)phpClass, (DiagramProvider<PsiElement>)this.getProvider()));
            }
            if (!phpClass.isInterface()) continue;
            interfaces.add(phpClass.getFQN());
        }
        for (PhpClass phpClass : classes) {
            DiagramNode<PsiElement> target;
            DiagramNode<PsiElement> source;
            if (PhpUmlDataModel.isGeneralizationEdgeAllowed(phpClass)) {
                DiagramNode<PsiElement> source2 = this.findNode((PsiElement)phpClass);
                Object target2 = null;
                for (PhpClass superClass = phpClass.getSuperClass(); target2 == null && superClass != null; superClass = superClass.getSuperClass()) {
                    target2 = this.findNode((PsiElement)superClass);
                }
                if (source2 != null && target2 != null && source2 != target2) {
                    this.addEdge(source2, (DiagramNode<PsiElement>)target2, PhpUmlRelationships.GENERALIZATION);
                }
            }
            for (Object inter : phpClass.getImplementedInterfaces()) {
                if (!interfaces.contains(inter.getFQN())) continue;
                source = this.findNode((PsiElement)phpClass);
                target = this.findNode((PsiElement)inter);
                if (source == null || target == null || source == target) continue;
                this.addEdge(source, target, phpClass.isInterface() ? PhpUmlRelationships.INTERFACE_GENERALIZATION : PhpUmlRelationships.REALIZATION);
            }
            if (phpClass.isInterface()) {
                HashSet<PhpClass> found = new HashSet<PhpClass>();
                PhpUmlDataModel.findNearestInterfaces(phpClass, interfaces, found);
                for (PhpClass inter : found) {
                    DiagramNode<PsiElement> source3 = this.findNode((PsiElement)phpClass);
                    DiagramNode<PsiElement> target3 = this.findNode((PsiElement)inter);
                    if (source3 == null || target3 == null || source3 == target3) continue;
                    this.addEdge(source3, target3, PhpUmlRelationships.INTERFACE_GENERALIZATION);
                }
                continue;
            }
            HashSet inters = new HashSet();
            ContainerUtil.addAll(inters, (Object[])phpClass.getImplementedInterfaces());
            ContainerUtil.addAll(inters, (Object[])phpClass.getTraits());
            for (PhpClass cur = phpClass.getSuperClass(); cur != null && this.findNode((PsiElement)cur) == null; cur = cur.getSuperClass()) {
                ContainerUtil.addAll(inters, (Object[])cur.getImplementedInterfaces());
            }
            ArrayList faces = new ArrayList(inters);
            while (!faces.isEmpty()) {
                Object inter;
                inter = (PhpClass)faces.get(0);
                if (this.findNode((PsiElement)inter) != null) {
                    source = this.findNode((PsiElement)phpClass);
                    target = this.findNode((PsiElement)inter);
                    if (source != null && target != null && source != target) {
                        this.addEdge(source, target, inter.isTrait() ? PhpUmlRelationships.INCLUDE : PhpUmlRelationships.REALIZATION);
                    }
                    faces.remove(inter);
                    continue;
                }
                faces.remove(inter);
                ContainerUtil.addAll(faces, (Object[])inter.getImplementedInterfaces());
            }
        }
        PhpUmlDataModel.mergeWithBackup(this.myNodes, this.myNodesOld);
        PhpUmlDataModel.mergeWithBackup(this.myEdges, this.myEdgesOld);
        PhpUmlDataModel.mergeWithBackup(this.myDependencyEdges, this.myDependencyEdgesOld);
    }

    public void addEdge(DiagramNode<PsiElement> from, DiagramNode<PsiElement> to, DiagramRelationshipInfo relationship) {
        PhpUmlDataModel.addEdge(from, to, relationship, this.myEdges);
    }

    private Set<PhpClass> getAllClasses() {
        HashSet<PhpClass> classes = new HashSet<PhpClass>();
        for (SmartPsiElementPointer<PhpClass> pointer : this.classesAddedByUser.values()) {
            classes.add((PhpClass)pointer.getElement());
        }
        classes.remove(null);
        HashSet<PhpClass> temp = new HashSet<PhpClass>();
        classes.remove(null);
        for (PhpClass phpClass : classes) {
            if (phpClass.isValid()) continue;
            temp.add(phpClass);
        }
        for (SmartPsiElementPointer smartPsiElementPointer : this.classesRemovedByUser.values()) {
            classes.remove(smartPsiElementPointer.getElement());
        }
        classes.removeAll(temp);
        return classes;
    }

    @Nullable
    public DiagramNode<PsiElement> findNode(PsiElement psiElement) {
        for (DiagramNode<PsiElement> node : this.myNodes) {
            PsiElement identifyingElement = (PsiElement)node.getIdentifyingElement();
            String fqn = PhpUmlUtil.getFQN(identifyingElement);
            if (fqn == null || !fqn.equals(PhpUmlUtil.getFQN(psiElement))) continue;
            return node;
        }
        SmartPsiElementPointer<PsiDirectory> ptr = this.directoriesAddedByUser.get(PhpUmlUtil.getFQN(psiElement));
        return ptr == null || ptr.getElement() == psiElement ? null : this.findNode(ptr.getElement());
    }

    public boolean contains(PhpClass phpClass) {
        return this.findNode((PsiElement)phpClass) != null;
    }

    public void dispose() {
    }

    public void removeElement(PsiElement psiElement) {
        if (psiElement instanceof PhpClass) {
            this.removeClass((PhpClass)psiElement);
        } else if (psiElement instanceof PsiDirectory) {
            this.removeDirectory((PsiDirectory)psiElement);
        }
    }

    private void removeClass(PhpClass phpClass) {
        DiagramNode<PsiElement> node = this.findNode((PsiElement)phpClass);
        if (node == null) {
            this.classesAddedByUser.remove(phpClass.getFQN());
            return;
        }
        ArrayList<DiagramEdge<PsiElement>> edges = new ArrayList<DiagramEdge<PsiElement>>();
        for (DiagramEdge<PsiElement> edge : this.myEdges) {
            if (edge.getTarget() != node && edge.getSource() != node) continue;
            edges.add(edge);
        }
        this.myEdges.removeAll(edges);
        this.myNodes.remove(node);
        this.classesRemovedByUser.put(phpClass.getFQN(), (SmartPsiElementPointer<PhpClass>)this.spManager.createSmartPsiElementPointer((PsiElement)phpClass));
        this.classesAddedByUser.remove(phpClass.getFQN());
    }

    private void removeDirectory(PsiDirectory directory) {
        DiagramNode<PsiElement> node = this.findNode((PsiElement)directory);
        if (node == null) {
            this.directoriesAddedByUser.remove(PhpUmlUtil.getFQN((PsiElement)directory));
            return;
        }
        this.myNodes.remove(node);
        this.directoriesAddedByUser.remove(PhpUmlUtil.getFQN((PsiElement)directory));
    }

    public boolean hasElement(@Nullable PsiElement element) {
        return element != null && this.findNode(element) != null;
    }

    @Nullable
    public DiagramNode<PsiElement> addElement(@Nullable PsiElement psiElement) {
        if (this.findNode(psiElement) != null) {
            return null;
        }
        if (psiElement instanceof PhpClass) {
            return this.addElement((PhpClass)psiElement);
        }
        if (psiElement instanceof PhpFile) {
            for (PhpClass it : PhpPsiUtil.findAllClasses((PhpFile)psiElement)) {
                this.addElement(it);
                Set<PhpClass> parents = PhpUmlDataModel.getAllParentsForClass(it);
                for (PhpClass parent : parents) {
                    this.addElement(parent);
                }
            }
        } else if (psiElement instanceof PsiDirectory) {
            String fqn = PhpUmlUtil.getFQN(psiElement);
            this.directoriesAddedByUser.put(fqn, (SmartPsiElementPointer<PsiDirectory>)this.spManager.createSmartPsiElementPointer((PsiElement)((PsiDirectory)psiElement)));
        }
        return null;
    }

    @Nullable
    public DiagramNode<PsiElement> addElement(PhpClass phpClass) {
        if (this.findNode((PsiElement)phpClass) != null) {
            return null;
        }
        SmartPsiElementPointer pointer = this.spManager.createSmartPsiElementPointer((PsiElement)phpClass);
        String fqn = phpClass.getFQN();
        this.classesAddedByUser.put(fqn, (SmartPsiElementPointer<PhpClass>)pointer);
        this.classesRemovedByUser.remove(fqn);
        return new PhpUmlNode((PsiElement)phpClass, (DiagramProvider<PsiElement>)this.getProvider());
    }

    public boolean isPsiListener() {
        return true;
    }

    public DiagramEdge<PsiElement> createEdge(@NotNull DiagramNode<PsiElement> from, @NotNull DiagramNode<PsiElement> to) {
        String commandName;
        DiagramRelationshipInfo relationship;
        if (from == null) {
            PhpUmlDataModel.$$$reportNull$$$0(11);
        }
        if (to == null) {
            PhpUmlDataModel.$$$reportNull$$$0(12);
        }
        String[] errorHolder = new String[1];
        PhpClass fromClass = (PhpClass)from.getIdentifyingElement();
        PhpClass toClass = (PhpClass)to.getIdentifyingElement();
        PhpClass parent = (PhpClass)to.getIdentifyingElement();
        PhpClass child = (PhpClass)from.getIdentifyingElement();
        if (parent.isInterface()) {
            relationship = child.isInterface() ? PhpUmlRelationships.INTERFACE_GENERALIZATION : PhpUmlRelationships.REALIZATION;
            commandName = PhpBundle.message("0.1.choice.0.extends.1.implements.2", fromClass.getName(), child.isInterface() ? 0 : 1, toClass.getName());
        } else {
            if (fromClass.isEquivalentTo((PsiElement)toClass)) {
                return null;
            }
            relationship = PhpUmlRelationships.GENERALIZATION;
            commandName = PhpBundle.message("0.extends.1", fromClass.getName(), toClass.getName());
        }
        Callable<PhpUmlEdge> callable = () -> {
            try {
                errorHolder[0] = PhpUmlUtil.createInheritanceBetween(fromClass, toClass);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (errorHolder[0] != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new Exception(errorHolder[0]);
                }
                Messages.showErrorDialog((Project)((PsiElement)from.getIdentifyingElement()).getProject(), (String)errorHolder[0], (String)PhpBundle.message("error.cant.create.edge", new Object[0]));
                return null;
            }
            PhpUmlEdge edge = new PhpUmlEdge(from, to, relationship);
            this.myEdges.add((DiagramEdge<PsiElement>)edge);
            this.getBuilder().queryUpdate().withDataReload().withPresentationUpdate().run();
            PhpAddMethodStubsQuickFix.addMethodStubs(child.getProject(), child, PhpAddMethodStubsQuickFix.getAbstractMethodsFromSuperClass(child).values());
            return edge;
        };
        return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)commandName, null, (PsiElement[])new PsiElement[]{((PsiElement)from.getIdentifyingElement()).getContainingFile()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 6, 7, 8, 9, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/uml/PhpUmlDataModel";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/uml/PhpUmlDataModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collapseNode";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 6, 7, 8, 9, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

