/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.uml.PhpUmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUmlElementManager
extends AbstractDiagramElementManager<PsiElement> {
    private static SimpleColoredText getClassPresentableName(PhpClass phpClass) {
        SimpleColoredText text = new SimpleColoredText();
        TextAttributesKey attributes = phpClass.isInterface() ? PhpHighlightingData.INTERFACE : PhpHighlightingData.CLASS;
        PhpUmlUtil.appendColored(text, attributes, phpClass.getName());
        return text.derive(PhpUmlElementManager.getCommonStyleAttributes((PsiElement)phpClass), false);
    }

    private static SimpleColoredText getMethodPresentableName(Method method) {
        return PhpUmlElementManager.getMethodSignature(method).derive(PhpUmlElementManager.getCommonStyleAttributes(method), false);
    }

    private static SimpleColoredText getFieldPresentableName(@NotNull Field field) {
        if (field == null) {
            PhpUmlElementManager.$$$reportNull$$$0(0);
        }
        SimpleColoredText text = new SimpleColoredText();
        TextAttributesKey attributes = field.getModifier().isStatic() ? PhpHighlightingData.STATIC_FIELD : (field.getModifier().isPrivate() ? PhpHighlightingData.PRIVATE_INSTANCE_FIELD : (field.getModifier().isProtected() ? PhpHighlightingData.PROTECTED_INSTANCE_FIELD : PhpHighlightingData.INSTANCE_FIELD));
        PhpUmlUtil.appendColored(text, attributes, field.getName());
        return text.derive(PhpUmlElementManager.getCommonStyleAttributes(field), false);
    }

    private static SimpleColoredText getDirectoryPresentableName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpUmlElementManager.$$$reportNull$$$0(1);
        }
        return new SimpleColoredText(directory.getName(), PhpUmlElementManager.getCommonStyleAttributes((PsiElement)directory));
    }

    @NotNull
    private static SimpleColoredText getMethodSignature(@NotNull Method method) {
        if (method == null) {
            PhpUmlElementManager.$$$reportNull$$$0(2);
        }
        SimpleColoredText signature = new SimpleColoredText();
        PhpUmlUtil.appendColored(signature, PhpHighlightingData.FUNCTION, method.getName());
        PhpUmlUtil.appendColored(signature, PhpHighlightingData.PARENTHESES, "(", 1);
        Parameter[] parameters = method.getParameters();
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            Parameter param = parameters[i];
            PhpUmlUtil.appendColored(signature, PhpHighlightingData.PARAMETER, param.getName());
            if (i == parameters.length - 1) continue;
            PhpUmlUtil.appendColored(signature, PhpHighlightingData.COMMA, ", ", 1);
        }
        PhpUmlUtil.appendColored(signature, PhpHighlightingData.PARENTHESES, ")", 1);
        SimpleColoredText simpleColoredText = signature;
        if (simpleColoredText == null) {
            PhpUmlElementManager.$$$reportNull$$$0(3);
        }
        return simpleColoredText;
    }

    @NotNull
    private static SimpleTextAttributes getCommonStyleAttributes(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpUmlElementManager.$$$reportNull$$$0(4);
        }
        return new SimpleTextAttributes(PhpUmlElementManager.getCommonStyleFor(psiElement), null);
    }

    @SimpleTextAttributes.StyleAttributeConstant
    private static int getCommonStyleFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpUmlElementManager.$$$reportNull$$$0(5);
        }
        int style = 0;
        if (!psiElement.isPhysical()) {
            style |= 2;
        }
        return style;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof PhpClass || element instanceof PsiDirectory;
    }

    @Nullable
    public PsiElement findInDataContext(@NotNull DataContext context) {
        Collection<PhpClass> classes;
        if (context == null) {
            PhpUmlElementManager.$$$reportNull$$$0(6);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        if (element instanceof PhpClass) {
            return element;
        }
        if (element instanceof PsiDirectory && PhpUmlElementManager.containsPhpFiles((PsiDirectory)element)) {
            return element;
        }
        if (element instanceof PhpFile && (classes = PhpPsiUtil.findAllClasses((PhpFile)element)).size() > 0) {
            return (PsiElement)classes.iterator().next();
        }
        return null;
    }

    private static boolean containsPhpFiles(@NotNull PsiDirectory element) {
        if (element == null) {
            PhpUmlElementManager.$$$reportNull$$$0(7);
        }
        return !DumbService.isDumb((Project)element.getProject()) && FileTypeIndex.containsFileOfType((FileType)PhpFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)element, (boolean)true));
    }

    @NotNull
    public Collection<PsiElement> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            PhpUmlElementManager.$$$reportNull$$$0(8);
        }
        ArrayList<PsiElement> classes = new ArrayList<PsiElement>();
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements != null) {
            for (PsiElement file : elements) {
                if (!(file instanceof PhpFile)) continue;
                classes.addAll(PhpPsiUtil.findAllClasses((PhpFile)file));
            }
        }
        ArrayList<PsiElement> arrayList = classes;
        if (arrayList == null) {
            PhpUmlElementManager.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public PsiElement @NotNull [] getNodeItems(PsiElement psiElement) {
        if (psiElement instanceof PhpClass) {
            ArrayList elements = new ArrayList();
            if (!psiElement.isValid()) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    PhpUmlElementManager.$$$reportNull$$$0(10);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            ContainerUtil.addAll(elements, (Object[])((PhpClass)psiElement).getOwnFields());
            ContainerUtil.addAll(elements, (Object[])((PhpClass)psiElement).getOwnMethods());
            PsiElement[] psiElementArray = elements.isEmpty() ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray(elements);
            if (psiElementArray == null) {
                PhpUmlElementManager.$$$reportNull$$$0(11);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            PhpUmlElementManager.$$$reportNull$$$0(12);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean canCollapse(PsiElement element) {
        return super.canCollapse((Object)element);
    }

    public boolean isContainerFor(PsiElement container, PsiElement element) {
        return super.isContainerFor((Object)container, (Object)element);
    }

    @Nullable
    public String getElementTitle(PsiElement element) {
        if (element instanceof PhpClass) {
            return ((PhpClass)element).getName();
        }
        return ((PsiDirectory)element).getName();
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable PsiElement nodeElement, @Nullable Object nodeItem, @NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            PhpUmlElementManager.$$$reportNull$$$0(13);
        }
        if (nodeItem instanceof Method) {
            return PhpUmlElementManager.getMethodPresentableName((Method)nodeItem);
        }
        if (nodeItem instanceof Field) {
            return PhpUmlElementManager.getFieldPresentableName((Field)nodeItem);
        }
        if (nodeItem instanceof PhpClass) {
            return PhpUmlElementManager.getClassPresentableName((PhpClass)nodeItem);
        }
        if (nodeItem instanceof PsiDirectory) {
            return PhpUmlElementManager.getDirectoryPresentableName((PsiDirectory)nodeItem);
        }
        return null;
    }

    @Nullable
    @Nls
    public String getNodeTooltip(PsiElement element) {
        if (element instanceof PsiDirectory) {
            ItemPresentation presentation = PhpPresentationUtil.getDirectoryPresentation((PsiDirectory)element);
            return presentation.getPresentableText() + " " + presentation.getLocationString();
        }
        return "";
    }

    @Nullable
    @Nls
    public String getEditorTitle(PsiElement element, @NotNull Collection<PsiElement> additionalElements) {
        PsiDirectory dir;
        if (additionalElements == null) {
            PhpUmlElementManager.$$$reportNull$$$0(14);
        }
        if (additionalElements.size() > 0 && (dir = element instanceof PsiDirectory ? (PsiDirectory)element.getParent() : element.getContainingFile().getParent()) != null) {
            return PhpBundle.message("display.name.directory.0", dir.getName());
        }
        return super.getEditorTitle((Object)element, additionalElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/uml/PhpUmlElementManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/uml/PhpUmlElementManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFieldPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignature";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommonStyleAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommonStyleFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsPhpFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

