/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUmlUtil {
    private PhpUmlUtil() {
    }

    @Nullable
    public static String createInheritanceBetween(PhpClass child, PhpClass parent) throws IncorrectOperationException {
        if (PhpUmlUtil.isInheritor(parent, child) || PhpUmlUtil.isInheritor(child, parent)) {
            return PhpBundle.message("relationship.already.exists", child.getName(), parent.getName());
        }
        if (child.isFinal()) {
            return PhpBundle.message("final.class.cant.be.inherited", parent.getName());
        }
        ClassReference ref = PhpPsiElementFactory.createClassReference(child.getProject(), parent.getName());
        if (parent.isInterface()) {
            PhpExtractInterfaceProcessor.addImplementClause(child.getProject(), child, parent.getName());
        } else {
            if (child.isInterface()) {
                return PhpBundle.message("node.is.interface", new Object[0]);
            }
            PhpLangUtil.addExtendsClause(child, ref.getText());
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)child);
        if (scopeForUseOperator != null && PhpCodeInsightUtil.canImport(scopeForUseOperator, parent.getFQN(), PhpGroupUseElement.PhpUseKeyword.CLASS)) {
            PhpAliasImporter.insertUseStatementWithKeyword(null, parent.getFQN(), null, scopeForUseOperator);
        }
        return null;
    }

    private static void replacePrevWhiteSpace(ImplementsList list) {
        PsiElement whiteSpace = list.getPrevSibling();
        if (whiteSpace instanceof PsiWhiteSpace) {
            whiteSpace.replace((PsiElement)PhpPsiElementFactory.createWhiteSpace(list.getProject()));
        } else if (whiteSpace instanceof ExtendsList) {
            whiteSpace.getPrevSibling().replace((PsiElement)PhpPsiElementFactory.createWhiteSpace(list.getProject()));
        }
    }

    private static boolean isInheritor(PhpClass parent, PhpClass child) {
        if (parent == child) {
            return false;
        }
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperClasses(child, false, true, (Processor<? super PhpClass>)((Processor)aClass -> {
            if (aClass.isEquivalentTo((PsiElement)parent)) {
                result.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)result.get();
    }

    @Nullable
    @NlsSafe
    public static String getFQN(@NotNull PsiElement element) {
        if (element == null) {
            PhpUmlUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof PhpClass) {
            return ((PhpClass)element).getFQN();
        }
        if (element instanceof PsiDirectory) {
            return ((PsiDirectory)element).getVirtualFile().getPath();
        }
        return null;
    }

    public static PsiDirectory getDirectory(PsiElement element) {
        return element.getContainingFile().getParent();
    }

    @NotNull
    public static TextAttributes resolveTextAttributes(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            PhpUmlUtil.$$$reportNull$$$0(1);
        }
        TextAttributes textAttributes = EditorColorsUtil.getGlobalOrDefaultColorScheme().getAttributes(attributesKey);
        if (textAttributes == null) {
            PhpUmlUtil.$$$reportNull$$$0(2);
        }
        return textAttributes;
    }

    @NotNull
    public static SimpleTextAttributes getAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            PhpUmlUtil.$$$reportNull$$$0(3);
        }
        if (DiagramConfiguration.getInstance().doNodeItemSyntaxHighlighting()) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
            if (simpleTextAttributes == null) {
                PhpUmlUtil.$$$reportNull$$$0(4);
            }
            return simpleTextAttributes;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            PhpUmlUtil.$$$reportNull$$$0(5);
        }
        return simpleTextAttributes;
    }

    @NotNull
    public static SimpleTextAttributes getAttributes(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            PhpUmlUtil.$$$reportNull$$$0(6);
        }
        if (DiagramConfiguration.getInstance().doNodeItemSyntaxHighlighting()) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)PhpUmlUtil.resolveTextAttributes(attributesKey));
            if (simpleTextAttributes == null) {
                PhpUmlUtil.$$$reportNull$$$0(7);
            }
            return simpleTextAttributes;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            PhpUmlUtil.$$$reportNull$$$0(8);
        }
        return simpleTextAttributes;
    }

    public static void appendColored(@NotNull SimpleColoredText text, @NotNull TextAttributesKey attributesKey, @NotNull String fragment) {
        if (text == null) {
            PhpUmlUtil.$$$reportNull$$$0(9);
        }
        if (attributesKey == null) {
            PhpUmlUtil.$$$reportNull$$$0(10);
        }
        if (fragment == null) {
            PhpUmlUtil.$$$reportNull$$$0(11);
        }
        text.append(fragment, PhpUmlUtil.getAttributes(attributesKey));
    }

    public static void appendColored(@NotNull SimpleColoredText text, @NotNull TextAttributesKey attributesKey, @NotNull String fragment, @SimpleTextAttributes.StyleAttributeConstant int deriveStyle) {
        if (text == null) {
            PhpUmlUtil.$$$reportNull$$$0(12);
        }
        if (attributesKey == null) {
            PhpUmlUtil.$$$reportNull$$$0(13);
        }
        if (fragment == null) {
            PhpUmlUtil.$$$reportNull$$$0(14);
        }
        text.append(fragment, PhpUmlUtil.getAttributes(attributesKey).derive(deriveStyle, null, null, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/uml/PhpUmlUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/uml/PhpUmlUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTextAttributes";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFQN";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveTextAttributes";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendColored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

