/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.pathmapper;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.util.PhpStringUtil;
import com.jetbrains.php.util.pathmapper.PhpEmptyPathMapper;
import com.jetbrains.php.util.pathmapper.PhpIdenticalPathMapper;
import com.jetbrains.php.util.pathmapper.PhpLocalPathMapper;
import com.jetbrains.php.util.pathmapper.PhpRemotePathMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpPathMapper {
    public static PhpPathMapper create(@NotNull Project project) {
        if (project == null) {
            PhpPathMapper.$$$reportNull$$$0(0);
        }
        return new PhpLocalPathMapper(project);
    }

    public static PhpPathMapper createDefaultMapper() {
        return new PhpIdenticalPathMapper();
    }

    public static PhpPathMapper create(@NotNull PhpServer server) {
        if (server == null) {
            PhpPathMapper.$$$reportNull$$$0(1);
        }
        return new PhpRemotePathMapper(server);
    }

    public static PhpPathMapper create(@NotNull List<PathMappingSettings.PathMapping> mapping) {
        if (mapping == null) {
            PhpPathMapper.$$$reportNull$$$0(2);
        }
        return new PhpRemotePathMapper(mapping);
    }

    public static PhpPathMapper create() {
        return PhpEmptyPathMapper.EMPTY_PATH_MAPPER;
    }

    @Nullable
    public abstract String getRemoteFilePath(@NotNull String var1);

    @Nullable
    public final String getRemoteFilePath(@NotNull VirtualFile localFile) {
        if (localFile == null) {
            PhpPathMapper.$$$reportNull$$$0(3);
        }
        return this.getRemoteFilePath(localFile.getUrl());
    }

    @Nullable
    public abstract String getLocalPath(@NotNull String var1);

    @Nullable
    public abstract VirtualFile getLocalFile(@NotNull String var1);

    @NotNull
    public static String createFilePath(String @NotNull [] localSegmentedPath) {
        if (localSegmentedPath == null) {
            PhpPathMapper.$$$reportNull$$$0(4);
        }
        return PhpPathMapper.createFilePath(localSegmentedPath, localSegmentedPath.length);
    }

    @NotNull
    public static String createFilePath(String @NotNull [] localSegmentedPath, int length) {
        if (localSegmentedPath == null) {
            PhpPathMapper.$$$reportNull$$$0(5);
        }
        if (length > 0) {
            boolean isWindows = FileUtil.isWindowsAbsolutePath((String)localSegmentedPath[0]);
            String separator = isWindows ? "\\" : "/";
            String path = StringUtil.join((String[])localSegmentedPath, (int)0, (int)length, (String)separator);
            Object object = !isWindows ? separator + path : path;
            if (object == null) {
                PhpPathMapper.$$$reportNull$$$0(6);
            }
            return object;
        }
        return "/";
    }

    public static String @NotNull [] getPath(@NotNull String originalPath) {
        if (originalPath == null) {
            PhpPathMapper.$$$reportNull$$$0(7);
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(originalPath, "/\\");
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (segment.length() <= 0) continue;
            paths.add(segment);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(paths);
        if (stringArray == null) {
            PhpPathMapper.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    public static String @NotNull [] intersectFromEnd(@NotNull String path1, @NotNull String path2, boolean caseSensitive) {
        if (path1 == null) {
            PhpPathMapper.$$$reportNull$$$0(9);
        }
        if (path2 == null) {
            PhpPathMapper.$$$reportNull$$$0(10);
        }
        String[] stringArray = PhpStringUtil.intersectFromEnd(PhpPathMapper.getPath(path1), PhpPathMapper.getPath(path2), caseSensitive);
        if (stringArray == null) {
            PhpPathMapper.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @NotNull
    public static String urlToPath(@NotNull String fileUriOrPath) {
        if (fileUriOrPath == null) {
            PhpPathMapper.$$$reportNull$$$0(12);
        }
        return PhpPathMapper.createFilePath(PhpPathMapper.getPath(VirtualFileManager.extractPath((String)fileUriOrPath)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSegmentedPath";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/pathmapper/PhpPathMapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUriOrPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/pathmapper/PhpPathMapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectFromEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteFilePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "intersectFromEnd";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "urlToPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 11 -> new IllegalStateException(string);
        };
    }
}

