/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.smarty.SmartyBundle;
import com.jetbrains.smarty.SmartyCompletionContributor;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.lexer.SmartyLexer;
import com.jetbrains.smarty.lang.parser.SmartyExpressionParser;
import com.jetbrains.smarty.lang.psi.SmartyCompositeElementTypes;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SmartyTagsParser
implements PsiParser {
    private final Stack<Tag> myNonUniqueFunctionsStack = new Stack();
    private final Project myProject;

    public SmartyTagsParser(Project project) {
        this.myProject = project;
    }

    public void clearStack() {
        this.closeMarkersForUnclosedTags();
    }

    public void parseOneSmartyTagInInnerConstruction(PsiBuilder builder2, boolean clearStack) {
        if (builder2.getTokenType() == SmartyTokenTypes.START_TAG_START) {
            this.parseOpenTag(builder2);
        } else if (builder2.getTokenType() == SmartyTokenTypes.END_TAG_START) {
            this.parseCloseTag(builder2);
        }
        if (clearStack) {
            this.closeMarkersForUnclosedTags();
        }
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        while (!builder2.eof()) {
            if (builder2.getTokenType() == SmartyTokenTypes.START_TAG_START) {
                this.parseOpenTag(builder2);
                continue;
            }
            if (builder2.getTokenType() == SmartyTokenTypes.END_TAG_START) {
                this.parseCloseTag(builder2);
                continue;
            }
            builder2.advanceLexer();
        }
        this.closeMarkersForUnclosedTags();
        marker.done(root);
        ASTNode aSTNode = builder2.getTreeBuilt();
        if (aSTNode == null) {
            SmartyTagsParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private void closeMarkersForUnclosedTags() {
        while (!this.myNonUniqueFunctionsStack.empty()) {
            Tag openTag = (Tag)this.myNonUniqueFunctionsStack.pop();
            if (!SmartyCompletionContributor.isPredefinedFunction(openTag.getName())) {
                openTag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(openTag), openTag.getMarkerOfContent());
            } else {
                openTag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(openTag), openTag.myMarkerOfContent, SmartyBundle.message("parsing.error.tag.is.not.closed", new Object[0]));
            }
            openTag.getMarkerOfContent().drop();
        }
    }

    private String parseOpenTag(PsiBuilder builder2) {
        assert (builder2.getTokenType() == SmartyTokenTypes.START_TAG_START);
        boolean pushIntoStack = false;
        String functionName = "";
        PsiBuilder.Marker startTagMarker = builder2.mark();
        builder2.advanceLexer();
        boolean parseExpression = true;
        if (builder2.getTokenType() == SmartyTokenTypes.PREDEFINED_FUNCTION) {
            functionName = builder2.getTokenText();
            boolean bl = pushIntoStack = !SmartyCompletionContributor.isPredefinedFunction(functionName) || !SmartyCompletionContributor.isUnique(functionName);
            if (!"if".equals(functionName) && !"elseif".equals(functionName)) {
                parseExpression = false;
                if ("for".equals(functionName)) {
                    SmartyTagsParser.parseForTag(builder2);
                } else if ("foreach".equals(functionName)) {
                    PsiBuilder.Marker marker = builder2.mark();
                    boolean parseFunction = false;
                    builder2.advanceLexer();
                    if (builder2.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
                        builder2.advanceLexer();
                        if (builder2.getTokenType() == SmartyTokenTypes.EQ) {
                            marker.rollbackTo();
                            SmartyTagsParser.parseFunctionTagInner(functionName, builder2);
                            parseFunction = true;
                        }
                    }
                    if (!parseFunction) {
                        marker.rollbackTo();
                        if (builder2.getTokenType() == SmartyTokenTypes.PREDEFINED_FUNCTION) {
                            builder2.advanceLexer();
                            SmartyTagsParser.parseForEachTagInner(builder2);
                        }
                    }
                } else if ("while".equals(functionName)) {
                    SmartyTagsParser.parseWhileTag(builder2);
                } else {
                    SmartyTagsParser.parseFunctionTagInner(functionName, builder2);
                }
            } else {
                builder2.advanceLexer();
            }
        } else if (builder2.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
            PsiBuilder.Marker tagContentBeginMarker = builder2.mark();
            functionName = builder2.getTokenText();
            builder2.advanceLexer();
            if (builder2.getTokenType() == SmartyTokenTypes.COLON_COLON || builder2.getTokenType() == SmartyTokenTypes.L_PAR || builder2.getTokenType() == SmartyTokenTypes.ARROW || builder2.getTokenType() == SmartyTokenTypes.BACK_SLASH) {
                tagContentBeginMarker.rollbackTo();
                if (!SmartyExpressionParser.parseExpressionOrAssignment(builder2)) {
                    builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
                } else {
                    SmartyTagsParser.parseFlag("nocache", builder2);
                }
                parseExpression = false;
                functionName = null;
            } else {
                tagContentBeginMarker.drop();
                SmartyTagsParser.parseModifiers(builder2);
                while (!builder2.eof() && builder2.getTokenType() != SmartyTokenTypes.TAG_END) {
                    if (builder2.getTokenType() == SmartyTokenTypes.DOUBLE_QUOTE) {
                        SmartyExpressionParser.parseDoubleQuotedString(builder2);
                        continue;
                    }
                    builder2.advanceLexer();
                }
                parseExpression = false;
                pushIntoStack = true;
            }
        }
        if (parseExpression && !SmartyExpressionParser.parseExpressionOrAssignment(builder2)) {
            builder2.error(SmartyBundle.message("parsing.error.empty.tag", new Object[0]));
        } else if (parseExpression) {
            SmartyTagsParser.parseScope(builder2);
            while (SmartyTagsParser.parseFlag("nocache", builder2) || SmartyTagsParser.parseFlag("nofilter", builder2)) {
            }
        }
        if (builder2.getTokenType() != SmartyTokenTypes.TAG_END && builder2.getTokenType() != SmartyTokenTypes.OR) {
            builder2.error(SmartyBundle.message("parsing.error.right.curly.brace.expected", SmartyLexer.getRightDelimiter(this.myProject)));
        } else {
            builder2.advanceLexer();
        }
        if (pushIntoStack) {
            this.myNonUniqueFunctionsStack.push((Object)new Tag(functionName != null ? functionName : "", startTagMarker, builder2.mark()));
        } else if ("include".equals(functionName)) {
            startTagMarker.done(SmartyCompositeElementTypes.INCLUDE_TAG);
        } else if ("config_load".equals(functionName)) {
            startTagMarker.done(SmartyCompositeElementTypes.CONFIG_LOAD_TAG);
        } else {
            startTagMarker.done(SmartyCompositeElementTypes.TAG);
        }
        return functionName != null ? functionName : "";
    }

    private static boolean parseFlag(String flagName, PsiBuilder builder2) {
        if (flagName.equals(builder2.getTokenText())) {
            builder2.advanceLexer();
            if (builder2.getTokenType() == SmartyTokenTypes.EQ) {
                builder2.advanceLexer();
                if (builder2.getTokenType() == SmartyTokenTypes.BOOLEAN_VALUE) {
                    builder2.advanceLexer();
                } else {
                    builder2.error(SmartyBundle.message("parsing.value.expected", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    private static void parseScope(PsiBuilder builder2) {
        if ("scope".equals(builder2.getTokenText())) {
            builder2.advanceLexer();
            if (builder2.getTokenType() == SmartyTokenTypes.EQ) {
                builder2.advanceLexer();
                if (!SmartyExpressionParser.parseVariable(builder2)) {
                    builder2.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
                }
            } else {
                builder2.error(SmartyBundle.message("parsing.value.expected", new Object[0]));
            }
        }
    }

    private static void parseForEachTagInner(PsiBuilder builder2) {
        SmartyExpressionParser.parseVariable(builder2);
        if (builder2.getTokenType() == SmartyTokenTypes.AS_KEYWORD) {
            builder2.advanceLexer();
        } else {
            builder2.error(SmartyBundle.message("parsing.error.as.expected", new Object[0]));
        }
        SmartyExpressionParser.parseVariableDefinition(builder2);
        if (builder2.getTokenType() == SmartyTokenTypes.ARRAY_ASSIGNMENT) {
            builder2.advanceLexer();
            SmartyExpressionParser.parseVariableDefinition(builder2);
        }
    }

    private static void parseWhileTag(PsiBuilder builder2) {
        builder2.advanceLexer();
        SmartyExpressionParser.parseExpressionOrAssignment(builder2);
    }

    private static void parseForTag(PsiBuilder builder2) {
        int offset = builder2.getCurrentOffset();
        builder2.advanceLexer();
        boolean isForComplete = false;
        int numberOfAssignments = 0;
        boolean start = true;
        PsiBuilder.Marker mark = builder2.mark();
        do {
            if (!start) {
                builder2.advanceLexer();
            }
            SmartyExpressionParser.parseExpressionOrAssignment(builder2);
            if (builder2.getCurrentOffset() == offset) break;
            ++numberOfAssignments;
            start = false;
        } while (builder2.getTokenType() == SmartyTokenTypes.COMMA);
        if (builder2.getTokenType() != SmartyTokenTypes.TO_KEYWORD || numberOfAssignments != 1) {
            mark.drop();
        }
        if (builder2.getTokenType() == SmartyTokenTypes.TO_KEYWORD) {
            if (numberOfAssignments == 1) {
                mark.rollbackTo();
                if (!SmartyExpressionParser.parseDefinitionAndAssignment(builder2)) {
                    SmartyExpressionParser.parseExpressionOrAssignment(builder2);
                }
            }
            builder2.advanceLexer();
            if (!builder2.eof() && builder2.getTokenType() != SmartyTokenTypes.TAG_END) {
                SmartyExpressionParser.parseExpressionOrAssignment(builder2);
                isForComplete = true;
                if (builder2.getTokenType() == SmartyTokenTypes.STEP_KEYWORD) {
                    builder2.advanceLexer();
                    if (!builder2.eof() && builder2.getTokenType() != SmartyTokenTypes.TAG_END) {
                        SmartyExpressionParser.parseExpressionOrAssignment(builder2);
                    }
                }
            }
        } else if (builder2.getTokenType() == SmartyTokenTypes.SEMICOLON) {
            builder2.advanceLexer();
            if (!builder2.eof() && builder2.getTokenType() != SmartyTokenTypes.TAG_END) {
                SmartyExpressionParser.parseExpressionOrAssignment(builder2);
                if (builder2.getTokenType() != SmartyTokenTypes.SEMICOLON) {
                    builder2.error(SmartyBundle.message("parsing.error.semicolon.expected", new Object[0]));
                } else {
                    builder2.advanceLexer();
                }
                if (!builder2.eof() && builder2.getTokenType() != SmartyTokenTypes.TAG_END) {
                    SmartyExpressionParser.parseExpressionOrAssignment(builder2);
                    isForComplete = true;
                }
            }
        }
        if (!isForComplete) {
            builder2.error(SmartyBundle.message("parsing.error.incomplete.expression", new Object[0]));
        }
        SmartyTagsParser.parseAttributeList("for", builder2);
    }

    public static void parseModifiers(PsiBuilder builder2) {
        while (builder2.getTokenType() == SmartyTokenTypes.OR) {
            PsiBuilder.Marker marker = builder2.mark();
            builder2.advanceLexer();
            if (builder2.getTokenType() == SmartyTokenTypes.SILENCE) {
                builder2.advanceLexer();
            }
            if (builder2.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
                builder2.error(SmartyBundle.message("parsing.error.identifier.expected", new Object[0]));
            } else {
                builder2.advanceLexer();
            }
            while (builder2.getTokenType() == SmartyTokenTypes.DOT_DOT) {
                builder2.advanceLexer();
                SmartyExpressionParser.parseVariable(builder2);
            }
            marker.done(SmartyCompositeElementTypes.MODIFIER);
        }
    }

    private void parseCloseTag(PsiBuilder builder2) {
        assert (builder2.getTokenType() == SmartyTokenTypes.END_TAG_START);
        builder2.advanceLexer();
        String functionName = "";
        if (builder2.getTokenType() == SmartyTokenTypes.PREDEFINED_FUNCTION || builder2.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
            functionName = builder2.getTokenText();
            builder2.advanceLexer();
        } else {
            builder2.error(SmartyBundle.message("parsing.error.function.name.expected", new Object[0]));
        }
        if (builder2.getTokenType() != SmartyTokenTypes.TAG_END) {
            builder2.error(SmartyBundle.message("parsing.error.right.curly.brace.expected", SmartyLexer.getRightDelimiter(this.myProject)));
        } else {
            builder2.advanceLexer();
        }
        boolean canParse = false;
        for (Tag t : this.myNonUniqueFunctionsStack) {
            if (!t.getName().equals(functionName)) continue;
            canParse = true;
            break;
        }
        if (canParse) {
            Tag tag = null;
            while (!this.myNonUniqueFunctionsStack.empty() && !(tag = (Tag)this.myNonUniqueFunctionsStack.pop()).getName().equals(functionName)) {
                if (!SmartyCompletionContributor.isPredefinedFunction(tag.getName())) {
                    tag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(tag), tag.getMarkerOfContent());
                } else {
                    tag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(tag), tag.myMarkerOfContent, SmartyBundle.message("parsing.error.tag.is.not.closed", new Object[0]));
                }
                tag.myMarkerOfContent.drop();
            }
            if (tag != null) {
                tag.getMarkerOfContent().drop();
                tag.getBeginMarker().done(SmartyTagsParser.getTagType(tag));
            }
        } else {
            builder2.error(SmartyBundle.message("parsing.error.no.open.tag.specified", new Object[0]));
        }
    }

    private static void parseFunctionTagInner(String functionName, PsiBuilder builder2) {
        if (builder2.getTokenType() != SmartyTokenTypes.PREDEFINED_FUNCTION && builder2.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
            return;
        }
        builder2.advanceLexer();
        SmartyTagsParser.parseModifiers(builder2);
        SmartyTagsParser.parseAttributeList(functionName, builder2);
    }

    private static void parseAttributeList(String functionName, PsiBuilder builder2) {
        if (builder2.getTokenType() == SmartyTokenTypes.TAG_END) {
            return;
        }
        Collection<SmartyCompletionContributor.Attribute> functionAttributes = SmartyCompletionContributor.getFunctionAttributes(functionName);
        int numberOfRequired = 0;
        for (SmartyCompletionContributor.Attribute attr : functionAttributes) {
            if (!attr.isIsRequired()) continue;
            ++numberOfRequired;
        }
        boolean isAssignmentFirst = false;
        PsiBuilder.Marker mark = builder2.mark();
        if (builder2.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
            builder2.advanceLexer();
            if (builder2.getTokenType() == SmartyTokenTypes.EQ) {
                mark.rollbackTo();
                SmartyTagsParser.parseAttribute(functionName, builder2);
                isAssignmentFirst = true;
            }
        }
        if (!isAssignmentFirst && numberOfRequired != 0) {
            mark.rollbackTo();
            for (int i = 0; i < numberOfRequired; ++i) {
                PsiBuilder.Marker attributeMarker = builder2.mark();
                if (!SmartyExpressionParser.parseVariable(builder2)) {
                    attributeMarker.drop();
                    break;
                }
                attributeMarker.done(SmartyCompositeElementTypes.ATTRIBUTE);
            }
        } else if (!isAssignmentFirst) {
            mark.drop();
        }
        while (SmartyTagsParser.parseAttribute(functionName, builder2)) {
        }
    }

    private static boolean parseAttribute(String functionName, PsiBuilder builder2) {
        if (builder2.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
            return false;
        }
        String attributeName = builder2.getTokenText();
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() != SmartyTokenTypes.EQ) {
            Set<String> flags = SmartyCompletionContributor.getFunctionFlags(functionName);
            for (String flag : flags) {
                if (!flag.equals(attributeName)) continue;
                if (builder2.getTokenType() == SmartyTokenTypes.EQ) {
                    marker.rollbackTo();
                    marker = builder2.mark();
                    SmartyTagsParser.parseFlag(flag, builder2);
                }
                marker.done(SmartyCompositeElementTypes.ATTRIBUTE);
                return false;
            }
            builder2.error(SmartyBundle.message("parsing.error.expected", new Object[0]));
        } else {
            builder2.advanceLexer();
            PsiBuilder.Marker valueMarker = builder2.mark();
            if (!SmartyExpressionParser.parseArrayDefinition(builder2)) {
                if (SmartyExpressionParser.parseExpression(builder2)) {
                    valueMarker.done(SmartyCompositeElementTypes.ATTRIBUTE_VALUE);
                } else {
                    valueMarker.drop();
                }
            } else {
                valueMarker.done(SmartyCompositeElementTypes.ATTRIBUTE_VALUE);
            }
        }
        marker.done(SmartyCompositeElementTypes.ATTRIBUTE);
        return true;
    }

    private static IElementType getTagType(@NotNull Tag tag) {
        if (tag == null) {
            SmartyTagsParser.$$$reportNull$$$0(1);
        }
        if ("literal".equalsIgnoreCase(tag.getName())) {
            return SmartyCompositeElementTypes.LITERAL_TAG;
        }
        return SmartyCompositeElementTypes.TAG;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTagType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class Tag {
        @NotNull
        private final String myName;
        private final PsiBuilder.Marker myBeginMarker;
        private final PsiBuilder.Marker myMarkerOfContent;

        private Tag(@NotNull String name, PsiBuilder.Marker beginMarker, PsiBuilder.Marker markerOfContent) {
            if (name == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myBeginMarker = beginMarker;
            this.myMarkerOfContent = markerOfContent;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Tag.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiBuilder.Marker getBeginMarker() {
            return this.myBeginMarker;
        }

        public PsiBuilder.Marker getMarkerOfContent() {
            return this.myMarkerOfContent;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag obj_tag = (Tag)obj;
            return this.myName.equals(obj_tag.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser$Tag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser$Tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

