/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.dql.queryBuilder;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.php.dql.lexer.DqlLexer;
import com.jetbrains.php.dql.psi.DqlElement;
import com.jetbrains.php.dql.psi.DqlFullyQualifiedName;
import com.jetbrains.php.dql.psi.DqlIdentificationVariable;
import com.jetbrains.php.dql.psi.DqlJoinAssociationPathExpression;
import com.jetbrains.php.dql.psi.DqlLiteral;
import com.jetbrains.php.dql.psi.DqlNamedParameter;
import com.jetbrains.php.dql.psi.DqlPositionalParameter;
import com.jetbrains.php.dql.psi.DqlStateField;
import com.jetbrains.php.dql.psi.DqlStateFieldPathExpression;
import com.jetbrains.php.dql.psi.impl.DqlRecursiveVisitor;
import com.jetbrains.php.dql.queryBuilder.DqlBuilderKt;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/php/dql/queryBuilder/DqlBuilderAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "addBackground", "Lcom/jetbrains/php/lang/psi/elements/StringLiteralExpression;", "processQuery", "highlightInfo", "range", "Lcom/intellij/openapi/util/TextRange;", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.dql"})
@SourceDebugExtension(value={"SMAP\nDqlBuilderAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DqlBuilderAnnotator.kt\ncom/jetbrains/php/dql/queryBuilder/DqlBuilderAnnotator\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,148:1\n66#2,2:149\n*S KotlinDebug\n*F\n+ 1 DqlBuilderAnnotator.kt\ncom/jetbrains/php/dql/queryBuilder/DqlBuilderAnnotator\n*L\n29#1:149,2\n*E\n"})
public final class DqlBuilderAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof StringLiteralExpression)) {
            return;
        }
        if (!DqlBuilderKt.getDqlBuilderStringLiteralPattern().accepts((Object)element)) {
            return;
        }
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        MethodReference methodReference = (MethodReference)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MethodReference.class, (boolean)true);
        if (methodReference == null) {
            return;
        }
        MethodReference calledMethod = methodReference;
        PsiElement[] psiElementArray = calledMethod.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getParameters(...)");
        int index = ArraysKt.indexOf((Object[])psiElementArray, (Object)element);
        String name = calledMethod.getName();
        if (index == 0 && Intrinsics.areEqual((Object)name, (Object)"setParameter")) {
            if (((StringLiteralExpression)element).getTextLength() < 3) {
                return;
            }
            TextRange range = new TextRange(((StringLiteralExpression)element).getTextRange().getStartOffset() + 1, ((StringLiteralExpression)element).getTextRange().getEndOffset() - 1);
            TextAttributesKey textAttributesKey = PhpHighlightingData.DQL_PLACEHOLDER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DQL_PLACEHOLDER");
            this.highlightInfo(holder, range, textAttributesKey);
            return;
        }
        if (index == 1 && Intrinsics.areEqual((Object)name, (Object)"from")) {
            if (((StringLiteralExpression)element).getTextLength() < 3) {
                return;
            }
            TextRange range = new TextRange(((StringLiteralExpression)element).getTextRange().getStartOffset() + 1, ((StringLiteralExpression)element).getTextRange().getEndOffset() - 1);
            TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"IDENTIFIER");
            this.highlightInfo(holder, range, textAttributesKey);
            this.addBackground((StringLiteralExpression)element, holder);
            return;
        }
        if (index == 1 && (Intrinsics.areEqual((Object)name, (Object)"orderBy") || Intrinsics.areEqual((Object)name, (Object)"addOrderBy")) && (Intrinsics.areEqual((Object)((StringLiteralExpression)element).getContents(), (Object)"ASC") || Intrinsics.areEqual((Object)((StringLiteralExpression)element).getContents(), (Object)"DESC"))) {
            TextRange range = new TextRange(((StringLiteralExpression)element).getTextRange().getStartOffset() + 1, ((StringLiteralExpression)element).getTextRange().getEndOffset() - 1);
            TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KEYWORD");
            this.highlightInfo(holder, range, textAttributesKey);
            return;
        }
        Set<Integer> declarationIndexes = DqlBuilderKt.getDqlBuilderMethodsAliasDeclarationsIndexes().get(name);
        if (declarationIndexes != null && declarationIndexes.contains(index)) {
            TextRange range = new TextRange(((StringLiteralExpression)element).getTextRange().getStartOffset() + 1, ((StringLiteralExpression)element).getTextRange().getEndOffset() - 1);
            TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"IDENTIFIER");
            this.highlightInfo(holder, range, textAttributesKey);
            this.addBackground((StringLiteralExpression)element, holder);
        }
        Set<Integer> set = DqlBuilderKt.getDqlBuilderMethodsQueryIndexes().get(name);
        if (set == null) {
            return;
        }
        Set<Integer> injectIndexes = set;
        if (!injectIndexes.contains(index)) {
            return;
        }
        this.processQuery((StringLiteralExpression)element, holder);
        this.addBackground((StringLiteralExpression)element, holder);
    }

    private final void addBackground(StringLiteralExpression element, AnnotationHolder holder) {
        TextRange range = new TextRange(element.getTextRange().getStartOffset() + 1, element.getTextRange().getEndOffset() - 1);
        TextAttributesKey textAttributesKey = PhpHighlightingData.DQL_EXPR;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DQL_EXPR");
        this.highlightInfo(holder, range, textAttributesKey);
    }

    private final void processQuery(StringLiteralExpression element, AnnotationHolder holder) {
        int shift = 23;
        PsiElement psiElement = DqlBuilderKt.parseDql(element);
        if (psiElement == null) {
            return;
        }
        PsiElement psi = psiElement;
        psi.accept((PsiElementVisitor)new DqlRecursiveVisitor(shift, element, this, holder){
            final /* synthetic */ int $shift;
            final /* synthetic */ StringLiteralExpression $element;
            final /* synthetic */ DqlBuilderAnnotator this$0;
            final /* synthetic */ AnnotationHolder $holder;
            {
                this.$shift = $shift;
                this.$element = $element;
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement el) {
                Intrinsics.checkNotNullParameter((Object)el, (String)"el");
                if (DqlLexer.getKeywordMap().containsKey(el.getText()) && PsiTreeUtilKt.getStartOffset((PsiElement)el) > this.$shift) {
                    TextRange textRange = DqlBuilderKt.getQueryElementTextRange(el).shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$element)));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                    TextRange range = textRange;
                    TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KEYWORD");
                    this.this$0.highlightInfo(this.$holder, range, textAttributesKey);
                }
            }

            public void visitFullyQualifiedName(DqlFullyQualifiedName el) {
                Intrinsics.checkNotNullParameter((Object)el, (String)"el");
                TextRange textRange = DqlBuilderKt.getQueryElementTextRange(el).shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$element)));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                TextRange range = textRange;
                TextAttributesKey textAttributesKey = PhpHighlightingData.CLASS;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CLASS");
                this.this$0.highlightInfo(this.$holder, range, textAttributesKey);
            }

            public void visitStateFieldPathExpression(DqlStateFieldPathExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                DqlIdentificationVariable dqlIdentificationVariable = o.getIdentificationVariable();
                Intrinsics.checkNotNullExpressionValue((Object)dqlIdentificationVariable, (String)"getIdentificationVariable(...)");
                DqlIdentificationVariable variable = dqlIdentificationVariable;
                DqlStateField dqlStateField = o.getStateField();
                Intrinsics.checkNotNullExpressionValue((Object)dqlStateField, (String)"getStateField(...)");
                DqlStateField field = dqlStateField;
                this.processVariableAndField(variable, field);
            }

            public void visitJoinAssociationPathExpression(DqlJoinAssociationPathExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                DqlIdentificationVariable dqlIdentificationVariable = o.getIdentificationVariable();
                Intrinsics.checkNotNullExpressionValue((Object)dqlIdentificationVariable, (String)"getIdentificationVariable(...)");
                DqlIdentificationVariable variable = dqlIdentificationVariable;
                DqlElement dqlElement = o.getCollectionValuedAssociationField();
                if (dqlElement == null || (dqlElement = dqlElement.getFieldIdentificationVariable()) == null) {
                    return;
                }
                DqlElement field = dqlElement;
                this.processVariableAndField(variable, field);
            }

            public void visitNamedParameter(DqlNamedParameter o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                TextRange textRange = o.getTextRange().shiftLeft(this.$shift).shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$element)));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                TextRange range = textRange;
                TextAttributesKey textAttributesKey = PhpHighlightingData.DQL_PLACEHOLDER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DQL_PLACEHOLDER");
                this.this$0.highlightInfo(this.$holder, range, textAttributesKey);
            }

            public void visitLiteral(DqlLiteral o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (o.getInteger() != null) {
                    TextRange textRange = o.getTextRange().shiftLeft(this.$shift).shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$element)));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                    TextRange range = textRange;
                    TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.NUMBER;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"NUMBER");
                    this.this$0.highlightInfo(this.$holder, range, textAttributesKey);
                }
            }

            public void visitPositionalParameter(DqlPositionalParameter param) {
                Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                TextRange textRange = param.getTextRange().shiftLeft(this.$shift).shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$element)));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                TextRange range = textRange;
                TextAttributesKey textAttributesKey = PhpHighlightingData.DQL_PLACEHOLDER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DQL_PLACEHOLDER");
                this.this$0.highlightInfo(this.$holder, range, textAttributesKey);
            }

            public final void processVariableAndField(PsiElement variable, PsiElement field) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                TextRange textRange = DqlBuilderKt.getQueryElementTextRange(variable).shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$element)));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                TextRange variableRange = textRange;
                TextRange textRange2 = DqlBuilderKt.getQueryElementTextRange(field).shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$element)));
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
                TextRange fieldRange = textRange2;
                TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"LOCAL_VARIABLE");
                this.this$0.highlightInfo(this.$holder, variableRange, textAttributesKey);
                TextAttributesKey textAttributesKey2 = DefaultLanguageHighlighterColors.INSTANCE_FIELD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"INSTANCE_FIELD");
                this.this$0.highlightInfo(this.$holder, fieldRange, textAttributesKey2);
            }
        });
    }

    public final void highlightInfo(@NotNull AnnotationHolder holder, @NotNull TextRange range, @NotNull TextAttributesKey textAttributesKey) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)textAttributesKey, (String)"textAttributesKey");
        String string = textAttributesKey.getExternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
        String name = string;
        holder.newAnnotation(HighlightSeverity.INFORMATION, name).range(range).textAttributes(textAttributesKey).create();
    }
}

