/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.dql.queryBuilder.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.dql.queryBuilder.DqlBuilderKt;
import com.jetbrains.php.dql.queryBuilder.inspections.PhpDqlBuilderAddTypeQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/php/dql/queryBuilder/inspections/PhpDqlBuilderUnknownModelInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.dql"})
public final class PhpDqlBuilderUnknownModelInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpMethodReference(MethodReference method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (!Intrinsics.areEqual((Object)method.getName(), (Object)"from")) {
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    PsiElement psiElement = method.resolve();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement resolved = psiElement;
                    PhpClass phpClass = PhpClassImpl.getContainingClass((PsiElement)resolved);
                    if (phpClass == null) {
                        return;
                    }
                    PhpClass klass = phpClass;
                    if (!DqlBuilderKt.getKnownDqlBuilderClasses().contains(klass.getFQN())) {
                        return;
                    }
                }
                PsiElement[] psiElementArray = method.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getParameters(...)");
                PsiElement psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])psiElementArray);
                if (psiElement == null) {
                    return;
                }
                PsiElement firstArg = psiElement;
                if (!this.needAdditionalTypeHint(firstArg)) {
                    return;
                }
                this.$holder.problem(firstArg, PhpBundle.message((String)"inspection.php.dql.builder.unknown.model", (Object[])new Object[0])).fix((ModCommandAction)new PhpDqlBuilderAddTypeQuickFix(firstArg)).register();
            }

            private final boolean needAdditionalTypeHint(PsiElement arg) {
                if (DqlBuilderKt.findTypeCommentTag(arg) != null) {
                    return false;
                }
                if (arg instanceof StringLiteralExpression) {
                    PsiReference psiReference = arg.findReferenceAt(1);
                    if (psiReference == null) {
                        return true;
                    }
                    PsiReference reference = psiReference;
                    return reference.resolve() == null;
                }
                return !(arg instanceof ClassConstantReference);
            }
        };
    }
}

