/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class WPUtil {
    private WPUtil() {
    }

    private static boolean isWPFolderValid(String path) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return false;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null || !file.isDirectory()) {
            return false;
        }
        return VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"wp-admin"}) != null && VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"wp-includes"}) != null;
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String validateWPFolder(String path) {
        if (WPUtil.isWPFolderValid(path)) {
            return null;
        }
        return WPBundle.message("wp.settings.validate.directory.message", new Object[0]);
    }

    public static boolean isValid(WPDataService.State state) {
        if (!state.isEnabled()) {
            return true;
        }
        return WPUtil.isWPFolderValid(state.getWPPath());
    }

    public static void notifyGlobally(@Nullable Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message, NotificationType notificationType, Function<Notification, AnAction> ... actions) {
        Notification notification = new Notification("WordPress", title, message, notificationType);
        for (Function<Notification, AnAction> generator : actions) {
            notification.addAction(generator.apply(notification));
        }
        notification.setSuggestionType(true);
        notification.notify(project);
    }

    public static void reindexIfNeeded(ID<?, ?> key, WPDataService.State newState, WPDataService.State oldState) {
        if (newState.isEnabled() && !oldState.isEnabled()) {
            FileBasedIndex.getInstance().requestRebuild(key);
        }
    }
}

