/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.wordpress.hooks.WPHook;
import com.jetbrains.php.wordpress.hooks.WPHookName;
import com.jetbrains.php.wordpress.hooks.WPHookNamePart;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import com.jetbrains.php.wordpress.hooks.WPHookUtils;
import com.jetbrains.php.wordpress.hooks.WPHooksIndex;
import com.jetbrains.php.wordpress.settings.WPDataService;
import icons.WordPressIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WPHookCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(WPHookCompletionContributor.class);
    @NonNls
    private static final Map<String, WPHookType> COMPLETABLE_FUNCTIONS = new HashMap<String, WPHookType>();

    public WPHookCompletionContributor() {
        PsiElementPattern.Capture<PsiElement> parameterListCapture = WPHookUtils.getHookMethodParameterListCapture(ArrayUtilRt.toStringArray(COMPLETABLE_FUNCTIONS.keySet()));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)PhpElementTypes.STRING).withParent(parameterListCapture)).isFirstAcceptedChild((ElementPattern)PlatformPatterns.psiElement())), new WPHooksCompletionProvider());
    }

    private static Collection<WPHookName> getAllHooksInvocationsFromIndex(WPHookType type, @NotNull PrefixMatcher prefixMatcher, @NotNull Project project) {
        if (prefixMatcher == null) {
            WPHookCompletionContributor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            WPHookCompletionContributor.$$$reportNull$$$0(1);
        }
        CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
        FileBasedIndex index = FileBasedIndex.getInstance();
        index.processAllKeys(WPHooksIndex.KEY, (Processor)processor, project);
        Collection results = processor.getResults();
        ArrayList<WPHookName> filtered = new ArrayList<WPHookName>();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        for (WPHook result : results) {
            String lookupText;
            Collection fileCollection;
            if (result == null || type != result.getType() || (fileCollection = index.getContainingFiles(WPHooksIndex.KEY, (Object)result, searchScope)).isEmpty() || (lookupText = WPHookCompletionContributor.createLookupString(result.getName())).isEmpty() || !prefixMatcher.prefixMatches(lookupText)) continue;
            filtered.add(result.getName());
        }
        return filtered;
    }

    @NotNull
    private static String createLookupString(WPHookName name) {
        String string = WPHookUtils.createStarredPresentation(name);
        if (string == null) {
            WPHookCompletionContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    static {
        for (WPHookType type : WPHookType.values()) {
            COMPLETABLE_FUNCTIONS.put(type.getRegistrationMethodName(), type);
            for (String method : type.getInvocationMethodNames()) {
                COMPLETABLE_FUNCTIONS.put(method, type);
            }
        }
        COMPLETABLE_FUNCTIONS.put("has_filter", WPHookType.FILTER);
        COMPLETABLE_FUNCTIONS.put("remove_filter", WPHookType.FILTER);
        COMPLETABLE_FUNCTIONS.put("remove_all_filters", WPHookType.FILTER);
        COMPLETABLE_FUNCTIONS.put("has_action", WPHookType.ACTION);
        COMPLETABLE_FUNCTIONS.put("did_action", WPHookType.ACTION);
        COMPLETABLE_FUNCTIONS.put("remove_action", WPHookType.ACTION);
        COMPLETABLE_FUNCTIONS.put("remove_all_actions", WPHookType.ACTION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookCompletionContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllHooksInvocationsFromIndex";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class WPHooksCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private WPHooksCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Project project;
            WPDataService service;
            if (parameters == null) {
                WPHooksCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                WPHooksCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                WPHooksCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!(service = WPDataService.getInstance(project = parameters.getOriginalFile().getProject())).isEnabled()) {
                return;
            }
            PsiElement position = parameters.getOriginalPosition();
            FunctionReference functionCall = (FunctionReference)PhpPsiUtil.getParentOfClass((PsiElement)position, FunctionReference.class);
            if (functionCall == null) {
                return;
            }
            String functionName = functionCall.getName();
            WPHookType type = COMPLETABLE_FUNCTIONS.get(functionName);
            if (type == null) {
                return;
            }
            PrefixMatcher prefixMatcher = result.getPrefixMatcher();
            Collection<WPHookName> functionNamesFromIndex = WPHookCompletionContributor.getAllHooksInvocationsFromIndex(type, prefixMatcher, project);
            LOG.debug("Completion " + type);
            for (WPHookName name : functionNamesFromIndex) {
                LOG.debug(name.toString());
                result.addElement((LookupElement)new HookRegistrationLookupElement(name));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/wordpress/hooks/WPHookCompletionContributor$WPHooksCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class HookRegistrationLookupElement
    extends LookupElement {
        private final WPHookName myHookName;
        private final String myLookupString;
        private final String myPresentableString;

        private HookRegistrationLookupElement(WPHookName hookName) {
            this.myHookName = hookName;
            this.myLookupString = WPHookCompletionContributor.createLookupString(this.myHookName);
            this.myPresentableString = WPHookUtils.createDescriptivePresentation(this.myHookName);
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            if (presentation == null) {
                HookRegistrationLookupElement.$$$reportNull$$$0(0);
            }
            presentation.setItemText(this.myPresentableString);
            presentation.setIcon(WordPressIcons.HookElement);
        }

        @NotNull
        public String getLookupString() {
            String string = this.myLookupString;
            if (string == null) {
                HookRegistrationLookupElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                HookRegistrationLookupElement.$$$reportNull$$$0(2);
            }
            if (!this.myHookName.isPureString()) {
                Document document = context.getEditor().getDocument();
                document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)"");
                context.commitDocument();
                Template template = TemplateManager.getInstance((Project)context.getProject()).createTemplate("", "");
                for (WPHookNamePart part : this.myHookName.getParts()) {
                    if (part.isStringValue()) {
                        template.addTextSegment(part.getText());
                        continue;
                    }
                    template.addVariable(part.getText(), (Expression)new ConstantNode(part.getText()), true);
                }
                TemplateManager.getInstance((Project)context.getProject()).startTemplate(context.getEditor(), template);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookCompletionContributor$HookRegistrationLookupElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookCompletionContributor$HookRegistrationLookupElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "renderElement";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

