/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.wordpress.hooks.WPHook;
import com.jetbrains.php.wordpress.hooks.WPHookName;
import com.jetbrains.php.wordpress.hooks.WPHookNamePart;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import com.jetbrains.php.wordpress.hooks.WPHookUtils;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class WPHooksIndex
extends ScalarIndexExtension<WPHook> {
    @NonNls
    public static final ID<WPHook, Void> KEY = ID.create((String)"wordpress.hook.invocations");
    private final KeyDescriptor<WPHook> myKeyDescriptor = new WPHookDescriptor();

    @NotNull
    public ID<WPHook, Void> getName() {
        ID<WPHook, Void> iD = KEY;
        if (iD == null) {
            WPHooksIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<WPHook, Void, FileContent> getIndexer() {
        return new DataIndexer<WPHook, Void, FileContent>(){

            @NotNull
            public Map<WPHook, Void> map(@NotNull FileContent inputData) {
                WPDataService dataService;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(dataService = WPDataService.getInstance(inputData.getProject())).isEnabled()) {
                    Map<WPHook, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                final HashMap<WPHook, Void> map = new HashMap<WPHook, Void>();
                inputData.getPsiFile().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof FunctionReference) {
                            this.visitFunctionReference((FunctionReference)element);
                        }
                        super.visitElement(element);
                    }

                    public void visitFunctionReference(FunctionReference functionReference) {
                        WPHook hook = WPHookUtils.getPotentialHookFromInvocation((PsiElement)functionReference, false);
                        if (hook == null) {
                            hook = WPHookUtils.getPotentialHookFromRegistration((PsiElement)functionReference, false);
                        }
                        if (hook != null) {
                            map.put(new WPHook(hook.getName(), hook.getType()), null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/wordpress/hooks/WPHooksIndex$1$1", "visitElement"));
                    }
                });
                HashMap<WPHook, Void> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHooksIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHooksIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public KeyDescriptor<WPHook> getKeyDescriptor() {
        KeyDescriptor<WPHook> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            WPHooksIndex.$$$reportNull$$$0(1);
        }
        return keyDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            WPHooksIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/wordpress/hooks/WPHooksIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class WPHookDescriptor
    implements KeyDescriptor<WPHook> {
        private WPHookDescriptor() {
        }

        public int getHashCode(WPHook value) {
            return value.hashCode();
        }

        public boolean isEqual(WPHook val1, WPHook val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput storage, @NotNull WPHook value) throws IOException {
            if (storage == null) {
                WPHookDescriptor.$$$reportNull$$$0(0);
            }
            if (value == null) {
                WPHookDescriptor.$$$reportNull$$$0(1);
            }
            storage.writeInt(value.getType().ordinal());
            List<WPHookNamePart> parts = value.getName().getParts();
            storage.writeInt(parts.size());
            for (WPHookNamePart part : parts) {
                storage.writeBoolean(part.isStringValue());
                storage.writeUTF(part.getText());
            }
        }

        public WPHook read(@NotNull DataInput storage) throws IOException {
            if (storage == null) {
                WPHookDescriptor.$$$reportNull$$$0(2);
            }
            int typeOrdinal = storage.readInt();
            WPHookType[] enumConstants = (WPHookType[])WPHookType.class.getEnumConstants();
            if (typeOrdinal < 0 || typeOrdinal >= enumConstants.length) {
                return null;
            }
            WPHookType type = enumConstants[typeOrdinal];
            int partsSize = storage.readInt();
            ArrayList<WPHookNamePart> parts = new ArrayList<WPHookNamePart>(partsSize);
            for (int i = 0; i < partsSize; ++i) {
                boolean isPureText = storage.readBoolean();
                String text = storage.readUTF();
                if (StringUtil.isEmpty((String)text)) {
                    return null;
                }
                parts.add(new WPHookNamePart(text, isPureText));
            }
            WPHookName name = new WPHookName(parts);
            return new WPHook(name, type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHooksIndex$WPHookDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

