/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.tree.IElementType;
import java.lang.reflect.Field;
import java.util.function.Supplier;

final class StubFieldAccessor
implements Supplier<ObjectStubSerializer<?, ? extends Stub>> {
    final String externalId;
    private final Field myField;
    private volatile ObjectStubSerializer<?, Stub> myFieldValue;

    StubFieldAccessor(String externalId, Field field) {
        this.externalId = externalId;
        this.myField = field;
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public ObjectStubSerializer<?, Stub> get() {
        ObjectStubSerializer<?, Stub> delegate = this.myFieldValue;
        if (delegate == null) {
            try {
                ObjectStubSerializer<?, Stub> serializer2;
                Object object = this.myField.get(null);
                if (object instanceof ObjectStubSerializer) {
                    serializer2 = (ObjectStubSerializer<?, Stub>)object;
                } else if (object instanceof IElementType) {
                    IElementType elementType = (IElementType)object;
                    serializer2 = StubElementRegistryService.getInstance().getStubSerializer(elementType);
                } else {
                    throw new IllegalStateException(object + " is not an instance of ObjectStubSerializer nor IElementType with registered stub serializer");
                }
                this.myFieldValue = delegate = serializer2;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(this.myField + " is not assignable to 'ObjectStubSerializer'", e);
            }
            if (!delegate.getExternalId().equals(this.externalId)) {
                throw new IllegalStateException("External id mismatch in " + this + ". Judging by extension declaration it should be " + this.externalId + " but " + delegate.getExternalId() + " is returned.");
            }
        }
        return delegate;
    }

    public String toString() {
        return this.myField.toString();
    }
}

