/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectSharedConfiguration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PhpLanguageLevel {
    PHP530("5.3.0", PhpFrontBackBundle.message("PhpLanguageLevel.5.3.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.5.3.0.short.description", new Object[0]), PhpLanguageFeature.VAR_CONTINUE_ARGUMENT, PhpLanguageFeature.VAR_BREAK_ARGUMENT, PhpLanguageFeature.VAR_CONTINUE_ZERO_ARGUMENT, PhpLanguageFeature.VAR_BREAK_ZERO_ARGUMENT, PhpLanguageFeature.CALL_TIME_PASS_BY_REFERENCE),
    PHP540("5.4.0", PhpFrontBackBundle.message("PhpLanguageLevel.5.4.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.5.4.0.short.description", new Object[0]), PhpLanguageFeature.TRAITS, PhpLanguageFeature.SHORT_ARRAY_SYNTAX, PhpLanguageFeature.CLASS_MEMBER_ACCESS_ON_INSTANTIATION, PhpLanguageFeature.ARRAY_DEREFERENCING, PhpLanguageFeature.THIS_IN_CLOSURE, PhpLanguageFeature.SELF_IN_CLOSURE, PhpLanguageFeature.PARENT_IN_CLOSURE, PhpLanguageFeature.STATIC_IN_CLOSURE, PhpLanguageFeature.BINARY_LITERAL, PhpLanguageFeature.LITERAL_IN_STATIC_CALL, PhpLanguageFeature.BUILT_IN_WEB_SERVER),
    PHP550("5.5.0", PhpFrontBackBundle.message("PhpLanguageLevel.5.5.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.5.5.0.short.description", new Object[0]), PHP540, PhpLanguageFeature.FINALLY, PhpLanguageFeature.GENERATORS, PhpLanguageFeature.FOREACH_LIST, PhpLanguageFeature.EMPTY_ANY_EXPRESSION, PhpLanguageFeature.IMMEDIATE_DEREFERENCING, PhpLanguageFeature.CLASS_NAME_CONST),
    PHP560("5.6.0", PhpFrontBackBundle.message("PhpLanguageLevel.5.6.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.5.6.0.short.description", new Object[0]), PHP550, PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS, PhpLanguageFeature.VARIADIC_FUNCTIONS, PhpLanguageFeature.ARGUMENT_UNPACKING, PhpLanguageFeature.EXPONENTIATION, PhpLanguageFeature.USE_FUNCTION_AND_CONST),
    PHP700("7.0", PhpFrontBackBundle.message("PhpLanguageLevel.7.0.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.7.0.0.short.description", new Object[0]), PHP560, PhpLanguageFeature.RETURN_TYPES, PhpLanguageFeature.SCALAR_TYPE_HINTS, PhpLanguageFeature.SPACESHIP_OPERATOR, PhpLanguageFeature.COALESCE_OPERATOR, PhpLanguageFeature.GROUPED_USE, PhpLanguageFeature.KEYWORD_NAMES, PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX, PhpLanguageFeature.ANONYMOUS_CLASSES),
    PHP710("7.1", PhpFrontBackBundle.message("PhpLanguageLevel.7.1.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.7.1.0.short.description", new Object[0]), PHP700, PhpLanguageFeature.RETURN_VOID, PhpLanguageFeature.NULLABLES, PhpLanguageFeature.ITERABLE_TYPE_HINT, PhpLanguageFeature.CATCH_MULTIPLE, PhpLanguageFeature.LIST_KEYS, PhpLanguageFeature.LIST_ASSIGN, PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY, PhpLanguageFeature.NEGATIVE_NUMERIC_INDICES),
    PHP720("7.2", PhpFrontBackBundle.message("PhpLanguageLevel.7.2.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.7.2.0.short.description", new Object[0]), PHP710, PhpLanguageFeature.OBJECT_TYPE_HINT, PhpLanguageFeature.ABSTRACT_FUNCTION_OVERRIDE, PhpLanguageFeature.TRAILING_COMMA_IN_GROUP_USES),
    PHP730("7.3", PhpFrontBackBundle.message("PhpLanguageLevel.7.3.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.7.3.0.short.description", new Object[0]), PHP720, PhpLanguageFeature.LITERAL_IN_INSTANCEOF, PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL, PhpLanguageFeature.FLEXIBLE_HEREDOCS),
    PHP740("7.4", PhpFrontBackBundle.message("PhpLanguageLevel.7.4.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.7.4.0.short.description", new Object[0]), PHP730, PhpLanguageFeature.TYPED_PROPERTIES, PhpLanguageFeature.SPREAD_OPERATOR_IN_ARRAY, PhpLanguageFeature.COALESCE_ASSIGN, PhpLanguageFeature.ARROW_FUNCTION_SYNTAX, PhpLanguageFeature.NUMERIC_LITERALS_SEPARATORS),
    PHP800("8.0", PhpFrontBackBundle.message("PhpLanguageLevel.8.0.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.8.0.0.short.description", new Object[0]), PHP740, PhpLanguageFeature.UNION_TYPES, PhpLanguageFeature.NAMESPACED_NAME_AS_SINGLE_TOKEN, PhpLanguageFeature.NULLSAFE_DEREFERENCING, PhpLanguageFeature.ABSTRACT_PRIVATE_TRAIT_METHODS, PhpLanguageFeature.MIXED_TYPE_HINT, PhpLanguageFeature.STATIC_RETURN_TYPE_HINT, PhpLanguageFeature.TRAILING_COMMA_IN_PARAMETER_LIST, PhpLanguageFeature.TRAILING_COMMA_IN_CLOSURE_USE_LIST, PhpLanguageFeature.NAMED_ARGUMENTS, PhpLanguageFeature.MATCH_EXPRESSION, PhpLanguageFeature.THROW_EXPRESSION, PhpLanguageFeature.NON_CAPTURING_CATCHES, PhpLanguageFeature.CLASS_NAME_LITERAL_ON_OBJECT, PhpLanguageFeature.ATTRIBUTES, PhpLanguageFeature.PROPERTY_PROMOTION),
    PHP810("8.1", PhpFrontBackBundle.message("PhpLanguageLevel.8.1.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.8.1.0.short.description", new Object[0]), PHP800, PhpLanguageFeature.ENUM_CLASSES, PhpLanguageFeature.RETURN_NEVER, PhpLanguageFeature.FINAL_CLASS_CONSTANTS, PhpLanguageFeature.INTERSECTION_TYPES, PhpLanguageFeature.READONLY_PROPERTIES, PhpLanguageFeature.EXPLICIT_OCTAL_LITERAL, PhpLanguageFeature.NEW_IN_INIT, PhpLanguageFeature.FIRST_CLASS_CALLABLE),
    PHP820("8.2", PhpFrontBackBundle.message("PhpLanguageLevel.8.2.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.8.2.0.short.description", new Object[0]), PHP810, PhpLanguageFeature.READONLY_CLASSES, PhpLanguageFeature.STANDALONE_NULL_FALSE, PhpLanguageFeature.TRUE_TYPE, PhpLanguageFeature.INTERSECTION_AND_UNION_IN_SAME_TYPE, PhpLanguageFeature.CONSTANTS_IN_TRAITS),
    PHP830("8.3", PhpFrontBackBundle.message("PhpLanguageLevel.8.3.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.8.3.0.short.description", new Object[0]), PHP820, PhpLanguageFeature.TYPED_CLASS_CONSTANTS, PhpLanguageFeature.ANONYMOUS_READONLY_CLASSES, PhpLanguageFeature.DYNAMIC_CLASS_CONSTANT, PhpLanguageFeature.ARBITRARY_STATIC_VARIABLE_INITIALIZERS, PhpLanguageFeature.ATTRIBUTE_OVERRIDE),
    PHP840("8.4", PhpFrontBackBundle.message("PhpLanguageLevel.8.4.0.presentable.name", new Object[0]), PhpFrontBackBundle.message("PhpLanguageLevel.8.4.0.short.description", new Object[0]), PHP830, PhpLanguageFeature.NEW_WITHOUT_PARENTHESES, PhpLanguageFeature.PROPERTY_HOOKS, PhpLanguageFeature.ASYMMETRIC_VISIBILITY);

    public static final PhpLanguageLevel DEFAULT;
    @NotNull
    private final String myVersionString;
    @NotNull
    private final String myPresentableName;
    @NotNull
    @Nls
    private final String myShortDescription;
    @NotNull
    private final Set<PhpLanguageFeature> myFeatures;

    private PhpLanguageLevel(@Nls @NotNull String versionString, @NotNull String presentableName, String shortDescription, PhpLanguageFeature ... languageFeatures) {
        if (versionString == null) {
            PhpLanguageLevel.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            PhpLanguageLevel.$$$reportNull$$$0(1);
        }
        if (shortDescription == null) {
            PhpLanguageLevel.$$$reportNull$$$0(2);
        }
        if (languageFeatures == null) {
            PhpLanguageLevel.$$$reportNull$$$0(3);
        }
        this.myVersionString = versionString;
        this.myPresentableName = presentableName;
        this.myShortDescription = shortDescription;
        this.myFeatures = EnumSet.noneOf(PhpLanguageFeature.class);
        Collections.addAll(this.myFeatures, languageFeatures);
    }

    private PhpLanguageLevel(@Nls @NotNull String versionString, @NotNull String presentableName, @NotNull String shortDescription, PhpLanguageLevel base, PhpLanguageFeature ... languageFeatures) {
        if (versionString == null) {
            PhpLanguageLevel.$$$reportNull$$$0(4);
        }
        if (presentableName == null) {
            PhpLanguageLevel.$$$reportNull$$$0(5);
        }
        if (shortDescription == null) {
            PhpLanguageLevel.$$$reportNull$$$0(6);
        }
        if (base == null) {
            PhpLanguageLevel.$$$reportNull$$$0(7);
        }
        if (languageFeatures == null) {
            PhpLanguageLevel.$$$reportNull$$$0(8);
        }
        this.myVersionString = versionString;
        this.myPresentableName = presentableName;
        this.myShortDescription = shortDescription;
        this.myFeatures = EnumSet.noneOf(PhpLanguageFeature.class);
        this.myFeatures.addAll(base.myFeatures);
        Collections.addAll(this.myFeatures, languageFeatures);
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            PhpLanguageLevel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getVersionString() {
        String string = this.myVersionString;
        if (string == null) {
            PhpLanguageLevel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getShortDescription() {
        String string = this.myShortDescription;
        if (string == null) {
            PhpLanguageLevel.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean hasFeature(@NotNull PhpLanguageFeature languageFeature) {
        if (languageFeature == null) {
            PhpLanguageLevel.$$$reportNull$$$0(12);
        }
        return this.myFeatures.contains((Object)languageFeature);
    }

    @NotNull
    public static PhpLanguageLevel from(@NotNull String versionString) {
        if (versionString == null) {
            PhpLanguageLevel.$$$reportNull$$$0(13);
        }
        for (PhpLanguageLevel level : PhpLanguageLevel.values()) {
            if (!level.getVersionString().equals(versionString)) continue;
            PhpLanguageLevel phpLanguageLevel = level;
            if (phpLanguageLevel == null) {
                PhpLanguageLevel.$$$reportNull$$$0(14);
            }
            return phpLanguageLevel;
        }
        PhpLanguageLevel phpLanguageLevel = DEFAULT;
        if (phpLanguageLevel == null) {
            PhpLanguageLevel.$$$reportNull$$$0(15);
        }
        return phpLanguageLevel;
    }

    @Nullable
    public static PhpLanguageLevel parse(@NotNull String versionString) {
        List split;
        if (versionString == null) {
            PhpLanguageLevel.$$$reportNull$$$0(16);
        }
        if ((split = StringUtil.split((String)versionString, (String)".")).size() > 1) {
            String majorVersion = (String)split.get(0);
            String minorVersion = (String)split.get(1);
            String enumName = "PHP" + majorVersion + minorVersion + "0";
            for (PhpLanguageLevel level : PhpLanguageLevel.values()) {
                if (!level.name().equals(enumName)) continue;
                return level;
            }
        }
        return null;
    }

    public boolean isAtLeast(@NotNull PhpLanguageLevel languageLevel) {
        if (languageLevel == null) {
            PhpLanguageLevel.$$$reportNull$$$0(17);
        }
        return this.compareTo(languageLevel) >= 0;
    }

    @NotNull
    public static PhpLanguageLevel current(@NotNull Project project) {
        if (project == null) {
            PhpLanguageLevel.$$$reportNull$$$0(18);
        }
        PhpProjectSharedConfiguration projectConfiguration = (PhpProjectSharedConfiguration)project.getService(PhpProjectSharedConfiguration.class);
        PhpLanguageLevel phpLanguageLevel = projectConfiguration.getLanguageLevel();
        if (phpLanguageLevel == null) {
            PhpLanguageLevel.$$$reportNull$$$0(19);
        }
        return phpLanguageLevel;
    }

    static {
        DEFAULT = PHP560;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 14, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortDescription";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageFeatures";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpLanguageLevel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageFeature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpLanguageLevel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDescription";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasFeature";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "current";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 14, 15, 19 -> new IllegalStateException(string);
        };
    }
}

