/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.BasicPhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import java.util.Set;

public final class BasicPhpDocUtil {
    @NlsSafe
    public static final String API_TAG = "@api";
    @NlsSafe
    public static final String AUTHOR_TAG = "@author";
    @NlsSafe
    public static final String CATEGORY_TAG = "@category";
    @NlsSafe
    public static final String COPYRIGHT_TAG = "@copyright";
    @NlsSafe
    public static final String DEPRECATED_TAG = "@deprecated";
    @NlsSafe
    public static final String EXAMPLE_TAG = "@example";
    @NlsSafe
    public static final String FILESOURCE_TAG = "@filesource";
    @NlsSafe
    public static final String GLOBAL_TAG = "@global";
    @NlsSafe
    public static final String IGNORE_TAG = "@ignore";
    @NlsSafe
    public static final String INTERNAL_TAG = "@internal";
    @NlsSafe
    public static final String LICENSE_TAG = "@license";
    @NlsSafe
    public static final String LINK_TAG = "@link";
    @NlsSafe
    public static final String METHOD_TAG = "@method";
    @NlsSafe
    public static final String PACKAGE_TAG = "@package";
    @NlsSafe
    public static final String PARAM_TAG = "@param";
    @NlsSafe
    public static final String PROPERTY_TAG = "@property";
    @NlsSafe
    public static final String PROPERTY_READ_TAG = "@property-read";
    @NlsSafe
    public static final String PROPERTY_WRITE_TAG = "@property-write";
    @NlsSafe
    public static final String RETURN_TAG = "@return";
    @NlsSafe
    public static final String SEE_TAG = "@see";
    @NlsSafe
    public static final String SINCE_TAG = "@since";
    @NlsSafe
    public static final String SUBPACKAGE_TAG = "@subpackage";
    @NlsSafe
    public static final String THROWS_TAG = "@throws";
    @NlsSafe
    public static final String TODO_TAG = "@todo";
    @NlsSafe
    public static final String USES_TAG = "@uses";
    @NlsSafe
    public static final String USED_BY_TAG = "used-by";
    @NlsSafe
    public static final String VAR_TAG = "@var";
    @NlsSafe
    public static final String VERSION_TAG = "@version";
    @NlsSafe
    public static final String INHERITDOC_TAG = "@inheritDoc";
    @NlsSafe
    public static final String MIXIN_TAG = "@mixin";
    @NlsSafe
    public static final String FINAL_TAG = "@final";
    public static final Set<String> ALL_TAGS = Set.of("@api", "@author", "@category", "@copyright", "@deprecated", "@example", "@filesource", "@global", "@ignore", "@internal", "@license", "@link", "@method", "@package", "@param", "@property", "@property-read", "@property-write", "@return", "@see", "@since", "@subpackage", "@throws", "@todo", "@uses", "used-by", "@var", "@version", "@inheritDoc", "@mixin", "@final");

    public static boolean isSimpleTag(PsiElement element) {
        IElementType prevType;
        if (!BasicPhpPsiUtil.isOfType(element, BasicPhpDocStubElementTypes.phpDocTag)) {
            return false;
        }
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if ((prevType = PsiUtilCore.getElementType((PsiElement)prev)) == PhpDocTokenTypes.DOC_LEADING_ASTERISK || prevType == PhpDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
            PsiElement child = element.getFirstChild();
            if (child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (BasicPhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TAG_NAME)) {
                if (ALL_TAGS.contains(child.getText())) {
                    return true;
                }
                if ((child = BasicPhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true)) == null) {
                    return true;
                }
                IElementType childType = child.getNode().getElementType();
                if (childType == PhpDocElementTypes.phpDocType || childType == PhpDocElementTypes.phpDocVariable || childType == PhpDocElementTypes.phpDocRef) {
                    return true;
                }
                if (childType == PhpDocElementTypes.phpDocTagValue && ((child = child.getFirstChild()) == null || BasicPhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER) || BasicPhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TEXT))) {
                    return true;
                }
            }
        }
        return false;
    }
}

