/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.parser.tags;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.BasicPhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTagParserRegistry;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTypeTagParser;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocVarTagParser;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Namespace;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PhpDocTagParser
implements PhpDocElementTypes {
    public static final String $THIS = "$this";
    public static final TokenSet TYPE_SEP = TokenSet.create((IElementType[])new IElementType[]{DOC_PIPE, DOC_AMPERSAND});
    private static final ParserPart ADVANCED_CLOSURE_PARAMETER = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker param = builder.mark();
            boolean variablePrefix = PhpDocVarTagParser.parseVar(builder);
            if (PhpDocTagParser.parseTypes(builder)) {
                if (!variablePrefix) {
                    PhpDocVarTagParser.parseVar(builder);
                }
                if (!PhpDocTagParser.compareAndEatTextWithValue(builder, "=")) {
                    PhpDocTagParser.compareAndEatTextWithValue(builder, "...");
                }
                param.done(BasicPhpDocStubElementTypes.phpDocParam);
                return BasicPhpDocStubElementTypes.phpDocParam;
            }
            param.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
    };

    public void parse(PhpPsiBuilder builder, boolean inside, boolean inlineTag) {
        PsiBuilder.Marker tag = builder.mark();
        builder.match(DOC_TAG_NAME);
        this.parseContents(builder);
        if (inlineTag || !inside) {
            PhpDocTagParser.parseValue(builder, inlineTag);
        }
        tag.done(this.getElementType());
    }

    public IElementType getElementType() {
        return phpDocTag;
    }

    protected boolean parseContents(PhpPsiBuilder builder) {
        PsiBuilder.Marker content = builder.mark();
        if (builder.compareAndEat(DOC_LPAREN)) {
            while (!(builder.compare(DOC_RPAREN) || builder.compare(DOC_COMMENT_LEADING_ASTERISK) || builder.compare(DOC_COMMENT_END) || builder.eof())) {
                if (builder.compare(DOC_TAG_NAME)) {
                    this.parse(builder, true, false);
                    continue;
                }
                if (builder.compare(DOC_STRING)) {
                    PsiBuilder.Marker mark = builder.mark();
                    builder.match(DOC_STRING);
                    mark.done((IElementType)phpDocString);
                    continue;
                }
                builder.advanceLexer();
            }
            PhpDocTagParser.compareAndEatTextWithValue(builder, "...");
            builder.compareAndEat(DOC_RPAREN);
            content.done((IElementType)phpDocAttributeList);
        } else {
            content.drop();
        }
        return true;
    }

    public static boolean parseTypes(PhpPsiBuilder builder) {
        boolean atLeastOneTypeParsed = false;
        while (PhpDocTagParser.parseSingleDocType(builder)) {
            atLeastOneTypeParsed = true;
            if (builder.isInsideGenericArray() && builder.compare(DOC_TEXT) && "|".equals(builder.getTokenText())) {
                builder.remapCurrentTokenWithDocPipe();
            }
            if (!(builder.compare(DOC_LPAREN) | !builder.compareAndEat(TYPE_SEP))) continue;
            break;
        }
        return atLeastOneTypeParsed;
    }

    private static boolean parseSingleDocType(PhpPsiBuilder builder) {
        if (!(builder.compare(DOC_IDENTIFIER) || builder.compare(DOC_NAMESPACE) || builder.compare(DOC_VARIABLE) && $THIS.equals(builder.getTokenText()) || builder.compare(DOC_HASH) || builder.compare(DOC_TEXT) || builder.compare(DOC_QUESTION_MARK) || builder.compare(DOC_LAB) || builder.compare(DOC_STRING) || builder.compare(DOC_LPAREN))) {
            return false;
        }
        if ("covariant".equals(builder.getTokenText()) || "contravariant".equals(builder.getTokenText())) {
            builder.advanceLexer();
        }
        if ("'".equals(builder.getTokenText())) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            boolean literalType = false;
            while (!builder.eof()) {
                if (PhpDocTagParser.compareAndEatTextWithValue(builder, "'")) {
                    literalType = true;
                    break;
                }
                builder.remapCurrentToken(DOC_TEXT);
                builder.advanceLexer();
            }
            if (literalType) {
                mark.done((IElementType)phpDocType);
                return true;
            }
            mark.rollbackTo();
        } else if ("''".equals(builder.getTokenText()) || builder.compare(DOC_STRING)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done((IElementType)phpDocType);
            return true;
        }
        boolean docText = false;
        if (builder.getTokenType() == DOC_TEXT) {
            String tokenText = builder.getTokenText();
            if (tokenText != null && tokenText.equals("?")) {
                builder.remapCurrentTokenWithDocQuestion();
                builder.advanceLexer();
            } else {
                docText = true;
            }
        } else if (builder.getTokenType() == DOC_QUESTION_MARK) {
            builder.advanceLexer();
        }
        PsiBuilder.Marker type = builder.mark();
        if (!(!docText || builder.isInsideGenericArray() && PhpDocTagParser.eatIntRangeBound(builder) || PhpDocTagParser.compareAndEatTextWithValue(builder, "!"))) {
            type.drop();
            return false;
        }
        builder.compareAndEat(DOC_HASH);
        if (!(PhpDocTagParser.tryParseDocTypeInparens(builder) || PhpDocTagParser.parseAdvancedClosure(builder) || PhpDocTagParser.parseConditionalType(builder))) {
            if (builder.compare(DOC_LPAREN)) {
                type.drop();
                return false;
            }
            if (!PhpDocTagParser.parseExtendedDocRef(builder)) {
                PhpDocTagParser.parseReferenceType(builder);
            }
        }
        PsiBuilder.Marker array = builder.mark();
        while (builder.compareAndEat(DOC_LBRACKET) && builder.compareAndEat(DOC_RBRACKET)) {
            array.drop();
            array = builder.mark();
        }
        array.rollbackTo();
        type.done((IElementType)phpDocType);
        return true;
    }

    private static boolean tryParseDocTypeInparens(PhpPsiBuilder builder) {
        boolean res;
        PsiBuilder.Marker mark = builder.mark();
        if (builder.compareAndEat(DOC_LPAREN) && (res = PhpDocTagParser.parseTypes(builder)) && builder.compareAndEat(DOC_RPAREN)) {
            mark.drop();
            return true;
        }
        mark.rollbackTo();
        return false;
    }

    private static boolean parseAdvancedClosure(PhpPsiBuilder builder) {
        PsiBuilder.Marker closure = builder.mark();
        if (PhpDocTagParser.tryParseAdvancedCallable(builder)) {
            closure.drop();
            return true;
        }
        closure.rollbackTo();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean parseConditionalType(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        boolean isAllowMultilineTypes = builder.isAllowMultilineDocTypes();
        try {
            builder.setAllowMultilineDocTypes(true);
            if (!builder.compareAndEat(DOC_LPAREN) || !PhpDocTagParser.parseCondition(builder)) {
                marker.rollbackTo();
                boolean bl = false;
                return bl;
            }
            marker.drop();
            boolean bl = PhpDocTagParser.parseTypes(builder) && PhpDocTagParser.parseIf(builder) && PhpDocTagParser.parseElse(builder) && builder.compareAndEat(DOC_RPAREN);
            return bl;
        }
        finally {
            builder.setAllowMultilineDocTypes(isAllowMultilineTypes);
        }
    }

    private static boolean parseStatement(PhpPsiBuilder builder, String prefix) {
        if (!PhpDocTagParser.compareAndEatTextWithValue(builder, prefix)) {
            return false;
        }
        boolean wrapped = PhpDocTagParser.compareAndEatTextWithValue(builder, "'");
        return wrapped ? PhpDocTagParser.parseTypes(builder) && PhpDocTagParser.compareAndEatTextWithValue(builder, "'") : PhpDocTagParser.parseTypes(builder);
    }

    private static boolean parseIf(PhpPsiBuilder builder) {
        return PhpDocTagParser.parseStatement(builder, "?");
    }

    private static boolean parseElse(PhpPsiBuilder builder) {
        return PhpDocTagParser.parseStatement(builder, ":");
    }

    private static boolean parseCondition(PhpPsiBuilder builder) {
        return (builder.compare(DOC_IDENTIFIER) && PhpDocTagParser.parseSingleDocType(builder) || PhpDocVarTagParser.parseVar(builder)) && "is".equals(builder.getTokenText()) && builder.compareAndEat(DOC_IDENTIFIER);
    }

    private static void parseReferenceType(PhpPsiBuilder builder) {
        Namespace.parseReference(builder);
        String identifierText = null;
        if (builder.compare(DOC_IDENTIFIER)) {
            identifierText = builder.getTokenText();
            builder.advanceLexer();
        } else if ($THIS.equals(builder.getTokenText())) {
            builder.advanceLexer();
        }
        if (!PhpDocTagParser.tryParseIntRange(identifierText, builder) && !PhpDocTagParser.parseGenericArray(builder, DOC_LAB, DOC_RAB, PhpDocTagParser::parseTypes)) {
            boolean allowMultilineDocTypes = builder.isAllowMultilineDocTypes();
            try {
                builder.setAllowMultilineDocTypes(true);
                PhpDocTagParser.parseGenericArray(builder, DOC_LBRACE, DOC_RBRACE, b -> {
                    PhpDocTagParser.parseKey(builder, false);
                    return PhpDocTagParser.parseTypes(builder);
                });
            }
            finally {
                builder.setAllowMultilineDocTypes(allowMultilineDocTypes);
            }
        }
    }

    private static boolean tryParseIntRange(String identifierText, PhpPsiBuilder builder) {
        if ("int".equals(identifierText)) {
            PsiBuilder.Marker rangeList = builder.mark();
            if (builder.compareAndEat(DOC_LAB) && PhpDocTagParser.eatIntRangeBound(builder) && builder.compareAndEat(DOC_COMMA) && PhpDocTagParser.eatIntRangeBound(builder) && builder.compareAndEat(DOC_RAB)) {
                rangeList.done((IElementType)phpDocAttributeList);
                return true;
            }
            rangeList.rollbackTo();
        }
        return false;
    }

    @Contract(mutates="param1")
    private static boolean eatIntRangeBound(PhpPsiBuilder builder) {
        if (PhpDocTagParser.isIntRangeBound(builder.getTokenText())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean isIntRangeBound(@Nullable String text) {
        if (text == null) {
            return false;
        }
        if ("max".equals(text) || "min".equals(text)) {
            return true;
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private static boolean parseKey(PhpPsiBuilder builder, boolean quote) {
        String text;
        if (PhpDocTagParser.compareAndEatTextWithValue(builder, "...")) {
            return true;
        }
        PsiBuilder.Marker mark = builder.mark();
        if (builder.compareAndEat(DOC_IDENTIFIER)) {
            return PhpDocTagParser.parseRestOfIdentifier(builder, quote, mark);
        }
        PsiBuilder.Marker stringIdentifier = builder.mark();
        PhpDocTagParser.compareAndEatTextWithValue(builder, "?");
        if (builder.compareAndEat(DOC_STRING)) {
            stringIdentifier.drop();
            return PhpDocTagParser.parseRestOfIdentifier(builder, quote, mark);
        }
        stringIdentifier.rollbackTo();
        mark.drop();
        if (builder.compare(DOC_TEXT) && (text = builder.getTokenText()) != null) {
            if (PhpDocTagParser.isNumberEndingWith(text, "?")) {
                builder.advanceLexer();
                PhpDocTagParser.compareAndEatTextWithValue(builder, ":");
                return true;
            }
            if (PhpDocTagParser.isNumberEndingWith(text, "?:")) {
                builder.advanceLexer();
                return true;
            }
            if (text.equals("'") || text.equals("?'")) {
                PsiBuilder.Marker quotedIdentifierMark = builder.mark();
                builder.advanceLexer();
                if (PhpDocTagParser.parseKey(builder, true)) {
                    quotedIdentifierMark.drop();
                    return true;
                }
                quotedIdentifierMark.rollbackTo();
                return false;
            }
        }
        return false;
    }

    private static boolean parseRestOfIdentifier(PhpPsiBuilder builder, boolean quote, PsiBuilder.Marker mark) {
        if (!PhpDocTagParser.compareAndEatTextWithValue(builder, "?:")) {
            PhpDocTagParser.compareAndEatTextWithValue(builder, "?");
            if (quote) {
                if (!PhpDocTagParser.compareAndEatTextWithValue(builder, "'")) {
                    PhpDocTagParser.compareAndEatTextWithValue(builder, "'?");
                }
                if (builder.compareAndEat(DOC_PIPE)) {
                    mark.drop();
                    return PhpDocTagParser.parseKey(builder, false);
                }
            }
            if (!(PhpDocTagParser.compareAndEatTextWithValue(builder, ":") || PhpDocTagParser.compareAndEatTextWithValue(builder, "?:") || quote && PhpDocTagParser.compareAndEatTextWithValue(builder, "':") || PhpDocTagParser.compareAndEatTextWithValue(builder, "'?:"))) {
                mark.rollbackTo();
                return false;
            }
        }
        mark.drop();
        return true;
    }

    private static boolean isNumberEndingWith(String text, String suffix) {
        return StringUtil.endsWith((CharSequence)text, (CharSequence)suffix) && StringUtil.isNotNegativeNumber((CharSequence)text.substring(0, text.length() - suffix.length()));
    }

    private static boolean parseGenericArray(PhpPsiBuilder builder, IElementType openParens, IElementType closedParens, Function<PhpPsiBuilder, Boolean> typeParser) {
        return PhpDocTagParser.parseGenericArray(builder, openParens, closedParens, DOC_COMMA, typeParser);
    }

    public static boolean parseGenericArray(PhpPsiBuilder builder, IElementType openParens, IElementType closedParens, IElementType comma, Function<PhpPsiBuilder, Boolean> typeParser) {
        if (builder.rawLookup(0) != DOC_WHITESPACE && builder.compare(openParens)) {
            PsiBuilder.Marker param = builder.mark();
            builder.advanceLexer();
            boolean isInsideGenericArray = builder.isInsideGenericArray();
            builder.setInsideGenericArray(true);
            while (typeParser.apply(builder).booleanValue() && builder.compareAndEat(comma)) {
            }
            builder.setInsideGenericArray(isInsideGenericArray);
            PhpDocTagParser.compareAndEatTextWithValue(builder, "...");
            builder.compareAndEat(closedParens);
            param.done((IElementType)phpDocAttributeList);
            return true;
        }
        return false;
    }

    private static boolean compareAndEatTextWithValue(PhpPsiBuilder builder, String text) {
        if (builder.compare(DOC_TEXT) && text.equals(builder.getTokenText())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    private static boolean tryParseAdvancedCallable(PhpPsiBuilder builder) {
        Namespace.parseReference(builder);
        if (!builder.compareAndEat(DOC_IDENTIFIER)) {
            return false;
        }
        if (!builder.compareAndEat(PhpDocTokenTypes.DOC_LPAREN)) {
            return false;
        }
        ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, ADVANCED_CLOSURE_PARAMETER.parse(builder), ADVANCED_CLOSURE_PARAMETER, PhpDocTokenTypes.DOC_COMMA, false, true);
        if (!builder.compareAndEat(PhpDocTokenTypes.DOC_RPAREN)) {
            return false;
        }
        if (builder.getTokenType() == DOC_TEXT && ":".equals(builder.getTokenText())) {
            builder.advanceLexer();
            if (builder.compareAndEat(DOC_LPAREN)) {
                return PhpDocTagParser.parseTypes(builder) && builder.compareAndEat(DOC_RPAREN);
            }
            return PhpDocTagParser.parseSingleDocType(builder);
        }
        return false;
    }

    protected static boolean parseProperty(PhpPsiBuilder builder) {
        if (builder.compare(DOC_LPAREN)) {
            PsiBuilder.Marker paren = builder.mark();
            builder.advanceLexer();
            while (!(builder.compare(DOC_RPAREN) || builder.compare(DOC_LEADING_ASTERISK) || builder.compare(DOC_COMMENT_END) || builder.compare(DOC_VARIABLE) || builder.eof())) {
                builder.advanceLexer();
            }
            if (builder.compare(DOC_RPAREN)) {
                builder.advanceLexer();
                paren.drop();
            } else {
                paren.rollbackTo();
            }
        }
        PsiBuilder.Marker tag = builder.mark();
        if ((builder.compareAndEat(DOC_VARIABLE) || builder.compareAndEat(DOC_IDENTIFIER)) && !builder.compare(DOC_NAMESPACE) && !builder.compare(DOC_PIPE)) {
            tag.done(phpDocProperty);
            return true;
        }
        tag.rollbackTo();
        return false;
    }

    private static void parseValue(PhpPsiBuilder builder, boolean inlineTag) {
        PsiBuilder.Marker value = builder.mark();
        boolean lbrace = false;
        while (!(builder.compare(DOC_TAG_VALUE_END) || builder.eof() || inlineTag && builder.compare(DOC_RBRACE))) {
            if (lbrace && builder.compare(DOC_TAG_NAME)) {
                PhpDocTagParserRegistry.parse(builder, true);
                continue;
            }
            lbrace = builder.compare(DOC_LBRACE);
            builder.advanceLexer();
        }
        value.done((IElementType)phpDocTagValue);
    }

    private static boolean parseExtendedDocRef(PhpPsiBuilder builder) {
        PsiBuilder.Marker ref = builder.mark();
        Namespace.parseReference(builder);
        if (!PhpDocTagParser.parseExtendedClassReference(builder)) {
            ref.rollbackTo();
            return false;
        }
        ref.done((IElementType)phpDocRef);
        return true;
    }

    private static boolean parseExtendedClassReference(@NotNull PhpPsiBuilder builder) {
        if (builder == null) {
            PhpDocTagParser.$$$reportNull$$$0(0);
        }
        if (!builder.compareAndEat(DOC_IDENTIFIER) || !builder.compareAndEat(DOC_STATIC)) {
            return false;
        }
        boolean identifierPresent = builder.compareAndEat(DOC_IDENTIFIER);
        return PhpDocTypeTagParser.compareAndEatText(builder, "*") || identifierPresent;
    }

    protected static boolean parseAssert(PhpPsiBuilder builder) {
        if (!PhpDocTagParser.parseTypes(builder)) {
            return false;
        }
        PsiBuilder.Marker ref = builder.mark();
        if (!PhpDocVarTagParser.parseVar(builder)) {
            ref.drop();
            return false;
        }
        if (builder.compareAndEat(DOC_ARROW)) {
            if (builder.compareAndEat(DOC_IDENTIFIER)) {
                builder.compareAndEat(DOC_LPAREN);
                builder.compareAndEat(DOC_RPAREN);
                ref.done((IElementType)phpDocRef);
            } else {
                ref.rollbackTo();
            }
        } else {
            ref.drop();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/php/lang/documentation/phpdoc/parser/tags/PhpDocTagParser", "parseExtendedClassReference"));
    }
}

