/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.lang.BasicPhpFile;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicPhpTypedHandler
extends TypedHandlerDelegate {
    private boolean myOpenTagStringInsideXmlTag;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        PsiElement element;
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(3);
        }
        if (c == ',' && file instanceof BasicPhpFile) {
            this.showMemberLookUp(project, editor);
        }
        CaretModel caret = editor.getCaretModel();
        int offset = caret.getOffset();
        this.myOpenTagStringInsideXmlTag = this.isOpenTagStringInsideXmlTag(c, editor, file, offset);
        if (BasicPhpTypedHandler.redundantCharAfterOpenTag(editor, c, file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                BasicPhpTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (c == '>' && offset > 0) {
            element = file.findElementAt(offset - 1);
            if (BasicPhpPsiUtil.isOfType(element, PhpTokenTypes.ARROW)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            if (BasicPhpPsiUtil.isOfType(element, PhpTokenTypes.opHASH_ARRAY) && BasicPhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.HASH_ARRAY_ELEMENT)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
        }
        if (c == ')' && (element = file.findElementAt(offset)) != null && PhpTokenTypes.CAST_OPERATORS.contains(element.getNode().getElementType()) && element.getTextRange().getEndOffset() - 1 == offset) {
            caret.moveToOffset(offset + 1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                BasicPhpTypedHandler.$$$reportNull$$$0(7);
            }
            return result;
        }
        if (c == ';') {
            this.tryToMoveSemicolon(file, editor);
        }
        TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(8);
        }
        return result;
    }

    protected abstract void showMemberLookUp(@NotNull Project var1, @NotNull Editor var2);

    protected abstract boolean isOpenTagStringInsideXmlTag(char var1, @NotNull Editor var2, @NotNull PsiFile var3, int var4);

    protected abstract void tryToMoveSemicolon(PsiFile var1, Editor var2);

    protected abstract boolean isAutoInsertFullPhpOpenTag();

    protected abstract boolean isInsertClosingHtmlTagInPhpDoc();

    protected abstract boolean isSingleHtmlTag(@NotNull String var1);

    protected abstract void showCompletion(Editor var1);

    protected abstract TypedHandlerDelegate.Result tryToAddOneLineDocComment(Editor var1, int var2, PsiFile var3, Project var4);

    protected abstract boolean isDocComment(PsiElement var1);

    protected abstract boolean isGroupStatement(@Nullable PsiElement var1);

    private static boolean redundantCharAfterOpenTag(@NotNull Editor editor, char c, @Nullable PsiFile file) {
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(9);
        }
        if (c == 'p' || c == 'h') {
            return BasicPhpPsiUtil.findFullPhpTagAtOffset(file, editor.getCaretModel().getOffset()) != null;
        }
        return false;
    }

    public boolean isImmediatePaintingEnabled(@NotNull Editor editor, char c, @NotNull DataContext context) {
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(11);
        }
        return !BasicPhpTypedHandler.redundantCharAfterOpenTag(editor, c, (PsiFile)context.getData(CommonDataKeys.PSI_FILE));
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(14);
        }
        int offset = editor.getCaretModel().getOffset();
        if (!this.myOpenTagStringInsideXmlTag && editor.getCaretModel().getCaretCount() == 1 && c == '?' && offset > 1 && '<' == editor.getDocument().getCharsSequence().charAt(offset - 2) && this.isAutoInsertFullPhpOpenTag()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement prevElement = file.findElementAt(offset - 1);
            if (BasicPhpPsiUtil.isOfType(prevElement, PhpTokenTypes.PHP_OPENING_TAG) && prevElement.getText().equals("<?")) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"php");
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        }
        if (!(file instanceof BasicPhpFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                BasicPhpTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        switch (c) {
            case '=': {
                PsiElement possibleArrayValue = BasicPhpPsiUtil.getPrevSiblingIgnoreWhitespace(file.findElementAt(offset - 1), true);
                if (!BasicPhpPsiUtil.isOfType(possibleArrayValue, PhpElementTypes.ARRAY_VALUE)) break;
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement typedEquals = file.findElementAt(offset - 1);
                if (typedEquals == null || !BasicPhpPsiUtil.isOfType(typedEquals.getParent(), PhpElementTypes.ASSIGNMENT_EXPRESSION) || !BasicPhpPsiUtil.isOfType(typedEquals.getParent().getParent(), PhpElementTypes.ARRAY_VALUE)) break;
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)">");
                break;
            }
            case '-': {
                if (offset > 6 && "$this-".equals(editor.getDocument().getCharsSequence().subSequence(offset - 6, offset).toString())) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)">");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    this.showCompletion(editor);
                }
            }
            case ' ': {
                TypedHandlerDelegate.Result result = this.tryToAddOneLineDocComment(editor, offset, file, project);
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(16);
                }
                return result;
            }
            case '{': {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(17);
                }
                return result;
            }
            case ':': {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement currElement = file.findElementAt(offset);
                if (currElement != null) {
                    currElement = currElement.getParent();
                    IElementType parentType = PsiUtilCore.getElementType((PsiElement)currElement);
                    if (currElement != null && (parentType == PhpElementTypes.CASE || parentType == PhpElementTypes.CASE_DEFAULT)) {
                        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, currElement.getTextOffset());
                    }
                }
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(18);
                }
                return result;
            }
            case ';': {
                this.autoIndentBreak(project, editor, file, offset);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(19);
                }
                return result;
            }
            case '@': {
                if (this.isInDocComment(project, editor, file, offset)) {
                    BasicPhpTypedHandler.stripExtraSpaces(editor, offset);
                }
            }
            case '>': {
                this.insertClosingHtmlTagInPhpDoc(project, editor, file);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    BasicPhpTypedHandler.$$$reportNull$$$0(20);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(21);
        }
        return result;
    }

    private void insertClosingHtmlTagInPhpDoc(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(23);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(24);
        }
        if (!this.isInsertClosingHtmlTagInPhpDoc()) {
            return;
        }
        PsiDocumentManager psiDocManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        psiDocManager.commitDocument(document);
        int offset = editor.getCaretModel().getOffset();
        if (document.getText().length() <= offset) {
            return;
        }
        PsiElement element = file.findElementAt(offset - 1);
        if (!BasicPhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_HTML_TAG) || BasicPhpTypedHandler.isClosingHtmlTag(element)) {
            return;
        }
        String tagName = BasicPhpTypedHandler.getTagName(element);
        if (tagName == null) {
            return;
        }
        PsiElement nextHtmlTagWithSameName = BasicPhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> tagName.equals(BasicPhpTypedHandler.getTagName(e))));
        if (BasicPhpTypedHandler.isClosingHtmlTag(nextHtmlTagWithSameName) || this.isSingleHtmlTag(tagName)) {
            return;
        }
        String closingTag = "</" + tagName + ">";
        document.insertString(offset, (CharSequence)closingTag);
    }

    @Nullable
    private static String getTagName(@NotNull PsiElement tag) {
        if (tag == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(25);
        }
        if (!BasicPhpPsiUtil.isOfType(tag, PhpDocTokenTypes.DOC_HTML_TAG)) {
            return null;
        }
        String prefix = StringUtil.substringBefore((String)tag.getText(), (String)">");
        if (prefix == null) {
            return null;
        }
        return BasicPhpTypedHandler.isClosingHtmlTag(tag) ? StringUtil.substringAfter((String)prefix, (String)"</") : StringUtil.substringAfter((String)prefix, (String)"<");
    }

    private static boolean isClosingHtmlTag(@Nullable PsiElement element) {
        return BasicPhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_HTML_TAG) && element.getText().startsWith("</");
    }

    private void autoIndentBreak(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        boolean indentBreak;
        if (project == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(27);
        }
        if (file == null) {
            BasicPhpTypedHandler.$$$reportNull$$$0(28);
        }
        if (!(indentBreak = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE).INDENT_BREAK_FROM_CASE)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement currElement = file.findElementAt(offset - 1);
            if (currElement != null && BasicPhpPsiUtil.isOfType(currElement = currElement.getParent(), PhpElementTypes.BREAK)) {
                PsiElement parent = currElement.getParent();
                if (this.isGroupStatement(parent)) {
                    parent = parent.getParent();
                }
                if (BasicPhpPsiUtil.isOfType(parent, PhpElementTypes.CASE)) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, currElement.getTextOffset());
                }
            }
        }
    }

    private static void stripExtraSpaces(Editor editor, int atOffset) {
        int lineEnd;
        int line;
        int lineStart;
        Document document = editor.getDocument();
        String original = document.getText(new TextRange(lineStart = document.getLineStartOffset(line = document.getLineNumber(atOffset)), lineEnd = document.getLineEndOffset(line)));
        Object replacement = original.substring(0, original.length() - 1);
        if ("*".equals(((String)replacement).trim())) {
            int starPos = ((String)replacement).indexOf(42);
            replacement = ((String)replacement).substring(0, starPos + 1) + " @";
            document.replaceString(lineStart, lineEnd, (CharSequence)replacement);
        }
    }

    private boolean isInDocComment(Project project, Editor editor, PsiFile file, int offset) {
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset);
        if (currElement != null) {
            PsiElement parent = currElement.getParent();
            return this.isDocComment(parent);
        }
        return false;
    }

    protected static boolean isCompleteDocComment(PsiElement docComment) {
        for (PsiElement child = docComment.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode childNode = child.getNode();
            if (childNode == null) {
                return false;
            }
            IElementType elementType = childNode.getElementType();
            if (child instanceof PsiErrorElement || elementType == PhpDocTokenTypes.DOC_IGNORED) {
                return false;
            }
            if (elementType != PhpDocTokenTypes.DOC_COMMENT_END) continue;
            return true;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 15, 16, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 14: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/editor/BasicPhpTypedHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/editor/BasicPhpTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "redundantCharAfterOpenTag";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isImmediatePaintingEnabled";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "insertClosingHtmlTagInPhpDoc";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "autoIndentBreak";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 15, 16, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

