/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.parser.BasicPhpStubElementTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface BasicPhpColorPageHighlighter {
    public static final IElementType INTERFACE = new HighlightingType("interface");
    public static final IElementType STATIC_METHOD_CALL = new HighlightingType("static_method_call");
    public static final IElementType INSTANCE_METHOD_CALL = new HighlightingType("instance_method_call");
    public static final IElementType PROTECTED_INSTANCE_METHOD_CALL = new HighlightingType("protected_instance_method_call");
    public static final IElementType PRIVATE_INSTANCE_METHOD_CALL = new HighlightingType("private_instance_method_call");
    public static final IElementType MAGIC_MEMBER = new HighlightingType("magic_member");
    public static final IElementType STATIC_FIELD = new HighlightingType("static_field");
    public static final IElementType VAR_VAR = new HighlightingType("var_var");
    public static final IElementType THIS_VARIABLE = new HighlightingType("this_variable");
    public static final IElementType ALIAS_REFERENCE = new HighlightingType("alias_reference");
    public static final IElementType PROTECTED_INSTANCE_FIELD = new HighlightingType("protected_instance_field");
    public static final IElementType PRIVATE_INSTANCE_FIELD = new HighlightingType("private_instance_field");
    public static final IElementType PRIMITIVE_TYPE_HINT = new HighlightingType("primitive_type_hint");
    public static final List<TokenPattern> PATTERNS = List.of(new TokenPattern("CONSTANT", "CONSTANT", PhpElementTypes.CONSTANTS), new TokenPattern("SomeClass", "SomeClass", BasicPhpStubElementTypes.CLASS), new TokenPattern("SomeAlias", "new SomeAlias();", ALIAS_REFERENCE), new TokenPattern("Another", "interface Another", INTERFACE), new TokenPattern("convert", "Helper::convert", STATIC_METHOD_CALL), new TokenPattern("invent", "$this->invent", INSTANCE_METHOD_CALL), new TokenPattern("createQueryBuilder", "$this->createQueryBuilder", INSTANCE_METHOD_CALL), new TokenPattern("where", "->where", INSTANCE_METHOD_CALL), new TokenPattern("setParameter", "->setParameter", INSTANCE_METHOD_CALL), new TokenPattern("protectedInvent", "$this->protectedInvent", PROTECTED_INSTANCE_METHOD_CALL), new TokenPattern("privateInvent", "$this->privateInvent", PRIVATE_INSTANCE_METHOD_CALL), new TokenPattern("magic", "self::magic", MAGIC_MEMBER), new TokenPattern("$my", "public $my", PhpElementTypes.CLASS_FIELDS), new TokenPattern("$myProtected", "protected $myProtected", PROTECTED_INSTANCE_FIELD), new TokenPattern("$myPrivate", "private $myPrivate", PRIVATE_INSTANCE_FIELD), new TokenPattern("result", "$q->result", PhpElementTypes.CLASS_FIELDS), new TokenPattern("$shared", "$shared", STATIC_FIELD), new TokenPattern("$this", "$this", THIS_VARIABLE), new TokenPattern("$abc", "$abc", BasicPhpStubElementTypes.NOT_PROMOTED_PARAMETER), new TokenPattern("$def", "$def", BasicPhpStubElementTypes.NOT_PROMOTED_PARAMETER), new TokenPattern("Label", "Label:", PhpElementTypes.GOTO_LABEL), new TokenPattern("$", "$$def", VAR_VAR), new TokenPattern("\u2116", "\u2116", TokenType.BAD_CHARACTER), new TokenPattern("Helper", "Helper::", BasicPhpStubElementTypes.CLASS), new TokenPattern("__FILE__", "__FILE__", PhpElementTypes.CONSTANTS), new TokenPattern("int $foo", "int", PRIMITIVE_TYPE_HINT));
    public static final Map<IElementType, TextAttributesKey[]> ATTRIBUTE_MAP = Map.ofEntries(Map.entry(BasicPhpStubElementTypes.FUNCTION, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.FUNCTION)), Map.entry(PhpElementTypes.FUNCTION_CALL, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.FUNCTION_CALL)), Map.entry(PhpElementTypes.CONSTANTS, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.CONSTANT)), Map.entry(BasicPhpStubElementTypes.CLASS, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.CLASS)), Map.entry(INTERFACE, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.INTERFACE)), Map.entry(STATIC_METHOD_CALL, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.STATIC_METHOD_CALL)), Map.entry(INSTANCE_METHOD_CALL, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.INSTANCE_METHOD_CALL)), Map.entry(PROTECTED_INSTANCE_METHOD_CALL, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.PROTECTED_INSTANCE_METHOD_CALL)), Map.entry(PRIVATE_INSTANCE_METHOD_CALL, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.PRIVATE_INSTANCE_METHOD_CALL)), Map.entry(PhpElementTypes.CLASS_FIELDS, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.INSTANCE_FIELD)), Map.entry(PROTECTED_INSTANCE_FIELD, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.PROTECTED_INSTANCE_FIELD)), Map.entry(PRIVATE_INSTANCE_FIELD, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.PRIVATE_INSTANCE_FIELD)), Map.entry(MAGIC_MEMBER, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.MAGIC_MEMBER_ACCESS)), Map.entry(STATIC_FIELD, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.STATIC_FIELD)), Map.entry(ALIAS_REFERENCE, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.ALIAS_REFERENCE)), Map.entry(BasicPhpStubElementTypes.NOT_PROMOTED_PARAMETER, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.PARAMETER)), Map.entry(PhpElementTypes.GOTO_LABEL, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.GOTO_LABEL)), Map.entry(VAR_VAR, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.VAR_VAR)), Map.entry(THIS_VARIABLE, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.THIS_VAR)), Map.entry(TokenType.BAD_CHARACTER, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.BAD_CHARACTER)), Map.entry(PRIMITIVE_TYPE_HINT, BasicPhpColorPageHighlighter.phpScript(PhpHighlightingData.PRIMITIVE_TYPE_HINT)));

    private static TextAttributesKey[] phpScript(@NotNull TextAttributesKey key) {
        if (key == null) {
            BasicPhpColorPageHighlighter.$$$reportNull$$$0(0);
        }
        return SyntaxHighlighterBase.pack((TextAttributesKey)key);
    }

    public static Map<Integer, IElementType> buildTypeMap(@NotNull String sample) {
        if (sample == null) {
            BasicPhpColorPageHighlighter.$$$reportNull$$$0(1);
        }
        HashMap<Integer, IElementType> typeMap = new HashMap<Integer, IElementType>();
        for (TokenPattern pattern : PATTERNS) {
            int patternOffset;
            int searchOffset = 0;
            if (pattern.patternText.isEmpty()) continue;
            while ((patternOffset = sample.indexOf(pattern.patternText, searchOffset)) >= 0) {
                int tokenOffset = sample.indexOf(pattern.tokenText, patternOffset);
                if (tokenOffset >= 0 && tokenOffset < patternOffset + pattern.patternText.length()) {
                    typeMap.put(tokenOffset, pattern.mappedType);
                }
                searchOffset = patternOffset + pattern.patternText.length();
            }
        }
        return typeMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/highlighter/BasicPhpColorPageHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "phpScript";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTypeMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TokenPattern {
        public String tokenText;
        public String patternText;
        public IElementType mappedType;

        TokenPattern(String tokenText, String patternText, IElementType mappedType) {
            this.tokenText = tokenText;
            this.patternText = patternText;
            this.mappedType = mappedType;
        }
    }

    public static class HighlightingType
    extends IElementType {
        HighlightingType(@NotNull @NonNls String debugName) {
            if (debugName == null) {
                HighlightingType.$$$reportNull$$$0(0);
            }
            super(debugName, (Language)PhpLanguage.INSTANCE, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/jetbrains/php/lang/highlighter/BasicPhpColorPageHighlighter$HighlightingType", "<init>"));
        }
    }
}

