/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.lexer.managers;

import com.jetbrains.php.lang.lexer._PhpLexer;
import it.unimi.dsi.fastutil.ints.IntArrayList;

public final class StatesManager {
    private final IntArrayList statesStack = new IntArrayList();
    private final _PhpLexer lexer;

    public StatesManager(_PhpLexer lexer) {
        this.lexer = lexer;
    }

    public void reset() {
        this.statesStack.clear();
    }

    public void toPreviousState() {
        assert (this.statesStack.size() >= 2) : this.statesStack.topInt() + ":" + this.lexer.getBuffer();
        this.statesStack.popInt();
        this.lexer.yybegin(this.statesStack.topInt());
    }

    public void toState(int state) {
        if (state % 2 == 1) {
            --state;
        }
        this.statesStack.push(state);
        this.lexer.yybegin(state);
    }

    public int getStackSize() {
        return this.statesStack.size();
    }
}

