/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpParserException;
import com.jetbrains.php.lang.parser.PhpPsiParser;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPsiBuilder {
    @NotNull
    public static final TokenSet QUESTION_MARKS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opQUEST, PhpTokenTypes.opCOALESCE});
    private final boolean myArrowFunctionSyntaxSupported;
    private final boolean myMatchExpressionSupported;
    private final boolean myAttributesSupported;
    private final boolean myReadonlyPropertiesSupported;
    private final boolean myReadonlyClassesSupported;
    @Nullable
    private final Project myProject;
    private boolean myAllowMultilineDocTypes;
    private final IntSet myRemappedFnTokenIndices;
    private boolean myInsideGenericArray;
    private final PsiBuilder psiBuilder;
    private final int myAllowedAdvanceCount;
    private int myAdvanceCount;

    public boolean compareArrowOrNullsafeArrow() {
        if (this.compare(PhpTokenTypes.ARROW)) {
            return true;
        }
        return this.compare(QUESTION_MARKS) && this.rawLookup(1) == PhpTokenTypes.ARROW;
    }

    public boolean attributesSupported() {
        return this.myAttributesSupported;
    }

    public boolean endOfLineRawToken() {
        int textEnd;
        int start = this.psiBuilder.rawTokenTypeStart(0);
        if (start == (textEnd = this.psiBuilder.getOriginalText().length())) {
            return true;
        }
        int end = this.psiBuilder.rawTokenTypeStart(1);
        CharSequence tokenText = this.psiBuilder.getOriginalText().subSequence(start, end);
        return StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"\n") || StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"\r") || StringUtil.endsWith((CharSequence)tokenText, (CharSequence)"?>");
    }

    public boolean isAllowMultilineDocTypes() {
        return this.myAllowMultilineDocTypes;
    }

    public void setAllowMultilineDocTypes(boolean allowMultilineDocTypes) {
        this.myAllowMultilineDocTypes = allowMultilineDocTypes;
    }

    public boolean isInsideGenericArray() {
        return this.myInsideGenericArray;
    }

    public void setInsideGenericArray(boolean insideGenericArray) {
        this.myInsideGenericArray = insideGenericArray;
    }

    private static boolean isEapOrUnitTestMode() {
        return ApplicationManager.getApplication().isEAP() || ApplicationManager.getApplication().isUnitTestMode();
    }

    public PhpPsiBuilder(@Nullable Project project, @NotNull PsiBuilder builder) {
        if (builder == null) {
            PhpPsiBuilder.$$$reportNull$$$0(0);
        }
        this.myRemappedFnTokenIndices = new IntOpenHashSet();
        this.psiBuilder = builder;
        int allowedAdvanceCount = PhpPsiBuilder.getLexemeCount(builder) * Registry.get((String)"php.allowed.parser.advancement.count").asInteger();
        this.myAllowedAdvanceCount = allowedAdvanceCount > 0 ? allowedAdvanceCount : Integer.MAX_VALUE;
        this.myArrowFunctionSyntaxSupported = project != null && PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(project);
        this.myMatchExpressionSupported = project != null && PhpLanguageFeature.MATCH_EXPRESSION.isSupported(project);
        this.myAttributesSupported = project != null && PhpLanguageFeature.ATTRIBUTES.isSupported(project);
        this.myReadonlyPropertiesSupported = project != null && PhpLanguageFeature.READONLY_PROPERTIES.isSupported(project);
        this.myReadonlyClassesSupported = project != null && PhpLanguageFeature.READONLY_CLASSES.isSupported(project);
        this.myProject = project;
    }

    private static int getLexemeCount(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PhpPsiBuilder.$$$reportNull$$$0(1);
        }
        return builder instanceof PsiBuilderImpl ? ((PsiBuilderImpl)builder).getLexemeCount() : 0;
    }

    public boolean compare(IElementType type) {
        if (this.myAllowMultilineDocTypes) {
            PsiBuilder.Marker mark = this.mark();
            this.eatLeadingAsteriskInsideBraces();
            boolean res = this.getTokenType() == type;
            mark.rollbackTo();
            return res;
        }
        return this.getTokenType() == type;
    }

    private void eatLeadingAsteriskInsideBraces() {
        try {
            this.myAllowMultilineDocTypes = false;
            this.doEatLeadingAsteriskInsideBraces();
        }
        finally {
            this.myAllowMultilineDocTypes = true;
        }
    }

    private void doEatLeadingAsteriskInsideBraces() {
        PsiBuilder.Marker mark = this.mark();
        if (this.compareAndEat(PhpTokenTypes.DOC_LEADING_ASTERISK) && this.compareAndEat(PhpTokenTypes.DOC_TAG_NAME)) {
            mark.rollbackTo();
            return;
        }
        mark.drop();
    }

    public boolean compare(TokenSet types) {
        return types.contains(this.getTokenType());
    }

    public IElementType rawLookup(int steps) {
        return this.psiBuilder.rawLookup(steps);
    }

    public List<? extends SyntaxTreeBuilder.Production> getProductions() {
        return this.psiBuilder.getProductions();
    }

    public IElementType lookAhead() {
        return this.psiBuilder.lookAhead(1);
    }

    @Contract(mutates="this")
    public boolean compareAndEat(IElementType type) {
        boolean found = this.compare(type);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    public boolean compareAndEat(TokenSet types) {
        boolean found = this.compare(types);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    public void match(IElementType token) {
        if (!this.compareAndEat(token)) {
            this.error(PhpParserErrors.expected(token));
        }
    }

    public void match(IElementType token, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            PhpPsiBuilder.$$$reportNull$$$0(2);
        }
        if (!this.compareAndEat(token)) {
            this.error(errorMessage);
        }
    }

    public void match(TokenSet tokens) {
        if (!this.compareAndEat(tokens)) {
            this.error(PhpParserErrors.expected(tokens));
        }
    }

    public void match(TokenSet tokens, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            PhpPsiBuilder.$$$reportNull$$$0(3);
        }
        if (!this.compareAndEat(tokens)) {
            this.error(errorMessage);
        }
    }

    @Contract(mutates="this")
    public void advanceLexer() {
        ++this.myAdvanceCount;
        this.psiBuilder.advanceLexer();
        if (this.myAllowMultilineDocTypes) {
            this.eatLeadingAsteriskInsideBraces();
        }
        this.incrementAdvanceCount();
    }

    private void incrementAdvanceCount() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myProject.putUserData(PhpPsiParser.ADVANCEMENT_COUNT, (Object)(1 + (Integer)ObjectUtils.notNull((Object)((Integer)this.myProject.getUserData(PhpPsiParser.ADVANCEMENT_COUNT)), (Object)0)));
        }
    }

    public PsiBuilder.Marker mark() {
        return this.psiBuilder.mark();
    }

    public void error(@NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            PhpPsiBuilder.$$$reportNull$$$0(4);
        }
        this.psiBuilder.error(errorMessage);
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myAdvanceCount > this.myAllowedAdvanceCount || this.myAdvanceCount < 0) {
            Attachment attachment = new Attachment("unparseable.php", this.psiBuilder.getOriginalText().toString());
            throw new PhpParserException("Lexer has been advanced " + (this.myAdvanceCount > 0 ? this.myAdvanceCount : Integer.MAX_VALUE) + " times while the amount of lexeme is " + PhpPsiBuilder.getLexemeCount(this.psiBuilder), attachment);
        }
        IElementType tokenType = this.psiBuilder.getTokenType();
        if (tokenType == PhpTokenTypes.kwFN && !this.myArrowFunctionSyntaxSupported) {
            this.myRemappedFnTokenIndices.add(this.psiBuilder.rawTokenIndex());
            this.remapCurrentToken(PhpTokenTypes.IDENTIFIER);
            return PhpTokenTypes.IDENTIFIER;
        }
        return tokenType;
    }

    public boolean compareFnWithoutRemapping() {
        IElementType tokenType = this.getTokenType();
        return tokenType == PhpTokenTypes.kwFN || this.isCurrentTokenRemappedFromFn(tokenType);
    }

    private boolean isCurrentTokenRemappedFromFn(IElementType tokenType) {
        if (this.myArrowFunctionSyntaxSupported) {
            return false;
        }
        return tokenType == PhpTokenTypes.IDENTIFIER && this.myRemappedFnTokenIndices.contains(this.psiBuilder.rawTokenIndex());
    }

    public void remapBackToFnIfNeeded() {
        if (this.myArrowFunctionSyntaxSupported) {
            return;
        }
        IElementType tokenType = this.getTokenType();
        if (this.isCurrentTokenRemappedFromFn(tokenType)) {
            this.remapCurrentToken(PhpTokenTypes.kwFN);
            this.myRemappedFnTokenIndices.remove(this.psiBuilder.rawTokenIndex());
        }
    }

    @Nullable
    @NlsSafe
    public String getTokenText() {
        return this.psiBuilder.getTokenText();
    }

    public boolean eof() {
        return this.psiBuilder.eof();
    }

    public ASTNode getTreeBuilt() {
        return this.psiBuilder.getTreeBuilt();
    }

    public int getCurrentOffset() {
        return this.psiBuilder.getCurrentOffset();
    }

    public boolean arrowFunctionSyntaxSupported() {
        return this.myArrowFunctionSyntaxSupported;
    }

    public boolean matchExpressionSupported() {
        return this.myMatchExpressionSupported;
    }

    public boolean readonlyPropertiesSupported() {
        return this.myReadonlyPropertiesSupported;
    }

    public boolean readonlyClassesSupported() {
        return this.myReadonlyClassesSupported;
    }

    public void remapCurrentTokenWithDocQuestion() {
        this.remapCurrentToken(PhpDocTokenTypes.DOC_QUESTION_MARK);
    }

    public void remapToIdentifier() {
        this.remapCurrentToken(PhpTokenTypes.IDENTIFIER);
    }

    public void remapToMatchKeyword() {
        this.remapCurrentToken(PhpTokenTypes.kwMATCH);
    }

    public void remapCurrentTokenWithDocPipe() {
        this.remapCurrentToken(PhpTokenTypes.DOC_PIPE);
    }

    public void remapCurrentToken(IElementType type) {
        this.psiBuilder.remapCurrentToken(type);
    }

    @ApiStatus.Internal
    public int getAdvanceCount() {
        return this.myAdvanceCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/parser/PhpPsiBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLexemeCount";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

