/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.BasicPhpStubElementTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.Scalar;
import java.util.List;

public final class Namespace {
    private static final TokenSet STOPS2 = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLPAREN, PhpTokenTypes.SCOPE_RESOLUTION});
    private static final WhitespacesAndCommentsBinder NON_BRACED_NAMESPACE_LEFT_BINDER = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            for (int i = 0; i < tokens.size(); ++i) {
                if (PhpTokenTypes.WHITE_SPACE == tokens.get(i)) continue;
                return i;
            }
            return tokens.size();
        }
    };

    public static IElementType parseDeclaration(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwNAMESPACE)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker ns = builder.mark();
        builder.advanceLexer();
        if (builder.compare(PhpTokenTypes.NAMESPACE_RESOLUTION)) {
            ns.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        IElementType result = Namespace.parseReference(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            builder.match(PhpTokenTypes.IDENTIFIER);
        } else if (builder.compare(PhpTokenTypes.tsKEYWORDS)) {
            if (!builder.compare(PhpTokenTypes.kwNAMESPACE)) {
                builder.remapToIdentifier();
            }
            builder.advanceLexer();
        } else {
            builder.compareAndEat(PhpTokenTypes.IDENTIFIER);
        }
        if (builder.compare(STOPS2)) {
            ns.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        boolean braced = builder.compare(PhpTokenTypes.chLBRACE);
        if (!braced) {
            builder.match(PhpTokenTypes.opSEMICOLON);
        }
        if (braced) {
            StatementList.parseFast(builder);
        } else {
            PsiBuilder.Marker statementList = builder.mark();
            statementList.setCustomEdgeTokenBinders(NON_BRACED_NAMESPACE_LEFT_BINDER, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            StatementList.parseAccurate(builder, b -> b.getTokenType() == PhpTokenTypes.kwNAMESPACE && b.lookAhead() != PhpTokenTypes.NAMESPACE_RESOLUTION, statementList);
        }
        ns.done(BasicPhpStubElementTypes.NAMESPACE);
        return BasicPhpStubElementTypes.NAMESPACE;
    }

    public static IElementType parseUse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwUSE)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker useList = builder.mark();
        builder.advanceLexer();
        IElementType kind = null;
        if (builder.compareAndEat(PhpTokenTypes.kwCONST)) {
            kind = PhpTokenTypes.kwCONST;
        } else if (builder.compareAndEat(PhpTokenTypes.kwFUNCTION)) {
            kind = PhpTokenTypes.kwFUNCTION;
        }
        PsiBuilder.Marker braced = builder.mark();
        Namespace.parseReference(builder);
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            builder.advanceLexer();
        } else {
            braced.rollbackTo();
            braced = null;
        }
        while (braced == null || !builder.compare(PhpTokenTypes.chRBRACE)) {
            IElementType result;
            PsiBuilder.Marker use = builder.mark();
            IElementType localKind = kind;
            if (kind == null) {
                if (builder.compareAndEat(PhpTokenTypes.kwCONST)) {
                    localKind = PhpTokenTypes.kwCONST;
                } else if (builder.compareAndEat(PhpTokenTypes.kwFUNCTION)) {
                    localKind = PhpTokenTypes.kwFUNCTION;
                }
            } else if (builder.compare(PhpTokenTypes.kwCONST) || builder.compare(PhpTokenTypes.kwFUNCTION)) {
                builder.error(PhpFrontBackBundle.message("parsing.error.not.allowed", builder.getTokenText()));
                builder.advanceLexer();
            }
            if (localKind == PhpTokenTypes.kwFUNCTION) {
                PsiBuilder.Marker fun = builder.mark();
                Namespace.parseReference(builder);
                builder.match(PhpTokenTypes.IDENTIFIER);
                result = PhpElementTypes.FUNCTION_CALL;
                fun.done(result);
            } else {
                result = localKind == PhpTokenTypes.kwCONST ? Scalar.parse(builder) : ClassReference.parse(builder);
            }
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("class.reference", new Object[0])));
            }
            if (builder.compareAndEat(PhpTokenTypes.kwAS)) {
                builder.match(PhpTokenTypes.IDENTIFIER);
            }
            use.done(BasicPhpStubElementTypes.USE);
            if (builder.compareAndEat(PhpTokenTypes.opCOMMA)) continue;
        }
        if (braced != null) {
            builder.match(PhpTokenTypes.chRBRACE);
            braced.done(PhpElementTypes.USE_BRACES);
        }
        builder.match(PhpTokenTypes.opSEMICOLON);
        useList.done(BasicPhpStubElementTypes.USE_LIST);
        return BasicPhpStubElementTypes.USE_LIST;
    }

    public static IElementType parseReference(PhpPsiBuilder builder) {
        PsiBuilder.Marker res = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwNAMESPACE) && !builder.compareAndEat(PhpTokenTypes.NAMESPACE_RESOLUTION)) {
            res.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        res.drop();
        PsiBuilder.Marker namespace = builder.mark();
        int ns = 0;
        if (builder.compareAndEat(PhpTokenTypes.NAMESPACE_RESOLUTION) || builder.compareAndEat(PhpTokenTypes.DOC_NAMESPACE)) {
            ++ns;
        }
        PsiBuilder.Marker rollback = builder.mark();
        while ((builder.compareAndEat(PhpTokenTypes.IDENTIFIER) || builder.compareAndEat(PhpTokenTypes.DOC_IDENTIFIER)) && builder.rawLookup(0) != PhpTokenTypes.DOC_WHITESPACE && (builder.compareAndEat(PhpTokenTypes.NAMESPACE_RESOLUTION) || builder.compareAndEat(PhpTokenTypes.DOC_NAMESPACE))) {
            if (builder.compareAndEat(PhpTokenTypes.tsKEYWORDS)) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("identifier", new Object[0])));
            }
            ++ns;
            rollback.drop();
            rollback = builder.mark();
        }
        rollback.rollbackTo();
        if (ns == 0) {
            namespace.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        namespace.done(PhpElementTypes.NS_REFERENCE);
        return PhpElementTypes.NS_REFERENCE;
    }
}

